/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.query.sge;

import cms.tmx.http.api.ObInstrument;
import cms.tmx.http.query.sge.SgeStorage;
import cms.tmx.javafx.obj.MxDirtySelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSgeStorage
extends MxDirtySelObj {
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private ObInstrument instrument;
    private String tradeDate = "";
    private String secAccntId = "";
    private String accntId = "";
    private DoubleProperty balance = new SimpleDoubleProperty(0.0);
    private DoubleProperty available = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty impawnIn = new SimpleDoubleProperty(0.0);
    private DoubleProperty transOut = new SimpleDoubleProperty(0.0);
    private DoubleProperty takeOut = new SimpleDoubleProperty(0.0);
    private DoubleProperty lawFrozen = new SimpleDoubleProperty(0.0);
    private DoubleProperty pledge = new SimpleDoubleProperty(0.0);

    public ObSgeStorage() {
        this.instrument = new ObInstrument();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.instrument.getSecId() == null ? 0 : this.instrument.getSecId().hashCode());
        result = 31 * result + (this.instrument.getMarket() == null ? 0 : this.instrument.getMarket().getRaw().hashCode());
        result = 31 * result + (this.instrument.getSecType() == null ? 0 : this.instrument.getSecType().hashCode());
        result = 31 * result + (this.secAccntId == null ? 0 : this.secAccntId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSgeStorage other = (ObSgeStorage)((Object)obj);
        if (this.instrument.getSecId() == null ? other.getInstrument().getSecId() != null : !this.instrument.getSecId().equals(other.getInstrument().getSecId())) {
            return false;
        }
        if (this.instrument.getMarket() == null ? other.getInstrument().getMarket() != null : !this.instrument.getMarket().getRaw().equals(other.getInstrument().getMarket().getRaw())) {
            return false;
        }
        if (this.instrument.getSecType() == null ? other.getInstrument().getSecType() != null : !this.instrument.getSecType().equals(other.getInstrument().getSecType())) {
            return false;
        }
        return !(this.secAccntId == null ? other.secAccntId != null : !this.secAccntId.equals(other.secAccntId));
    }

    public void update(Object obj) {
        if (obj instanceof ObSgeStorage) {
            ObSgeStorage s = (ObSgeStorage)((Object)ObSgeStorage.class.cast(obj));
            this.update(s);
        } else if (obj instanceof SgeStorage) {
            SgeStorage s = (SgeStorage)((Object)SgeStorage.class.cast(obj));
            this.update(s);
        }
    }

    private void update(ObSgeStorage s) {
        this.instrument.update((Object)s.getInstrument());
        this.setTradeDate(s.getTradeDate());
        this.setSecAccntId(s.getSecAccntId());
        this.setAccntId(s.getAccntId());
        this.setInvestorId(s.getInvestorId());
        this.setInvestorSecId(s.getInvestorSecId());
        this.setBalance(s.getBalance());
        this.setAvailable(s.getAvailable());
        this.setFrozenQty(s.getFrozenQty());
        this.setImpawnIn(s.getImpawnIn());
        this.setTransOut(s.getTransOut());
        this.setTakeOut(s.getTakeOut());
        this.setLawFrozen(s.getLawFrozen());
        this.setPledge(s.getPledge());
    }

    private void update(SgeStorage s) {
        this.instrument.update((Object)s.getInstrument());
        this.setTradeDate(s.getTradeDate());
        this.setSecAccntId(s.getSecAccntId());
        this.setAccntId(s.getAccntId());
        this.setInvestorId(s.getInvestorId());
        this.setInvestorSecId(s.getInvestorSecId());
        this.setBalance((double)Math.round(s.getBalance() * 1000.0) / 1000.0);
        this.setAvailable(s.getAvailable());
        this.setFrozenQty(s.getFrozenQty());
        this.setImpawnIn(s.getImpawnIn());
        this.setTransOut(s.getTransOut());
        this.setTakeOut(s.getTakeOut());
        this.setLawFrozen(s.getLawFrozen());
        this.setPledge(s.getPledge());
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public DoubleProperty balanceProperty() {
        return this.balance;
    }

    public double getBalance() {
        return this.balanceProperty().get();
    }

    public void setBalance(double balance) {
        this.balanceProperty().set(balance);
    }

    public DoubleProperty availableProperty() {
        return this.available;
    }

    public double getAvailable() {
        return this.availableProperty().get();
    }

    public void setAvailable(double available) {
        this.availableProperty().set(available);
    }

    public DoubleProperty frozenQtyProperty() {
        return this.frozenQty;
    }

    public double getFrozenQty() {
        return this.frozenQtyProperty().get();
    }

    public void setFrozenQty(double frozenQty) {
        this.frozenQtyProperty().set(frozenQty);
    }

    public DoubleProperty impawnInProperty() {
        return this.impawnIn;
    }

    public double getImpawnIn() {
        return this.impawnInProperty().get();
    }

    public void setImpawnIn(double impawnIn) {
        this.impawnInProperty().set(impawnIn);
    }

    public DoubleProperty transOutProperty() {
        return this.transOut;
    }

    public double getTransOut() {
        return this.transOutProperty().get();
    }

    public void setTransOut(double transOut) {
        this.transOutProperty().set(transOut);
    }

    public ObInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(ObInstrument instrument) {
        this.instrument = instrument;
    }

    public String getTradeDate() {
        return this.tradeDate;
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDate = tradeDate;
    }

    public String getSecAccntId() {
        return this.secAccntId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public String getAccntId() {
        return this.accntId;
    }

    public void setAccntId(String accntId) {
        this.accntId = accntId;
    }

    public DoubleProperty takeOutProperty() {
        return this.takeOut;
    }

    public double getTakeOut() {
        return this.takeOutProperty().get();
    }

    public void setTakeOut(double takeOut) {
        this.takeOutProperty().set(takeOut);
    }

    public DoubleProperty lawFrozenProperty() {
        return this.lawFrozen;
    }

    public double getLawFrozen() {
        return this.lawFrozenProperty().get();
    }

    public void setLawFrozen(double lawFrozen) {
        this.lawFrozenProperty().set(lawFrozen);
    }

    public DoubleProperty pledgeProperty() {
        return this.pledge;
    }

    public double getPledge() {
        return this.pledgeProperty().get();
    }

    public void setPledge(double pledge) {
        this.pledgeProperty().set(pledge);
    }
}

