/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.query.sge;

import cms.tmx.http.api.ObInstrument;
import cms.tmx.http.query.sge.Direction;
import cms.tmx.http.query.sge.SgePosition;
import cms.tmx.javafx.obj.MxDirtySelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSgePosition
extends MxDirtySelObj {
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private ObInstrument instrument;
    private String tradeDate = "";
    private String secAccntId = "";
    private String accntId = "";
    private String extCashAccntId = "";
    private DoubleProperty balance = new SimpleDoubleProperty(0.0);
    private DoubleProperty available = new SimpleDoubleProperty(0.0);
    private DoubleProperty realizedPnl = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastPx = new SimpleDoubleProperty(0.0);
    private DoubleProperty cost = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty holdCostAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty profit = new SimpleDoubleProperty(0.0);
    private DoubleProperty margin = new SimpleDoubleProperty(0.0);
    private int direction;
    private StringProperty dire = new SimpleStringProperty("");
    private long canCloseTdLong;
    private long canCloseYdLong;
    private long canCloseTdShort;
    private long canCloseYdShort;
    private DoubleProperty ydBalance = new SimpleDoubleProperty(0.0);
    private DoubleProperty tdBalance = new SimpleDoubleProperty(0.0);
    private double newPrice;

    public ObSgePosition() {
        this.instrument = new ObInstrument();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.instrument.getSecId() == null ? 0 : this.instrument.getSecId().hashCode());
        result = 31 * result + (this.instrument.getMarket() == null ? 0 : this.instrument.getMarket().getRaw().hashCode());
        result = 31 * result + (this.instrument.getSecType() == null ? 0 : this.instrument.getSecType().hashCode());
        result = 31 * result + (this.secAccntId == null ? 0 : this.secAccntId.hashCode());
        result = 31 * result + (this.tradeDate == null ? 0 : this.tradeDate.hashCode());
        result = 31 * result + (this.dire.get() == null ? 0 : ((String)this.dire.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSgePosition other = (ObSgePosition)((Object)obj);
        if (this.instrument.getSecId() == null ? other.getInstrument().getSecId() != null : !this.instrument.getSecId().equals(other.getInstrument().getSecId())) {
            return false;
        }
        if (this.instrument.getMarket() == null ? other.getInstrument().getMarket() != null : !this.instrument.getMarket().getRaw().equals(other.getInstrument().getMarket().getRaw())) {
            return false;
        }
        if (this.instrument.getSecType() == null ? other.getInstrument().getSecType() != null : !this.instrument.getSecType().equals(other.getInstrument().getSecType())) {
            return false;
        }
        if (this.secAccntId == null ? other.secAccntId != null : !this.secAccntId.equals(other.secAccntId)) {
            return false;
        }
        if (this.tradeDate == null ? other.tradeDate != null : !this.tradeDate.equals(other.tradeDate)) {
            return false;
        }
        return !(this.dire.get() == null ? other.dire.get() != null : !((String)this.dire.get()).equals(other.dire.get()));
    }

    public void update(Object obj) {
        if (obj instanceof ObSgePosition) {
            ObSgePosition s = (ObSgePosition)((Object)ObSgePosition.class.cast(obj));
            this.update(s);
        } else if (obj instanceof SgePosition) {
            SgePosition s = (SgePosition)((Object)SgePosition.class.cast(obj));
            this.update(s);
        }
    }

    private void update(ObSgePosition p) {
        this.instrument.update((Object)p.getInstrument());
        this.setTradeDate(p.getTradeDate());
        this.setSecAccntId(p.getSecAccntId());
        this.setAccntId(p.getAccntId());
        this.setExtCashAccntId(p.getExtCashAccntId());
        this.setInvestorId(p.getInvestorId());
        this.setInvestorSecId(p.getInvestorSecId());
        this.setBalance(p.getBalance());
        this.setAvailable(p.getAvailable());
        this.setDirection(p.getDirection());
        this.setDire(p.getDire());
        this.setProfit(p.getProfit());
        this.setCost(p.getCost());
        this.setLastPx(p.getLastPx());
        this.setBuyCostAmt(p.getBuyCostAmt());
        this.setHoldCostAmount(p.getHoldCostAmount());
        this.setRealizedPnl(p.getRealizedPnl());
        this.setMargin(p.getMargin());
        this.setYdBalance(p.getYdBalance());
        this.setTdBalance(p.getTdBalance());
        this.setCanCloseTdLong(p.getCanCloseTdLong());
        this.setCanCloseYdLong(p.getCanCloseYdLong());
        this.setCanCloseTdShort(p.getCanCloseTdShort());
        this.setCanCloseYdShort(p.getCanCloseYdShort());
        this.setNewPrice(p.getNewPrice());
    }

    private void update(SgePosition p) {
        this.instrument.update((Object)p.getInstrument());
        this.setTradeDate(p.getTradeDate());
        this.setSecAccntId(p.getSecAccntId());
        this.setAccntId(p.getAccntId());
        this.setInvestorId(p.getInvestorId());
        this.setInvestorSecId(p.getInvestorSecId());
        this.setBalance((double)Math.round(p.getBalance() * 1000.0) / 1000.0);
        this.setAvailable((double)Math.round(p.getAvailable() * 1000.0) / 1000.0);
        this.setDirection(p.getDirection());
        this.setDire(Direction.getDesc(p.getDirection()));
        this.setCost((double)Math.round(p.getCost() * 1000.0) / 1000.0);
        this.setBuyCostAmt((double)Math.round(p.getBuyCostAmount() * 1000.0) / 1000.0);
        this.setHoldCostAmount((double)Math.round(p.getHoldCostAmount() * 1000.0) / 1000.0);
        this.setMargin((double)Math.round(p.getMargin() * 100.0) / 100.0);
        this.setYdBalance((double)Math.round(p.getYdBalance() * 1000.0) / 1000.0);
        this.setTdBalance((double)Math.round(p.getTdBalance() * 1000.0) / 1000.0);
        this.setRealizedPnl((double)Math.round(p.getRealizedPnl() * 1000.0) / 1000.0);
        if (p.getDirection() == Integer.parseInt("1")) {
            this.setCanCloseTdLong(new Double(p.getTdAvailable()).longValue());
            this.setCanCloseYdLong(new Double(p.getYdAvailable()).longValue());
        } else {
            this.setCanCloseTdShort(new Double(p.getTdAvailable()).longValue());
            this.setCanCloseYdShort(new Double(p.getYdAvailable()).longValue());
        }
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public DoubleProperty balanceProperty() {
        return this.balance;
    }

    public double getBalance() {
        return this.balanceProperty().get();
    }

    public void setBalance(double balance) {
        this.balanceProperty().set(balance);
    }

    public DoubleProperty availableProperty() {
        return this.available;
    }

    public double getAvailable() {
        return this.availableProperty().get();
    }

    public void setAvailable(double available) {
        this.availableProperty().set(available);
    }

    public DoubleProperty realizedPnlProperty() {
        return this.realizedPnl;
    }

    public double getRealizedPnl() {
        return this.realizedPnlProperty().get();
    }

    public void setRealizedPnl(double realizedPnl) {
        this.realizedPnlProperty().set(realizedPnl);
    }

    public DoubleProperty lastPxProperty() {
        return this.lastPx;
    }

    public double getLastPx() {
        return this.lastPxProperty().get();
    }

    public void setLastPx(double lastPx) {
        this.lastPxProperty().set(lastPx);
    }

    public ObInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(ObInstrument instrument) {
        this.instrument = instrument;
    }

    public String getTradeDate() {
        return this.tradeDate;
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDate = tradeDate;
    }

    public String getSecAccntId() {
        return this.secAccntId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public String getAccntId() {
        return this.accntId;
    }

    public void setAccntId(String accntId) {
        this.accntId = accntId;
    }

    public DoubleProperty profitProperty() {
        return this.profit;
    }

    public double getProfit() {
        return this.profitProperty().get();
    }

    public void setProfit(double profit) {
        this.profitProperty().set(profit);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public StringProperty direProperty() {
        return this.dire;
    }

    public String getDire() {
        return (String)this.direProperty().get();
    }

    public void setDire(String dire) {
        this.direProperty().set((Object)dire);
    }

    public DoubleProperty costProperty() {
        return this.cost;
    }

    public double getCost() {
        return this.costProperty().get();
    }

    public void setCost(double cost) {
        this.costProperty().set(cost);
    }

    public DoubleProperty buyCostAmtProperty() {
        return this.buyCostAmt;
    }

    public double getBuyCostAmt() {
        return this.buyCostAmtProperty().get();
    }

    public void setBuyCostAmt(double buyCostAmt) {
        this.buyCostAmtProperty().set(buyCostAmt);
    }

    public DoubleProperty marginProperty() {
        return this.margin;
    }

    public double getMargin() {
        return this.marginProperty().get();
    }

    public void setMargin(double margin) {
        this.marginProperty().set(margin);
    }

    public DoubleProperty ydBalanceProperty() {
        return this.ydBalance;
    }

    public double getYdBalance() {
        return this.ydBalanceProperty().get();
    }

    public void setYdBalance(double ydBalance) {
        this.ydBalanceProperty().set(ydBalance);
    }

    public DoubleProperty tdBalanceProperty() {
        return this.tdBalance;
    }

    public double getTdBalance() {
        return this.tdBalanceProperty().get();
    }

    public void setTdBalance(double tdBalance) {
        this.tdBalanceProperty().set(tdBalance);
    }

    public long getCanCloseTdLong() {
        return this.canCloseTdLong;
    }

    public void setCanCloseTdLong(long canCloseTdLong) {
        this.canCloseTdLong = canCloseTdLong;
    }

    public long getCanCloseYdLong() {
        return this.canCloseYdLong;
    }

    public void setCanCloseYdLong(long canCloseYdLong) {
        this.canCloseYdLong = canCloseYdLong;
    }

    public long getCanCloseTdShort() {
        return this.canCloseTdShort;
    }

    public void setCanCloseTdShort(long canCloseTdShort) {
        this.canCloseTdShort = canCloseTdShort;
    }

    public long getCanCloseYdShort() {
        return this.canCloseYdShort;
    }

    public void setCanCloseYdShort(long canCloseYdShort) {
        this.canCloseYdShort = canCloseYdShort;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public final DoubleProperty holdCostAmountProperty() {
        return this.holdCostAmount;
    }

    public final double getHoldCostAmount() {
        return this.holdCostAmountProperty().get();
    }

    public final void setHoldCostAmount(double holdCostAmount) {
        this.holdCostAmountProperty().set(holdCostAmount);
    }
}

