/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.query.sge;

import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.query.sge.SgeCash;
import cms.tmx.javafx.obj.MxObject;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSgeCash
extends MxObject {
    private String cashAccntId;
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty currencyId = new SimpleStringProperty("");
    private double balance;
    private DoubleProperty available = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenAmount = new SimpleDoubleProperty(0.0);

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cashAccntId == null ? 0 : this.cashAccntId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSgeCash other = (ObSgeCash)((Object)obj);
        return !(this.cashAccntId == null ? other.getCashAccntId() != null : !this.cashAccntId.equals(other.cashAccntId));
    }

    public void update(Object obj) {
        if (obj instanceof ObSgeCash) {
            ObSgeCash s = (ObSgeCash)((Object)ObSgeCash.class.cast(obj));
            this.update(s);
        } else if (obj instanceof SgeCash) {
            SgeCash s = (SgeCash)((Object)SgeCash.class.cast(obj));
            this.update(s);
        } else if (obj instanceof XtPosition) {
            XtPosition s = (XtPosition)((Object)XtPosition.class.cast(obj));
            this.update(s);
        }
    }

    private void update(ObSgeCash s) {
        this.setCashAccntId(s.getCashAccntId());
        this.setInvestorId(s.getInvestorId());
        this.setCurrencyId(s.getCurrencyId());
        this.setBalance(s.getBalance());
        this.setAvailable(s.getAvailable());
        this.setFrozenAmount(s.getFrozenAmount());
    }

    private void update(SgeCash s) {
        this.setCashAccntId(s.getCashAccntId());
        this.setInvestorId(s.getInvestorId());
        if ("CNY".equals(s.getCurrencyId())) {
            this.setCurrencyId("\u4eba\u6c11\u5e01");
        } else if ("HKD".equals(s.getCurrencyId())) {
            this.setCurrencyId("\u6e2f\u5e01");
        }
        this.setBalance((double)Math.round(s.getBalance() * 100.0) / 100.0);
        this.setAvailable((double)Math.round(s.getAvailable() * 100.0) / 100.0);
        this.setFrozenAmount((double)Math.round(s.getFrozenAmount() * 100.0) / 100.0);
    }

    private void update(XtPosition s) {
        this.setCashAccntId(s.getCashAccntId());
        this.setInvestorId(s.getInvestorId());
        if ("CNY".equals(s.getCurrencyId())) {
            this.setCurrencyId("\u4eba\u6c11\u5e01");
        } else if ("HKD".equals(s.getCurrencyId())) {
            this.setCurrencyId("\u6e2f\u5e01");
        }
        this.setBalance((double)Math.round(s.getBalance() * 100.0) / 100.0);
        this.setAvailable((double)Math.round(s.getAvail() * 100.0) / 100.0);
        this.setFrozenAmount((double)Math.round(s.getFrozenAmount() * 100.0) / 100.0);
    }

    public StringProperty investorIdProperty() {
        return this.investorId;
    }

    public String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public StringProperty currencyIdProperty() {
        return this.currencyId;
    }

    public String getCurrencyId() {
        return (String)this.currencyIdProperty().get();
    }

    public void setCurrencyId(String currencyId) {
        this.currencyIdProperty().set((Object)currencyId);
    }

    public DoubleProperty availableProperty() {
        return this.available;
    }

    public double getAvailable() {
        return this.availableProperty().get();
    }

    public void setAvailable(double available) {
        this.availableProperty().set(available);
    }

    public DoubleProperty frozenAmountProperty() {
        return this.frozenAmount;
    }

    public double getFrozenAmount() {
        return this.frozenAmountProperty().get();
    }

    public void setFrozenAmount(double frozenAmount) {
        this.frozenAmountProperty().set(frozenAmount);
    }

    public String getCashAccntId() {
        return this.cashAccntId;
    }

    public void setCashAccntId(String cashAccntId) {
        this.cashAccntId = cashAccntId;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }
}

