/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.query.marginxt;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class XtSingleOrder
extends MxSelObj {
    public static final List<String> CAN_CANCEL_STATUS = Arrays.asList("90", "87", "65", "48", "49", "54");
    private String userId = "";
    private String userName = "";
    private String orderId = "";
    private String extOrderId = "";
    private Instrument instrument;
    private Side side;
    private String sideString = "";
    private OrdType ordType;
    private String ordTypeDesc = "";
    private String tradeType = "";
    private double orderQty = 0.0;
    private double price;
    private double newPrice;
    private OrdStatus ordStatus;
    private String status = "";
    private double cumQty = 0.0;
    private double avgPx;
    private double frozenMargin = 0.0;
    private String ordDate = "";
    private String ordTime = "";
    private String ordDateTime = "";
    private double orderAmount = 0.0;
    private String reference = "";
    private String riskDetail = "";
    private String wthUserId = "";
    private String wthTime = "";
    private int tif;
    private int maxPriceLevels;
    private String errInfo = "";
    private String wthErrInfo;
    private String subSecAccntId;
    private String subCashAccntId;
    private String portfolioId = "";
    private transient String portfolioName = "";
    private String investorId = "";
    private String brokerId;
    private int frozenQty;
    private int wthQty;
    private int wthErrCode;
    private int errCode;
    private int canCancelFlag;
    private String extAccntId;
    private String subAccntId;
    private boolean canCancel = false;
    private String investorSecId;
    private transient String securityId = "";
    private transient String securityName = "";
    private transient String securitySubType = "";
    private transient String securityGroup = "";
    private transient String unit = "";
    private transient String market = "";
    private transient double donePercent = 0.0;
    private transient String marketIndicator = "";
    private transient boolean canCancelReplace = true;
    private String extCashAccntId;
    private String extSecAccntId;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.ordDate == null ? 0 : this.ordDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XtSingleOrder other = (XtSingleOrder)((Object)obj);
        if (this.orderId == null ? other.orderId != null : !this.orderId.equals(other.orderId)) {
            return false;
        }
        return !(this.ordDate == null ? other.ordDate != null : !this.ordDate.equals(other.ordDate));
    }

    public void update(Object obj) {
        if (obj instanceof XtSingleOrder) {
            XtSingleOrder s = (XtSingleOrder)((Object)XtSingleOrder.class.cast(obj));
            this.update(s);
        } else if (obj instanceof SingleOrder) {
            SingleOrder s = (SingleOrder)((Object)SingleOrder.class.cast(obj));
            this.update((Object)s);
        }
    }

    private void update(XtSingleOrder o) {
        this.setUserId(o.getUserId());
        this.setOrderId(o.getOrderId());
        this.setExtOrderId(o.getExtOrderId());
        this.setInstrument(o.getInstrument());
        this.setSecurityGroup(o.getSecurityGroup());
        this.setSide(o.getSide());
        this.setOrdType(o.getOrdType());
        this.setOrderQty(o.getOrderQty());
        this.setPrice(o.getPrice());
        this.setOrdStatus(o.getOrdStatus());
        if (o.getOrdStatus() != null) {
            this.setStatus(o.getOrdStatus().getDes());
        }
        this.setCumQty(o.getCumQty());
        this.setErrInfo(o.getErrInfo());
        this.setOrdDate(o.getOrdDate());
        this.setOrdTime(o.getOrdTime());
        this.setOrderAmount(o.getOrderAmount());
        this.setWthErrInfo(o.getWthErrInfo());
        this.setReference(o.getReference());
        this.setUserName(o.getUserName());
        this.setExtCashAccntId(o.getExtCashAccntId());
        this.setAvgPx(o.getAvgPx());
        this.setCanCancel(o.isCanCancel());
        this.setInvestorId(o.getInvestorId());
        this.setInvestorSecId(o.getInvestorSecId());
        this.setWthQty(o.getWthQty());
        this.setWthTime(o.getWthTime());
        this.setRiskDetail(o.getRiskDetail());
        this.setTif(o.getTif());
        this.setMaxPriceLevels(o.getMaxPriceLevels());
        this.setOrdTypeDesc(this.translateOrdType(this));
        this.setFrozenMargin(o.getFrozenMargin());
        this.setOrdDateTime(o.getOrdDateTime());
        if (o.getInstrument() != null) {
            this.setSecurityId(o.getInstrument().getSecurityId());
            this.setSecurityName(o.getInstrument().getSymbol());
        }
        this.setDonePercent(o.getDonePercent());
        this.setMarket(o.getMarket());
        this.setMarketIndicator(o.getMarketIndicator());
        this.setUnit(o.getUnit());
    }

    public void setOrdEvent() {
        this.setTradeType(this.getInstrument().getMarketIndicator());
    }

    private String translateOrdType(XtSingleOrder order) {
        block26: {
            StringBuilder sb;
            block28: {
                block27: {
                    if (order.getOrdType() == null) {
                        return "";
                    }
                    if ("50".equals(order.getOrdType().getValue())) {
                        return "\u9650\u4ef7";
                    }
                    if ("99".equals(order.getOrdType().getValue()) || "80".equals(order.getOrdType().getValue())) {
                        return "\u76d8\u540e\u56fa\u5b9a\u4ef7";
                    }
                    if (!"49".equals(order.getOrdType().getValue())) break block26;
                    sb = new StringBuilder("\u5e02\u4ef7");
                    if (!"XSHE".equals(order.getInstrument().getMarket())) break block27;
                    switch (order.getTif()) {
                        case 48: {
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 1) {
                                sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            break block28;
                        }
                        case 51: {
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 5) {
                                sb.append("-\u4e94\u6863\u5373\u6210\u5269\u64a4");
                                break;
                            }
                            break block28;
                        }
                        case 52: {
                            sb.append("-\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                            break;
                        }
                    }
                    break block28;
                }
                if ("XSHG".equals(order.getInstrument().getMarket())) {
                    switch (order.getTif()) {
                        case 48: {
                            if (order.getInstrument().getSecurityId().startsWith("688")) {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                } else if (order.getMaxPriceLevels() == 1) {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                } else if (order.getMaxPriceLevels() == 5) {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                }
                                sb.append((double)Math.round(order.getPrice() * 100.0) / 100.0);
                                break;
                            }
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 1) {
                                sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() != 5) break;
                            sb.append("-\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7");
                            break;
                        }
                        case 51: {
                            if (order.getInstrument().getSecurityId().startsWith("688")) {
                                sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4-\u4fdd\u62a4\u4ef7\u683c-");
                                sb.append((double)Math.round(order.getPrice() * 100.0) / 100.0);
                                break;
                            }
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                            break;
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public void setExtraFields() {
        if (this.getInstrument() != null && "BOND".equals(this.getInstrument().getSecurityType()) && "XcfeXBond".equals(this.getInstrument().getSecuritySubType())) {
            this.setOrderQty(this.getOrderQty() / 10000.0);
            this.setCumQty(this.getCumQty() / 10000.0);
        }
        double per = 0.0;
        if (this.getCumQty() > 0.0 && this.getOrderQty() > 0.0) {
            per = this.getCumQty() * 100.0 / this.getOrderQty();
        }
        this.setDonePercent(per);
        if (this.getOrdStatus() != null && !StringUtils.isEmpty((String)this.getOrdStatus().getValue())) {
            this.setStatus(this.getOrdStatus().getDes());
            this.setCanCancel(CAN_CANCEL_STATUS.contains(this.getOrdStatus().getValue()));
        }
        if (MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getValue().equals(this.getTradeType())) {
            this.setPrice(0.0);
            this.setOrderAmount(0.0);
        }
        if (!this.getTradeType().isEmpty()) {
            this.setMarketIndicator(MarketIndicator.getDesc(this.getTradeType()));
        }
        this.setOrdTypeDesc(this.translateOrdType(this));
        if (this.getInstrument() != null) {
            this.setSecurityId(this.getInstrument().getSecurityId());
            this.setSecurityName(this.getInstrument().getSymbol());
            this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
            this.setSecurityGroup(this.getInstrument().getSecurityGroup());
            this.setSecuritySubType(this.getInstrument().getSecuritySubType());
        }
        this.setOrdDateTime(String.valueOf(this.getOrdDate()) + this.getOrdTime());
    }

    public String transferErrInfo() {
        StringBuilder errorInfo = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.getErrInfo())) {
            errorInfo.append("\uff08").append(this.getErrInfo()).append("\uff09");
        }
        if (!StringUtils.isEmpty((String)this.getWthErrInfo())) {
            errorInfo.append("\uff08").append(this.getWthErrInfo()).append("\uff09");
        }
        return errorInfo.toString();
    }

    private String transferErrInfo(XtSingleOrder en) {
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + en.getWthErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u8be6\u60c5\uff08" + en.getRiskDetail() + "\uff09";
        }
        return errorInfo;
    }

    public String getWthErrInfo() {
        return this.wthErrInfo;
    }

    public void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfo = wthErrInfo;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getExtOrderId() {
        return this.extOrderId;
    }

    public void setExtOrderId(String extOrderId) {
        this.extOrderId = extOrderId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType ordType) {
        this.ordType = ordType;
    }

    public OrdStatus getOrdStatus() {
        return this.ordStatus;
    }

    public void setOrdStatus(OrdStatus ordStatus) {
        this.ordStatus = ordStatus;
    }

    public double getAvgPx() {
        return this.avgPx;
    }

    public void setAvgPx(double avgPx) {
        this.avgPx = avgPx;
    }

    public String getWthUserId() {
        return this.wthUserId;
    }

    public void setWthUserId(String wthUserId) {
        this.wthUserId = wthUserId;
    }

    public String getWthTime() {
        return this.wthTime;
    }

    public void setWthTime(String wthTime) {
        this.wthTime = wthTime;
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public String getSubCashAccntId() {
        return this.subCashAccntId;
    }

    public void setSubCashAccntId(String subCashAccntId) {
        this.subCashAccntId = subCashAccntId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public int getFrozenQty() {
        return this.frozenQty;
    }

    public void setFrozenQty(int frozenQty) {
        this.frozenQty = frozenQty;
    }

    public int getWthQty() {
        return this.wthQty;
    }

    public void setWthQty(int wthQty) {
        this.wthQty = wthQty;
    }

    public int getWthErrCode() {
        return this.wthErrCode;
    }

    public void setWthErrCode(int wthErrCode) {
        this.wthErrCode = wthErrCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public int getCanCancelFlag() {
        return this.canCancelFlag;
    }

    public void setCanCancelFlag(int canCancelFlag) {
        this.canCancelFlag = canCancelFlag;
    }

    public String getSecurityGroup() {
        return this.securityGroup;
    }

    public void setSecurityGroup(String securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getSecuritySubType() {
        return this.securitySubType;
    }

    public void setSecuritySubType(String securitySubType) {
        this.securitySubType = securitySubType;
    }

    public String getOrdDateTime() {
        return this.ordDateTime;
    }

    public void setOrdDateTime(String ordDateTime) {
        this.ordDateTime = ordDateTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSideString() {
        return this.sideString;
    }

    public void setSideString(String sideString) {
        this.sideString = sideString;
    }

    public String getOrdTypeDesc() {
        return this.ordTypeDesc;
    }

    public void setOrdTypeDesc(String ordTypeDesc) {
        this.ordTypeDesc = ordTypeDesc;
    }

    public double getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(double orderQty) {
        this.orderQty = orderQty;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public double getCumQty() {
        return this.cumQty;
    }

    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    public double getFrozenMargin() {
        return this.frozenMargin;
    }

    public void setFrozenMargin(double frozenMargin) {
        this.frozenMargin = frozenMargin;
    }

    public String getOrdDate() {
        return this.ordDate;
    }

    public void setOrdDate(String ordDate) {
        this.ordDate = ordDate;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public double getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getMarketIndicator() {
        return this.marketIndicator;
    }

    public void setMarketIndicator(String marketIndicator) {
        this.marketIndicator = marketIndicator;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public boolean isCanCancelReplace() {
        return this.canCancelReplace;
    }

    public void setCanCancelReplace(boolean canCancelReplace) {
        this.canCancelReplace = canCancelReplace;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getInvestorSecId() {
        return this.investorSecId;
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecId = investorSecId;
    }

    public int getTif() {
        return this.tif;
    }

    public void setTif(int tif) {
        this.tif = tif;
    }

    public int getMaxPriceLevels() {
        return this.maxPriceLevels;
    }

    public void setMaxPriceLevels(int maxPriceLevels) {
        this.maxPriceLevels = maxPriceLevels;
    }

    public double getDonePercent() {
        return this.donePercent;
    }

    public void setDonePercent(double donePercent) {
        this.donePercent = donePercent;
    }

    public String getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(String riskDetail) {
        this.riskDetail = riskDetail;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }
}

