/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.query;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.pricingit.ExecMode;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.TradeMethod;
import cms.tmx.http.query.EntrustAction;
import cms.tmx.http.query.MiscFee;
import cms.tmx.http.query.OrderExtra;
import cms.tmx.http.query.PositionEffect;
import cms.tmx.http.query.TimeInForce;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.utils.MarketUtils;
import java.util.List;

public class OrderRecord
extends MxObject {
    private int timestamp;
    private String orderId;
    private String clOrdId;
    private String extOrdId;
    private String rptOrdId;
    private String portfolioId;
    private String instructionId;
    private String subAccntId;
    private String subSecAccntId;
    private String subCashAccntId;
    private String extAccntId;
    private String extSecAccntId;
    private String extCashAccntId;
    private Instrument instrument;
    private Instrument underlying;
    private OrdType ordType;
    private Side side;
    private double orderQty;
    private double price;
    private String userId;
    private String businessDate;
    private String transactTime;
    private String expireTime;
    private OrdStatus preOrdStatus;
    private OrdStatus ordStatus;
    private double lastQty;
    private double lastPx;
    private double cumQty;
    private double leavesQty;
    private double avgPx;
    private double orderAmount;
    private double tradeAmount;
    private int volumeMultiple;
    private double cxlQty;
    private double cxlAmount;
    private String cxlTime;
    private String cxlUserId;
    private int cxlRejReason;
    private String cxlRejMsg;
    private int rejReason;
    private String rejMsg;
    private double tax;
    private List<MiscFee> fee;
    private double margin;
    private double commission;
    private TimeInForce tif;
    private int maxPriceLevels;
    private ExecMode execMode;
    private PositionEffect positionEffect;
    private int purpose;
    private EntrustAction entrustAction;
    private String attachment;
    private SettlType settlType;
    private String termToMaturity;
    private MatchType matchType;
    private Party selfParty;
    private TradeMethod tradeMethod;
    private double frozenAmount;
    private double frozenQty;
    private Execution execution;
    private OrderExtra object;
    private String investorId;
    private String inverstorSecId;
    private String secId;
    private String market;
    private String marketGrp;
    private transient String secName = "";
    private transient String creditDirect = "";
    private transient String lifeStatus = "";
    private transient String endDate = "";
    private transient double repayAmount;
    private transient double fundRemain;
    private transient int repayQty;
    private int stkRemain;
    private transient double overdueFee;
    private transient double feeRepay;
    private transient double puniFeeRepay;
    private transient String sno = "";
    private transient String closeDate = "";
    private transient double feeSum;
    private transient double annualInterestRate;
    private transient double marginRate;
    private transient double exFee;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.businessDate == null ? 0 : this.businessDate.hashCode());
        result = 31 * result + (this.investorId == null ? 0 : this.investorId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OrderRecord other = (OrderRecord)((Object)obj);
        if (this.investorId == null ? other.investorId != null : !this.investorId.equals(other.investorId)) {
            return false;
        }
        if (this.orderId == null ? other.getOrderId() != null : !this.orderId.equals(other.getOrderId())) {
            return false;
        }
        if (this.businessDate == null ? other.getBusinessDate() != null : !this.businessDate.equals(other.getBusinessDate())) {
            return false;
        }
        return !(this.extCashAccntId == null ? other.getExtCashAccntId() != null : !this.extCashAccntId.equals(other.getExtCashAccntId()));
    }

    public void update(Object obj) {
        if (obj instanceof OrderRecord) {
            OrderRecord s = (OrderRecord)((Object)OrderRecord.class.cast(obj));
            this.update(s);
        }
    }

    private void update(OrderRecord s) {
        this.setInstrument(s.getInstrument());
        this.setObject(s.getObject());
        this.setExtCashAccntId(s.getExtCashAccntId());
        this.setOrderQty(s.getOrderQty());
        this.setLastQty(s.getLastQty());
        this.setOrderAmount(s.getOrderAmount());
        this.setTradeAmount(s.getTradeAmount());
        this.setFee(s.getFee());
        this.setExtSecAccntId(s.getExtSecAccntId());
        this.setInvestorId(s.getInvestorId());
        this.setInverstorSecId(s.getInverstorSecId());
        this.setSecId(s.getSecId());
        this.setMarket(s.getMarket());
        this.setSecName(s.getSecName());
        this.setMarketGrp(s.getMarketGrp());
        this.setExFee(s.getExFee());
        this.setCreditDirect(s.getCreditDirect());
        this.setLifeStatus(s.getLifeStatus());
        this.setEndDate(s.getEndDate());
        this.setRepayAmount(s.getRepayAmount());
        this.setFundRemain(s.getFundRemain());
        this.setRepayQty(s.getRepayQty());
        this.setStkRemain(s.getStkRemain());
        this.setOverdueFee(s.getOverdueFee());
        this.setFeeRepay(s.getFeeRepay());
        this.setPuniFeeRepay(s.getPuniFeeRepay());
        this.setSno(s.getSno());
        this.setCloseDate(s.getCloseDate());
        this.setFeeSum(s.getFeeSum());
        this.setAnnualInterestRate(s.getAnnualInterestRate());
        this.setMarginRate(s.getMarginRate());
    }

    public void setExtraFields() {
        if (this.getInstrument() != null) {
            this.setSecId(this.getInstrument().getSecurityId());
            this.setSecName(this.getInstrument().getSymbol());
            this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
        }
        if (this.object != null) {
            this.setCreditDirect(this.object.getCreditDirect());
            this.setLifeStatus(this.object.getLifeStatus());
            this.setEndDate(this.object.getEndDate());
            this.setRepayAmount((double)Math.round(this.object.getRepayAmount() * 1000.0) / 1000.0);
            this.setFundRemain((double)Math.round(this.object.getFundRemain() * 1000.0) / 1000.0);
            this.setRepayQty(this.object.getRepayQty());
            this.setStkRemain(this.object.getStkRemain());
            this.setOverdueFee((double)Math.round(this.object.getOverdueFee() * 1000.0) / 1000.0);
            this.setFeeRepay((double)Math.round(this.object.getFeeRepay() * 1000.0) / 1000.0);
            this.setPuniFeeRepay((double)Math.round(this.object.getPuniFeeRepay() * 1000.0) / 1000.0);
            this.setSno(this.object.getSno());
            this.setCloseDate(this.object.getCloseDate());
            this.setFeeSum((double)Math.round(this.object.getFeeSum() * 1000.0) / 1000.0);
            this.setAnnualInterestRate((double)Math.round(this.object.getAnnualInterestRate() * 10000.0) / 10000.0);
            this.setMarginRate((double)Math.round(this.object.getMarginRate() * 100.0) / 100.0);
        }
        if (this.fee != null) {
            for (MiscFee fe : this.fee) {
                if (fe.getMiscFeeType() != 0) continue;
                this.setExFee((double)Math.round(fe.getMiscFeeAmt() * 1000.0) / 1000.0);
                break;
            }
        }
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getClOrdId() {
        return this.clOrdId;
    }

    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    public String getExtOrdId() {
        return this.extOrdId;
    }

    public void setExtOrdId(String extOrdId) {
        this.extOrdId = extOrdId;
    }

    public String getRptOrdId() {
        return this.rptOrdId;
    }

    public void setRptOrdId(String rptOrdId) {
        this.rptOrdId = rptOrdId;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getInstructionId() {
        return this.instructionId;
    }

    public void setInstructionId(String instructionId) {
        this.instructionId = instructionId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public String getSubCashAccntId() {
        return this.subCashAccntId;
    }

    public void setSubCashAccntId(String subCashAccntId) {
        this.subCashAccntId = subCashAccntId;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public Instrument getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(Instrument underlying) {
        this.underlying = underlying;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType ordType) {
        this.ordType = ordType;
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public double getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(double orderQty) {
        this.orderQty = orderQty;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getBusinessDate() {
        return this.businessDate;
    }

    public void setBusinessDate(String businessDate) {
        this.businessDate = businessDate;
    }

    public String getTransactTime() {
        return this.transactTime;
    }

    public void setTransactTime(String transactTime) {
        this.transactTime = transactTime;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public OrdStatus getPreOrdStatus() {
        return this.preOrdStatus;
    }

    public void setPreOrdStatus(OrdStatus preOrdStatus) {
        this.preOrdStatus = preOrdStatus;
    }

    public OrdStatus getOrdStatus() {
        return this.ordStatus;
    }

    public void setOrdStatus(OrdStatus ordStatus) {
        this.ordStatus = ordStatus;
    }

    public double getLastQty() {
        return this.lastQty;
    }

    public void setLastQty(double lastQty) {
        this.lastQty = lastQty;
    }

    public double getLastPx() {
        return this.lastPx;
    }

    public void setLastPx(double lastPx) {
        this.lastPx = lastPx;
    }

    public double getCumQty() {
        return this.cumQty;
    }

    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    public double getLeavesQty() {
        return this.leavesQty;
    }

    public void setLeavesQty(double leavesQty) {
        this.leavesQty = leavesQty;
    }

    public double getAvgPx() {
        return this.avgPx;
    }

    public void setAvgPx(double avgPx) {
        this.avgPx = avgPx;
    }

    public double getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public double getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(double tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public int getVolumeMultiple() {
        return this.volumeMultiple;
    }

    public void setVolumeMultiple(int volumeMultiple) {
        this.volumeMultiple = volumeMultiple;
    }

    public double getCxlQty() {
        return this.cxlQty;
    }

    public void setCxlQty(double cxlQty) {
        this.cxlQty = cxlQty;
    }

    public double getCxlAmount() {
        return this.cxlAmount;
    }

    public void setCxlAmount(double cxlAmount) {
        this.cxlAmount = cxlAmount;
    }

    public String getCxlTime() {
        return this.cxlTime;
    }

    public void setCxlTime(String cxlTime) {
        this.cxlTime = cxlTime;
    }

    public String getCxlUserId() {
        return this.cxlUserId;
    }

    public void setCxlUserId(String cxlUserId) {
        this.cxlUserId = cxlUserId;
    }

    public int getCxlRejReason() {
        return this.cxlRejReason;
    }

    public void setCxlRejReason(int cxlRejReason) {
        this.cxlRejReason = cxlRejReason;
    }

    public String getCxlRejMsg() {
        return this.cxlRejMsg;
    }

    public void setCxlRejMsg(String cxlRejMsg) {
        this.cxlRejMsg = cxlRejMsg;
    }

    public int getRejReason() {
        return this.rejReason;
    }

    public void setRejReason(int rejReason) {
        this.rejReason = rejReason;
    }

    public String getRejMsg() {
        return this.rejMsg;
    }

    public void setRejMsg(String rejMsg) {
        this.rejMsg = rejMsg;
    }

    public double getTax() {
        return this.tax;
    }

    public void setTax(double tax) {
        this.tax = tax;
    }

    public List<MiscFee> getFee() {
        return this.fee;
    }

    public void setFee(List<MiscFee> fee) {
        this.fee = fee;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double commission) {
        this.commission = commission;
    }

    public TimeInForce getTif() {
        return this.tif;
    }

    public void setTif(TimeInForce tif) {
        this.tif = tif;
    }

    public int getMaxPriceLevels() {
        return this.maxPriceLevels;
    }

    public void setMaxPriceLevels(int maxPriceLevels) {
        this.maxPriceLevels = maxPriceLevels;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public PositionEffect getPositionEffect() {
        return this.positionEffect;
    }

    public void setPositionEffect(PositionEffect positionEffect) {
        this.positionEffect = positionEffect;
    }

    public int getPurpose() {
        return this.purpose;
    }

    public void setPurpose(int purpose) {
        this.purpose = purpose;
    }

    public EntrustAction getEntrustAction() {
        return this.entrustAction;
    }

    public void setEntrustAction(EntrustAction entrustAction) {
        this.entrustAction = entrustAction;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public SettlType getSettlType() {
        return this.settlType;
    }

    public void setSettlType(SettlType settlType) {
        this.settlType = settlType;
    }

    public String getTermToMaturity() {
        return this.termToMaturity;
    }

    public void setTermToMaturity(String termToMaturity) {
        this.termToMaturity = termToMaturity;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public Party getSelfParty() {
        return this.selfParty;
    }

    public void setSelfParty(Party selfParty) {
        this.selfParty = selfParty;
    }

    public TradeMethod getTradeMethod() {
        return this.tradeMethod;
    }

    public void setTradeMethod(TradeMethod tradeMethod) {
        this.tradeMethod = tradeMethod;
    }

    public double getFrozenAmount() {
        return this.frozenAmount;
    }

    public void setFrozenAmount(double frozenAmount) {
        this.frozenAmount = frozenAmount;
    }

    public double getFrozenQty() {
        return this.frozenQty;
    }

    public void setFrozenQty(double frozenQty) {
        this.frozenQty = frozenQty;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    public OrderExtra getObject() {
        return this.object;
    }

    public void setObject(OrderExtra object) {
        this.object = object;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInverstorSecId() {
        return this.inverstorSecId;
    }

    public void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecId = inverstorSecId;
    }

    public String getSecId() {
        return this.secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getMarketGrp() {
        return this.marketGrp;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrp = marketGrp;
    }

    public String getSecName() {
        return this.secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }

    public String getCreditDirect() {
        return this.creditDirect;
    }

    public void setCreditDirect(String creditDirect) {
        this.creditDirect = creditDirect;
    }

    public String getLifeStatus() {
        return this.lifeStatus;
    }

    public void setLifeStatus(String lifeStatus) {
        this.lifeStatus = lifeStatus;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public double getRepayAmount() {
        return this.repayAmount;
    }

    public void setRepayAmount(double repayAmount) {
        this.repayAmount = repayAmount;
    }

    public double getFundRemain() {
        return this.fundRemain;
    }

    public void setFundRemain(double fundRemain) {
        this.fundRemain = fundRemain;
    }

    public int getRepayQty() {
        return this.repayQty;
    }

    public void setRepayQty(int repayQty) {
        this.repayQty = repayQty;
    }

    public int getStkRemain() {
        return this.stkRemain;
    }

    public void setStkRemain(int stkRemain) {
        this.stkRemain = stkRemain;
    }

    public double getOverdueFee() {
        return this.overdueFee;
    }

    public void setOverdueFee(double overdueFee) {
        this.overdueFee = overdueFee;
    }

    public double getFeeRepay() {
        return this.feeRepay;
    }

    public void setFeeRepay(double feeRepay) {
        this.feeRepay = feeRepay;
    }

    public double getPuniFeeRepay() {
        return this.puniFeeRepay;
    }

    public void setPuniFeeRepay(double puniFeeRepay) {
        this.puniFeeRepay = puniFeeRepay;
    }

    public String getSno() {
        return this.sno;
    }

    public void setSno(String sno) {
        this.sno = sno;
    }

    public String getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(String closeDate) {
        this.closeDate = closeDate;
    }

    public double getFeeSum() {
        return this.feeSum;
    }

    public void setFeeSum(double feeSum) {
        this.feeSum = feeSum;
    }

    public double getAnnualInterestRate() {
        return this.annualInterestRate;
    }

    public void setAnnualInterestRate(double annualInterestRate) {
        this.annualInterestRate = annualInterestRate;
    }

    public double getMarginRate() {
        return this.marginRate;
    }

    public void setMarginRate(double marginRate) {
        this.marginRate = marginRate;
    }

    public double getExFee() {
        return this.exFee;
    }

    public void setExFee(double exFee) {
        this.exFee = exFee;
    }

    class Execution {
        private String execId;
        private String execDate;
        private String execTime;
        private int lastQty;
        private double lastPx;
        private double lastAmount;
        private double execFee;
        private double margin;
        private String summary;
        private String trader;
        private Party counterParty;

        Execution() {
        }

        public String getExecId() {
            return this.execId;
        }

        public void setExecId(String execId) {
            this.execId = execId;
        }

        public String getExecDate() {
            return this.execDate;
        }

        public void setExecDate(String execDate) {
            this.execDate = execDate;
        }

        public String getExecTime() {
            return this.execTime;
        }

        public void setExecTime(String execTime) {
            this.execTime = execTime;
        }

        public int getLastQty() {
            return this.lastQty;
        }

        public void setLastQty(int lastQty) {
            this.lastQty = lastQty;
        }

        public double getLastPx() {
            return this.lastPx;
        }

        public void setLastPx(double lastPx) {
            this.lastPx = lastPx;
        }

        public double getLastAmount() {
            return this.lastAmount;
        }

        public void setLastAmount(double lastAmount) {
            this.lastAmount = lastAmount;
        }

        public double getExecFee() {
            return this.execFee;
        }

        public void setExecFee(double execFee) {
            this.execFee = execFee;
        }

        public double getMargin() {
            return this.margin;
        }

        public void setMargin(double margin) {
            this.margin = margin;
        }

        public String getSummary() {
            return this.summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public String getTrader() {
            return this.trader;
        }

        public void setTrader(String trader) {
            this.trader = trader;
        }

        public Party getCounterParty() {
            return this.counterParty;
        }

        public void setCounterParty(Party counterParty) {
            this.counterParty = counterParty;
        }
    }
}

