/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.query;

import cms.tmx.http.api.ObInstrument;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.TransStatus;
import cms.tmx.http.query.TransRecord;
import cms.tmx.javafx.obj.MxSelObj;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObTransRecord
extends MxSelObj {
    private StringProperty transSeq = new SimpleStringProperty("");
    private StringProperty transTime = new SimpleStringProperty("");
    private StringProperty transIndicator = new SimpleStringProperty("");
    private ObInstrument instrument;
    private StringProperty userId = new SimpleStringProperty("");
    private DoubleProperty transQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty transAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty confirmQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty confirmAmount = new SimpleDoubleProperty(0.0);
    private ObjectProperty<TransStatus> transStatus = new SimpleObjectProperty();
    private StringProperty rejMsg = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private BooleanProperty canCancel = new SimpleBooleanProperty(false);
    private String extSecAccntId;
    private String extCashAccntId;

    public ObTransRecord() {
        this.instrument = new ObInstrument();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.transSeq.get() == null ? 0 : ((String)this.transSeq.get()).hashCode());
        result = 31 * result + (this.investorId.get() == null ? 0 : ((String)this.investorId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObTransRecord other = (ObTransRecord)((Object)obj);
        if (this.transSeq.get() == null ? other.transSeq.get() != null : !((String)this.transSeq.get()).equals(other.transSeq.get())) {
            return false;
        }
        return !(this.investorId.get() == null ? other.investorId.get() != null : !((String)this.investorId.get()).equals(other.investorId.get()));
    }

    public void update(Object obj) {
        if (obj instanceof ObTransRecord) {
            ObTransRecord t = (ObTransRecord)((Object)ObTransRecord.class.cast(obj));
            this.update(t);
        } else if (obj instanceof TransRecord) {
            TransRecord t = (TransRecord)((Object)TransRecord.class.cast(obj));
            this.update(t);
        }
    }

    private void update(ObTransRecord tr) {
        this.setTransSeq(tr.getTransSeq());
        this.setInvestorId(tr.getInvestorId());
        this.setInvestorSecId(tr.getInvestorSecId());
        this.instrument.update((Object)tr.getInstrument());
        this.setTransIndicator(tr.getTransIndicator());
        this.setTransStatus(tr.getTransStatus());
        this.setTransTime(tr.getTransTime());
        this.setTransQty(tr.getTransQty());
        this.setTransAmount(tr.getTransAmount());
        this.setConfirmQty(tr.getConfirmQty());
        this.setConfirmAmount(tr.getConfirmAmount());
        this.setUserId(tr.getUserId());
        this.setCanCancel(tr.isCanCancel());
        this.setRejMsg(tr.getRejMsg());
        this.setExtCashAccntId(tr.getExtCashAccntId());
        this.setExtSecAccntId(tr.getExtSecAccntId());
    }

    private void update(TransRecord tr) {
        this.setTransSeq(tr.getTransSeq());
        this.setInvestorId(tr.getInvestorId());
        this.setInvestorSecId(tr.getInvestorSecId());
        this.instrument.update((Object)tr.getInstrument());
        this.setTransIndicator(MarketIndicator.getDesc(tr.getTransIndicator()));
        this.setTransStatus(tr.getTransStatus());
        this.setTransTime(tr.getTransTime());
        this.setTransQty(tr.getTransQty());
        this.setTransAmount((double)Math.round(tr.getTransAmount() * 1000.0) / 1000.0);
        this.setConfirmQty(tr.getConfirmQty());
        this.setConfirmAmount((double)Math.round(tr.getConfirmAmount() * 1000.0) / 1000.0);
        this.setUserId(tr.getUserId());
        this.setCanCancel(tr.isCanCancel());
        this.setRejMsg(tr.getRejMsg());
        this.setExtCashAccntId(tr.getExtCashAccntId());
        this.setExtSecAccntId(tr.getExtSecAccntId());
    }

    public final BooleanProperty canCancelProperty() {
        return this.canCancel;
    }

    public final boolean isCanCancel() {
        return this.canCancelProperty().get();
    }

    public final void setCanCancel(boolean canCancel) {
        this.canCancelProperty().set(canCancel);
    }

    public final StringProperty transSeqProperty() {
        return this.transSeq;
    }

    public final String getTransSeq() {
        return (String)this.transSeqProperty().get();
    }

    public final void setTransSeq(String transSeq) {
        this.transSeqProperty().set((Object)transSeq);
    }

    public final StringProperty transTimeProperty() {
        return this.transTime;
    }

    public final String getTransTime() {
        return (String)this.transTimeProperty().get();
    }

    public final void setTransTime(String transTime) {
        this.transTimeProperty().set((Object)transTime);
    }

    public final StringProperty transIndicatorProperty() {
        return this.transIndicator;
    }

    public final String getTransIndicator() {
        return (String)this.transIndicatorProperty().get();
    }

    public final void setTransIndicator(String transIndicator) {
        this.transIndicatorProperty().set((Object)transIndicator);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final DoubleProperty transQtyProperty() {
        return this.transQty;
    }

    public final double getTransQty() {
        return this.transQtyProperty().get();
    }

    public final void setTransQty(double transQty) {
        this.transQtyProperty().set(transQty);
    }

    public final DoubleProperty transAmountProperty() {
        return this.transAmount;
    }

    public final double getTransAmount() {
        return this.transAmountProperty().get();
    }

    public final void setTransAmount(double transAmount) {
        this.transAmountProperty().set(transAmount);
    }

    public final DoubleProperty confirmQtyProperty() {
        return this.confirmQty;
    }

    public final double getConfirmQty() {
        return this.confirmQtyProperty().get();
    }

    public final void setConfirmQty(double confirmQty) {
        this.confirmQtyProperty().set(confirmQty);
    }

    public final DoubleProperty confirmAmountProperty() {
        return this.confirmAmount;
    }

    public final double getConfirmAmount() {
        return this.confirmAmountProperty().get();
    }

    public final void setConfirmAmount(double confirmAmount) {
        this.confirmAmountProperty().set(confirmAmount);
    }

    public final ObjectProperty<TransStatus> transStatusProperty() {
        return this.transStatus;
    }

    public final TransStatus getTransStatus() {
        return (TransStatus)((Object)this.transStatusProperty().get());
    }

    public final void setTransStatus(TransStatus transStatus) {
        this.transStatusProperty().set((Object)transStatus);
    }

    public final StringProperty rejMsgProperty() {
        return this.rejMsg;
    }

    public final String getRejMsg() {
        return (String)this.rejMsgProperty().get();
    }

    public final void setRejMsg(String rejMsg) {
        this.rejMsgProperty().set((Object)rejMsg);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public ObInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(ObInstrument instrument) {
        this.instrument = instrument;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }
}

