/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.manage.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.Page;
import cms.tmx.http.manage.dto.GetTraderReq;
import cms.tmx.http.manage.dto.GetTraderResp;
import cms.tmx.http.workflow.dto.CounterPartyAccount;
import cms.tmx.http.workflow.dto.GetCounterPartyAcountReq;
import cms.tmx.http.workflow.dto.GetCounterPartyAcountResp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CounterPartyServiceApi
extends HttpService {
    @Inject
    @Named(value="fixed.query.pool")
    protected ExecutorService service;

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/counterparty/CounterPartyService";
    }

    public GetTraderResp getTraderIdByUserId(GetTraderReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("GetTraders", body);
        GetTraderResp resp = (GetTraderResp)this.gson.fromJson(respBody, GetTraderResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public List<CounterPartyAccount> getCounterPartyAcount(GetCounterPartyAcountReq req) throws MException {
        List<CounterPartyAccount> result = Collections.synchronizedList(new ArrayList());
        req.setPage(this.getPage(1, 200));
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setIncludeDetails(true);
        String json = this.gson.toJson((Object)req);
        long b = System.currentTimeMillis();
        String respBody = this.doPost("GetCounterParties", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetCounterPartyAcountResp resp = (GetCounterPartyAcountResp)this.gson.fromJson(respBody, GetCounterPartyAcountResp.class);
        status = resp.getStatus();
        this.checkStatus(status);
        result.addAll(resp.getCounterPartyAccount());
        ArrayList<Page> pageList = new ArrayList<Page>();
        if (resp.getPage().getTotalRow() > 1000) {
            int i = 1;
            while (i < (resp.getPage().getTotalRow() - 1) / 1000 + 1) {
                pageList.add(this.getPage(i * 1000 + 1, 1000));
                ++i;
            }
        }
        CountDownLatch cdl = new CountDownLatch(pageList.size());
        Semaphore semaphore = new Semaphore(4);
        for (Page page : pageList) {
            this.service.execute(() -> {
                try {
                    try {
                        semaphore.acquire();
                        GetCounterPartyAcountReq newReq = new GetCounterPartyAcountReq();
                        newReq.setSysPartyId(req.getSysPartyId());
                        newReq.setOpUser(this.httpBaseApi.getHttpOpUser());
                        newReq.setPage(page);
                        newReq.setIncludeDetails(true);
                        String res = this.doPost("GetCounterParties", this.gson.toJson((Object)newReq));
                        OpStatus sta = null;
                        if (res == null) {
                            sta = new OpStatus();
                            sta.setStatus(10);
                        }
                        GetCounterPartyAcountResp pageResp = (GetCounterPartyAcountResp)this.gson.fromJson(res, GetCounterPartyAcountResp.class);
                        sta = pageResp.getStatus();
                        this.checkStatus(sta);
                        result.addAll(pageResp.getCounterPartyAccount());
                    }
                    catch (MException | Exception e) {
                        logger.error("\u4ea4\u6613\u5bf9\u624b\u65b9\u67e5\u8be2\u5931\u8d25", e);
                        cdl.countDown();
                        semaphore.release();
                    }
                }
                finally {
                    cdl.countDown();
                    semaphore.release();
                }
            });
        }
        try {
            cdl.await(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new MException(1, "\u83b7\u53d6\u4ea4\u6613\u5bf9\u624b\u8d85\u65f6");
        }
        logger.info("\u4ea4\u6613\u5bf9\u624b\u8017\u65f6" + (System.currentTimeMillis() - b) + "\uff0c\u4ea4\u6613\u5bf9\u624b\u65b9\u6570\u91cf" + result.size());
        return result;
    }
}

