/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.instruction.dto;

import cms.tmx.define.BsDict;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.instruction.dto.LegDetail;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObLegDetail
extends MxObject {
    private String legId;
    private String taskId;
    private StringProperty instructionId = new SimpleStringProperty("");
    private StringProperty instructionType = new SimpleStringProperty("");
    private String instructionName;
    private String extAccntId;
    private String extCashAccntId;
    private String extSecAccntId;
    private String subAccntId;
    private String subCashAccntId;
    private String subSecAccntId;
    private String marketGroup;
    private Instrument instrument;
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty secName = new SimpleStringProperty("");
    private String secType;
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private ObjectProperty<MxNode> side = new SimpleObjectProperty();
    private OrdType ordType;
    private DoubleProperty targetQty = new SimpleDoubleProperty(0.0);
    private long availOrderQty;
    private double orderQty;
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private DoubleProperty cumQty = new SimpleDoubleProperty(0.0);
    private long cxlQty;
    private long leavesQty;
    private DoubleProperty tradeAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private int status;
    private IntegerProperty progress = new SimpleIntegerProperty(0);
    private long freezeQty;
    private double freezePrice;
    private int flags;
    private String trdDate;
    private String trdTime;
    private String currencyId;
    private String userId;
    private DoubleProperty freezeAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty targetAmount = new SimpleDoubleProperty(0.0);
    private StringProperty marketIndicator = new SimpleStringProperty("");

    public ObLegDetail() {
        MxNode node = MxNodeFactory.createNew((String)"market_code", (String)"");
        this.setMarket(node);
        MxNode sideNode = MxNodeFactory.createNew((String)"side", (String)"");
        this.setSide(sideNode);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.extAccntId == null ? 0 : this.extAccntId.hashCode());
        result = 31 * result + (this.extSecAccntId == null ? 0 : this.extSecAccntId.hashCode());
        result = 31 * result + (this.instructionId.get() == null ? 0 : ((String)this.instructionId.get()).hashCode());
        result = 31 * result + (this.market.get() == null ? 0 : ((MxNode)this.market.get()).getRaw().hashCode());
        result = 31 * result + (this.secId.get() == null ? 0 : ((String)this.secId.get()).hashCode());
        result = 31 * result + (this.subAccntId == null ? 0 : this.subAccntId.hashCode());
        result = 31 * result + (this.subSecAccntId == null ? 0 : this.subSecAccntId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObLegDetail other = (ObLegDetail)((Object)obj);
        if (this.extAccntId == null ? other.extAccntId != null : !this.extAccntId.equals(other.extAccntId)) {
            return false;
        }
        if (this.extSecAccntId == null ? other.extSecAccntId != null : !this.extSecAccntId.equals(other.extSecAccntId)) {
            return false;
        }
        if (this.instructionId.get() == null ? other.instructionId.get() != null : !((String)this.instructionId.get()).equals(other.instructionId.get())) {
            return false;
        }
        if (this.market.get() == null ? other.market.get() != null : !((MxNode)this.market.get()).getRaw().equals(((MxNode)other.market.get()).getRaw())) {
            return false;
        }
        if (this.secId.get() == null ? other.secId.get() != null : !((String)this.secId.get()).equals(other.secId.get())) {
            return false;
        }
        if (this.subAccntId == null ? other.subAccntId != null : !this.subAccntId.equals(other.subAccntId)) {
            return false;
        }
        return !(this.subSecAccntId == null ? other.subSecAccntId != null : !this.subSecAccntId.equals(other.subSecAccntId));
    }

    public void update(Object obj) {
        if (obj instanceof LegDetail) {
            LegDetail in = (LegDetail)LegDetail.class.cast(obj);
            this.update(in);
        } else if (obj instanceof ObLegDetail) {
            this.update((ObLegDetail)((Object)ObLegDetail.class.cast(obj)));
        }
    }

    private void update(LegDetail leg) {
        this.setInstructionId(leg.getInstructionId());
        this.setInstructionType((String)BsDict.NEW_INSTRUCTION_TYPE_MAP.get(leg.getInstructionType()));
        this.setInstrument(leg.getInstrument());
        this.getSide().setRaw(leg.getSide().getValue());
        this.setTargetQty((double)Math.round(leg.getTargetQty() * 1000.0) / 1000.0);
        this.setOrderQty((double)Math.round(leg.getOrderQty() * 1000.0) / 1000.0);
        this.setCumQty((double)Math.round(leg.getCumQty() * 1000.0) / 1000.0);
        this.setProgress(leg.getProgress());
        this.setAvailOrderQty(Double.valueOf(leg.getAvailOrderQty()).longValue());
        this.setExtAccntId(leg.getExtAccntId());
        this.setExtCashAccntId(leg.getExtCashAccntId());
        this.setExtSecAccntId(leg.getExtSecAccntId());
        this.setSubAccntId(leg.getSubAccntId());
        this.setSubCashAccntId(leg.getSubCashAccntId());
        this.setSubSecAccntId(leg.getSubSecAccntId());
        this.setSecId(this.getInstrument().getSecurityId());
        this.getMarket().setRaw(this.getInstrument().getMarket());
        this.setSecId(this.getInstrument().getSecurityId());
        this.setSecName(this.getInstrument().getSymbol());
        this.setSecType(this.getInstrument().getSecurityType());
        this.setAvgPx((double)Math.round(leg.getAvgPx() * 10000.0) / 10000.0);
        this.setPrice((double)Math.round(leg.getPrice() * 10000.0) / 10000.0);
        this.setOrderAmount((double)Math.round(leg.getTargetAmount() * 1000.0) / 1000.0);
        this.setProgress(leg.getProgress());
        this.setFreezeAmount((double)Math.round(leg.getFreezeAmount() * 1000.0) / 1000.0);
        this.setLegId(leg.getLegId());
        this.setTaskId(leg.getTaskId());
        this.setMarketGroup(leg.getMarketGroup());
        this.setOrdType(leg.getOrdType());
        this.setTradeAmount((double)Math.round(leg.getTradeAmount() * 1000.0) / 1000.0);
        this.setStatus(leg.getStatus());
        this.setFreezePrice(leg.getFreezePrice());
        this.setFlags(leg.getFlags());
        this.setTrdDate(leg.getTrdDate());
        this.setTrdTime(leg.getTrdTime());
        this.setCurrencyId(leg.getCurrencyId());
        this.setUserId(leg.getUserId());
        this.setTargetAmount(leg.getTargetAmount());
        this.setMarketIndicator(MarketIndicator.getDesc(this.getInstrument().getMarketIndicator()));
    }

    private void update(ObLegDetail item) {
        this.setLegId(item.getLegId());
        this.setTaskId(item.getTaskId());
        this.setInstructionId(item.getInstructionId());
        this.setInstructionType(item.getInstructionType());
        this.setInstructionName(item.getInstructionName());
        this.setExtAccntId(item.getExtAccntId());
        this.setExtCashAccntId(item.getExtCashAccntId());
        this.setExtSecAccntId(item.getExtSecAccntId());
        this.setSubAccntId(item.getSubAccntId());
        this.setSubCashAccntId(item.getSubCashAccntId());
        this.setSubSecAccntId(item.getSubSecAccntId());
        this.setMarketGroup(item.getMarketGroup());
        this.setInstrument(item.getInstrument());
        this.setSecId(item.getSecId());
        this.setSecName(item.getSecName());
        this.setSecType(item.getSecType());
        this.setMarket(item.getMarket());
        this.setSide(item.getSide());
        this.setOrdType(item.getOrdType());
        this.setTargetQty(item.getTargetQty());
        this.setAvailOrderQty(item.getAvailOrderQty());
        this.setOrderQty(item.getOrderQty());
        this.setOrderAmount(item.getOrderAmount());
        this.setPrice(item.getPrice());
        this.setCumQty(item.getCumQty());
        this.setCxlQty(item.getCxlQty());
        this.setLeavesQty(item.getLeavesQty());
        this.setTradeAmount(item.getTradeAmount());
        this.setAvgPx(item.getAvgPx());
        this.setStatus(item.getStatus());
        this.setProgress(item.getProgress());
        this.setFreezeQty(item.getFreezeQty());
        this.setFreezePrice(item.getFreezePrice());
        this.setFlags(item.getFlags());
        this.setTrdDate(item.getTrdDate());
        this.setTrdTime(item.getTrdTime());
        this.setCurrencyId(item.getCurrencyId());
        this.setUserId(item.getUserId());
        this.setFreezeAmount(item.getFreezeAmount());
        this.setTargetAmount(item.getTargetAmount());
        this.setMarketIndicator(item.getMarketIndicator());
    }

    public String getLegId() {
        return this.legId;
    }

    public void setLegId(String legId) {
        this.legId = legId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getInstructionName() {
        return this.instructionName;
    }

    public void setInstructionName(String instructionName) {
        this.instructionName = instructionName;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getSubCashAccntId() {
        return this.subCashAccntId;
    }

    public void setSubCashAccntId(String subCashAccntId) {
        this.subCashAccntId = subCashAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public String getMarketGroup() {
        return this.marketGroup;
    }

    public void setMarketGroup(String marketGroup) {
        this.marketGroup = marketGroup;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType ordType) {
        this.ordType = ordType;
    }

    public long getAvailOrderQty() {
        return this.availOrderQty;
    }

    public void setAvailOrderQty(long availOrderQty) {
        this.availOrderQty = availOrderQty;
    }

    public double getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(double orderQty) {
        this.orderQty = orderQty;
    }

    public long getCxlQty() {
        return this.cxlQty;
    }

    public void setCxlQty(long cxlQty) {
        this.cxlQty = cxlQty;
    }

    public long getLeavesQty() {
        return this.leavesQty;
    }

    public void setLeavesQty(long leavesQty) {
        this.leavesQty = leavesQty;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getFreezeQty() {
        return this.freezeQty;
    }

    public void setFreezeQty(long freezeQty) {
        this.freezeQty = freezeQty;
    }

    public double getFreezePrice() {
        return this.freezePrice;
    }

    public void setFreezePrice(double freezePrice) {
        this.freezePrice = freezePrice;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getTrdDate() {
        return this.trdDate;
    }

    public void setTrdDate(String trdDate) {
        this.trdDate = trdDate;
    }

    public String getTrdTime() {
        return this.trdTime;
    }

    public void setTrdTime(String trdTime) {
        this.trdTime = trdTime;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setProgress(IntegerProperty progress) {
        this.progress = progress;
    }

    public final StringProperty instructionIdProperty() {
        return this.instructionId;
    }

    public final String getInstructionId() {
        return (String)this.instructionIdProperty().get();
    }

    public final void setInstructionId(String instructionId) {
        this.instructionIdProperty().set((Object)instructionId);
    }

    public final StringProperty instructionTypeProperty() {
        return this.instructionType;
    }

    public final String getInstructionType() {
        return (String)this.instructionTypeProperty().get();
    }

    public final void setInstructionType(String instructionType) {
        this.instructionTypeProperty().set((Object)instructionType);
    }

    public final StringProperty secIdProperty() {
        return this.secId;
    }

    public final String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public final void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public final StringProperty secNameProperty() {
        return this.secName;
    }

    public final String getSecName() {
        return (String)this.secNameProperty().get();
    }

    public final void setSecName(String secName) {
        this.secNameProperty().set((Object)secName);
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final ObjectProperty<MxNode> sideProperty() {
        return this.side;
    }

    public final MxNode getSide() {
        return (MxNode)this.sideProperty().get();
    }

    public final void setSide(MxNode side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty targetQtyProperty() {
        return this.targetQty;
    }

    public final double getTargetQty() {
        return this.targetQtyProperty().get();
    }

    public final void setTargetQty(double targetQty) {
        this.targetQtyProperty().set(targetQty);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final DoubleProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final double getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(double cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final IntegerProperty progressProperty() {
        return this.progress;
    }

    public final int getProgress() {
        return this.progressProperty().get();
    }

    public final void setProgress(int progress) {
        this.progressProperty().set(progress);
    }

    public final DoubleProperty freezeAmountProperty() {
        return this.freezeAmount;
    }

    public final double getFreezeAmount() {
        return this.freezeAmountProperty().get();
    }

    public final void setFreezeAmount(double freezeAmount) {
        this.freezeAmountProperty().set(freezeAmount);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final DoubleProperty targetAmountProperty() {
        return this.targetAmount;
    }

    public final double getTargetAmount() {
        return this.targetAmountProperty().get();
    }

    public final void setTargetAmount(double targetAmount) {
        this.targetAmountProperty().set(targetAmount);
    }

    public final DoubleProperty tradeAmountProperty() {
        return this.tradeAmount;
    }

    public final double getTradeAmount() {
        return this.tradeAmountProperty().get();
    }

    public final void setTradeAmount(double tradeAmount) {
        this.tradeAmountProperty().set(tradeAmount);
    }

    public final StringProperty marketIndicatorProperty() {
        return this.marketIndicator;
    }

    public final String getMarketIndicator() {
        return (String)this.marketIndicatorProperty().get();
    }

    public final void setMarketIndicator(String marketIndicator) {
        this.marketIndicatorProperty().set((Object)marketIndicator);
    }
}

