/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.instruction.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.instruction.dto.GetQuotaDetailReq;
import cms.tmx.http.instruction.dto.GetQuotaDetailResp;
import cms.tmx.http.instruction.dto.GetThresholdListReq;
import cms.tmx.http.instruction.dto.GetThresholdListResp;
import cms.tmx.http.instruction.dto.Quota;
import cms.tmx.http.instruction.dto.QuotaThreshold;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class QuotaSettingsServiceApi
extends HttpService {
    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/risk/quota";
    }

    public List<QuotaThreshold> getThresholdList(GetThresholdListReq req) throws MException {
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        String idStr = req.getQuotaIds().toString();
        idStr = idStr.substring(1, idStr.length() - 1);
        idStr = idStr.replace(" ", "");
        req.getQuotaIds();
        String respBody = this.doGet(String.valueOf(this.url) + "/thresholds?quota_ids=" + idStr);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        GetThresholdListResp resp = (GetThresholdListResp)this.gson.fromJson(respBody, GetThresholdListResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getThreshold();
    }

    public Quota getQuotaDetail(GetQuotaDetailReq req) throws MException {
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        String respBody = this.doGet(String.valueOf(this.url) + "/" + req.getQuotaId());
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        System.err.println(respBody);
        GetQuotaDetailResp resp = (GetQuotaDetailResp)this.gson.fromJson(respBody, GetQuotaDetailResp.class);
        this.checkStatus(resp.getStatus());
        return resp.getQuotaUnit().getQuota();
    }
}

