/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.instruction.api;

import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.instruction.dto.GetLightingInsResp;
import cms.tmx.http.instruction.dto.LightingInsExecLeg;
import cms.tmx.http.instruction.dto.LightingInstruction;
import cms.tmx.http.instruction.dto.NewLightingInstructionResp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LightingInstructionApi
extends HttpService {
    @Inject
    private MConfService ms;
    private String baseUrl;
    private final String NEW_LIGHTING_INSTRUCTION = "/instructions/actions/new";
    private final String GET_INSTRUCTION = "/instructions";
    private final String EXECUTE_LIGHTING_INSTRUCTION = "/instructions/actions/execute";

    @PostConstruct
    private void initialize() {
        this.baseUrl = this.ms.getValue("lighting.url");
    }

    public NewLightingInstructionResp newLightingInstruction(LightingInstruction req) throws MException {
        req.setCreator(this.baseApi.getUserId());
        req.setApprover(this.baseApi.getUserId());
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPostWithUrl("NewLightingInstruction", json, String.valueOf(this.baseUrl) + "/instructions/actions/new" + "?userId=" + this.baseApi.getUserId());
        NewLightingInstructionResp resp = (NewLightingInstructionResp)((Object)this.gson.fromJson(respBody, NewLightingInstructionResp.class));
        this.checkOpCode(resp.getOpCode());
        return resp;
    }

    public List<LightingInstruction> getInstructions() throws MException {
        String respBody = this.doGet(String.valueOf(this.baseUrl) + "/instructions" + "?userId=" + this.baseApi.getUserId());
        GetLightingInsResp resp = (GetLightingInsResp)((Object)this.gson.fromJson(respBody, GetLightingInsResp.class));
        if (resp != null) {
            return resp.getItems();
        }
        return new ArrayList<LightingInstruction>();
    }

    public void executeLightingInstruction(LightingInstruction ins) throws MException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instructionId", ins.getId());
        map.put("opUser", this.httpBaseApi.getHttpOpUser());
        String json = this.gson.toJson(map);
        String respBody = this.doPostWithUrl("ExecuteLightingInstruction", json, String.valueOf(this.baseUrl) + "/instructions/actions/execute" + "?userId=" + this.baseApi.getUserId());
        System.out.println(respBody);
    }

    public List<LightingInsExecLeg> getInstructionDetails(String instructionId) throws MException {
        String respBody = this.doGet(String.valueOf(this.baseUrl) + "/instructions" + "/" + instructionId + "/legs?userId=" + this.baseApi.getUserId());
        LightingInstruction lightingIns = (LightingInstruction)((Object)this.gson.fromJson(respBody, LightingInstruction.class));
        if (lightingIns != null) {
            return lightingIns.getItems();
        }
        return new ArrayList<LightingInsExecLeg>();
    }
}

