/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.instruction.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.Page;
import cms.tmx.http.instruction.dto.ExecuteTaskReq;
import cms.tmx.http.instruction.dto.GetInstructionsReq;
import cms.tmx.http.instruction.dto.GetInstructionsResp;
import cms.tmx.http.instruction.dto.GetLegDetailsReq;
import cms.tmx.http.instruction.dto.GetLegDetailsResp;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.InstructionItem;
import cms.tmx.http.instruction.dto.LegDetail;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.SubmitInstructionReq;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionServiceApi
extends HttpService {
    @Inject
    private HttpBaseApi baseApi;

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/instruction/InstructionService";
    }

    public OpStatus newInstruction(NewInstructionReq req) throws MException {
        req.setOpUser(this.baseApi.getHttpOpUser());
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("NewInstruction", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        SubmitInstructionReq submitReq = new SubmitInstructionReq();
        submitReq.setOpUser(this.baseApi.getHttpOpUser());
        submitReq.setInstructionId(status.getData());
        String reqJson = this.gson.toJson((Object)submitReq);
        String submitResp = this.doPost("SubmitInstruction", reqJson);
        OpStatus submitStatus = null;
        if (submitResp == null) {
            submitStatus = new OpStatus();
            submitStatus.setStatus(10);
        }
        submitStatus = (OpStatus)this.gson.fromJson(submitResp, OpStatus.class);
        this.checkStatus(submitStatus);
        return submitStatus;
    }

    public List<Instruction<?>> getInstructions(GetInstructionsReq req) throws MException {
        ArrayList instructions = new ArrayList();
        req.setOpUser(this.baseApi.getHttpOpUser());
        GetInstructionsResp resp = this.queryInstructionByPage(req, instructions, 1);
        if (resp.getPage().getTotalRow() <= instructions.size()) {
            return instructions;
        }
        int i = 1;
        while (i <= (resp.getPage().getTotalRow() - 1) / 200) {
            this.queryInstructionByPage(req, instructions, i * 200 + 1);
            ++i;
        }
        return instructions;
    }

    private GetInstructionsResp queryInstructionByPage(GetInstructionsReq req, List<Instruction<?>> instructions, int startRow) throws MException {
        Page page = new Page();
        page.setStartRow(startRow);
        page.setPageSize(200);
        req.setPage(page);
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetInstructions", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetInstructionsResp resp = (GetInstructionsResp)this.gson.fromJson(respBody, GetInstructionsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getItem() != null) {
            for (InstructionItem item : resp.getItem()) {
                instructions.add(item.getInstruction());
                item.getInstruction().setJob(item.getJob());
            }
        }
        return resp;
    }

    public GetInstructionsResp queryInstructionByPage(GetInstructionsReq req, List<Instruction<?>> instructions) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetInstructions", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetInstructionsResp resp = (GetInstructionsResp)this.gson.fromJson(respBody, GetInstructionsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getItem() != null) {
            for (InstructionItem item : resp.getItem()) {
                instructions.add(item.getInstruction());
                item.getInstruction().setJob(item.getJob());
            }
        }
        return resp;
    }

    public void execInstructionTask(ExecuteTaskReq req) throws MException {
        req.setOpUser(this.baseApi.getHttpOpUser());
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("ExecuteTask", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
    }

    public List<LegDetail> getLegDetails(GetLegDetailsReq req) throws MException {
        ArrayList<LegDetail> legs = new ArrayList<LegDetail>();
        req.setOpUser(this.baseApi.getHttpOpUser());
        GetLegDetailsResp resp = this.queryDetailsByPage(req, legs, 1);
        if (resp.getPage().getTotalRow() <= legs.size()) {
            return legs;
        }
        int i = 1;
        while (i <= (resp.getPage().getTotalRow() - 1) / 200) {
            this.queryDetailsByPage(req, legs, i * 200 + 1);
            ++i;
        }
        return legs;
    }

    private GetLegDetailsResp queryDetailsByPage(GetLegDetailsReq req, List<LegDetail> legs, int startRow) throws MException {
        Page page = new Page();
        page.setStartRow(startRow);
        page.setPageSize(200);
        req.setPage(page);
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetLegDetails", json);
        OpStatus status = null;
        GetLegDetailsResp resp = (GetLegDetailsResp)this.gson.fromJson(respBody, GetLegDetailsResp.class);
        status = resp.getStatus();
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        this.checkStatus(status);
        if (resp.getLeg() != null) {
            legs.addAll(resp.getLeg());
        }
        return resp;
    }
}

