/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.data;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.Page;
import cms.tmx.http.data.GetSecPoolsReq;
import cms.tmx.http.data.GetSecPoolsResp;
import cms.tmx.http.data.SecPool;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SecPoolServiceApi
extends HttpService {
    @Inject
    private HttpBaseApi baseApi;
    private Gson gson = new Gson();

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/secpool/SecPoolService";
    }

    public List<Instrument> getSecPools(GetSecPoolsReq req) throws MException {
        LinkedList<Instrument> list = new LinkedList();
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetSecPoolsResp resp = null;
        do {
            req.setPage(pageReq);
            String json = this.gson.toJson((Object)req);
            String respBody = this.doPost("GetSecPools", json);
            if (respBody == null) {
                OpStatus status = new OpStatus();
                status.setStatus(10);
                this.checkStatus(status);
            }
            resp = (GetSecPoolsResp)this.gson.fromJson(respBody, GetSecPoolsResp.class);
            pageReq.setStartRow(resp.getPage().getStartRow());
            List<SecPool> pools = resp.getPool();
            if (pools == null) continue;
            for (SecPool secPool : pools) {
                if (secPool.getSecList() == null || secPool.getSecList().getInstrument() == null) continue;
                list.addAll(secPool.getSecList().getInstrument());
            }
        } while (resp != null && !resp.getPage().isLast());
        this.checkStatus(resp.getStatus());
        list = list.stream().distinct().collect(Collectors.toList());
        return list;
    }
}

