/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.data;

import cms.tmx.http.data.IssueParams;
import cms.tmx.http.security.dto.SecStatus;
import cms.tmx.http.security.dto.Security;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.utils.StringUtils;

public class IssueInfo
extends MxSelObj {
    Security security;
    SecStatus secStat;
    IssueParams params;
    private transient String issueId;
    private transient String securityId;
    private transient String securityName;
    private transient String securityGroup;
    private transient String effectivePrice;
    private transient String qtyRange;
    private transient double outstandingShare;
    private transient String startDate;
    private transient String tradeStatus;
    private transient String startEndDate;
    public static final transient String F = "F";
    public static final transient String I = "I";

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.issueId == null ? 0 : this.issueId.hashCode());
        result = 31 * result + (this.securityId == null ? 0 : this.securityId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IssueInfo other = (IssueInfo)((Object)obj);
        if (this.issueId == null ? other.issueId != null : !this.issueId.equals(other.issueId)) {
            return false;
        }
        return !(this.securityId == null ? other.securityId != null : !this.securityId.equals(other.securityId));
    }

    public void setExtraFields() {
        if (this.getSecurity() != null && this.getSecurity().getInstrument() != null) {
            this.setIssueId(this.getSecurity().getInstrument().getSecurityId());
            this.setSecurityName(this.getSecurity().getInstrument().getSymbol());
        }
        if (this.getParams() != null && this.getParams().getUnderlying() != null) {
            this.setSecurityId(this.getParams().getUnderlying().getSecurityId());
            this.setEffectivePrice(String.valueOf(this.getParams().getPriceLowerLimit()) + "--" + this.getParams().getPriceUpperLimit());
            String upperLimit = StringUtils.toStr((double)this.getParams().getQtyUpperLimit(), (int)1);
            String lowerLimit = StringUtils.toStr((double)this.getParams().getQtyLowerLimit(), (int)1);
            this.setQtyRange(String.valueOf(lowerLimit) + "\u2014\u2014" + upperLimit);
            this.setOutstandingShare(this.getParams().getOutstandingShare());
            this.setStartDate(this.getParams().getStartDate());
            if (F.equals(this.getParams().getUnderlying().getSecuritySubType())) {
                this.setTradeStatus("\u7533\u8d2d");
            } else if (I.equals(this.getParams().getUnderlying().getSecuritySubType())) {
                this.setTradeStatus("\u8be2\u4ef7");
            }
        }
        this.setSecurityGroup("\u7cbe\u9009\u5c42");
        this.setStartEndDate(String.valueOf(this.getParams().getStartDate()) + "-" + this.getParams().getEndDate());
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public IssueParams getParams() {
        return this.params;
    }

    public void setParams(IssueParams params) {
        this.params = params;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public String getSecurityGroup() {
        return this.securityGroup;
    }

    public void setSecurityGroup(String securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getEffectivePrice() {
        return this.effectivePrice;
    }

    public void setEffectivePrice(String effectivePrice) {
        this.effectivePrice = effectivePrice;
    }

    public String getQtyRange() {
        return this.qtyRange;
    }

    public void setQtyRange(String qtyRange) {
        this.qtyRange = qtyRange;
    }

    public double getOutstandingShare() {
        return this.outstandingShare;
    }

    public void setOutstandingShare(double outstandingShare) {
        this.outstandingShare = outstandingShare;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getTradeStatus() {
        return this.tradeStatus;
    }

    public void setTradeStatus(String tradeStatus) {
        this.tradeStatus = tradeStatus;
    }

    public String getStartEndDate() {
        return this.startEndDate;
    }

    public void setStartEndDate(String startEndDate) {
        this.startEndDate = startEndDate;
    }

    public SecStatus getSecStat() {
        return this.secStat;
    }

    public void setSecStat(SecStatus secStat) {
        this.secStat = secStat;
    }
}

