/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.condition.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.condition.dto.CondOrderWithAccnt;
import cms.tmx.http.condition.dto.ConditionalCancelRequest;
import cms.tmx.http.condition.dto.GetConditionalOrderResponse;
import cms.tmx.http.condition.dto.GetCondtionalOrderRequest;
import cms.tmx.http.condition.dto.NewOrderConditional;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class CondOrderServiceApi
extends HttpService {
    @Inject
    private HttpBaseApi baseApi;
    private static final Logger logger = LogManager.getLogger(CondOrderServiceApi.class);

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/complex/CondOrderService";
    }

    public String newOrderConditional(NewOrderConditional request) throws MException {
        request.setOpUser(this.baseApi.getHttpOpUser());
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("DoNewOrderConditional", body);
        logger.info("\u65b0\u6846\u67b6\u6761\u4ef6\u5355\u59d4\u6258:" + respBody);
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status.getData();
    }

    public List<CondOrderWithAccnt> getCondtionalOrder(GetCondtionalOrderRequest request) throws MException {
        request.setOpUser(this.baseApi.getHttpOpUser());
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("GetConditionalOrders", body);
        logger.info("\u67e5\u8be2\u65b0\u6846\u67b6\u6761\u4ef6\u5355:" + respBody);
        GetConditionalOrderResponse resp = (GetConditionalOrderResponse)this.gson.fromJson(respBody, GetConditionalOrderResponse.class);
        this.checkStatus(resp.getOpStatus());
        return resp.getAccntOrder();
    }

    public void cancelCondtion(ConditionalCancelRequest request) throws MException {
        request.setOpUser(this.baseApi.getHttpOpUser());
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("DoConditionalOrderCancelRequest", body);
        logger.info("\u67e5\u8be2\u65b0\u6846\u67b6\u6761\u4ef6\u5355:" + respBody);
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
    }
}

