/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.define.BsDict;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.dto.YieldData;
import cms.tmx.http.api.pricingit.ExecMode;
import cms.tmx.http.api.strategy.dto.EntrustInfo;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.query.CcsOrder;
import cms.tmx.http.query.LegMode;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class SingleOrder
extends MxSelObj {
    public static final List<String> CAN_CANCEL_STATUS = Arrays.asList("90", "87", "65", "48", "49", "54", "73");
    private String userId = "";
    private String userName = "";
    private String orderId = "";
    private String extOrderId = "";
    private Instrument instrument;
    private Side side;
    private String sideString = "";
    private OrdType ordType;
    private String ordTypeDesc = "";
    YieldData yieldData;
    private double orderQty = 0.0;
    private double price;
    private double newPrice;
    private String execId = "";
    private String execTime = "";
    private OrdStatus ordStatus;
    private String status = "";
    private double lastQty;
    private double lastPx;
    private double cumQty = 0.0;
    private double leavesQty;
    private double avgPx;
    private double avgYield;
    private double totalValue;
    private double frozenMargin = 0.0;
    private double frozenCommission;
    private double margenTaken;
    private String ordDate = "";
    private String ordTime = "";
    private String ordDateTime = "";
    private double orderAmount = 0.0;
    private MatchType matchType;
    private SettlType settlType;
    private String termToMaturity = "";
    private Party selfParty;
    private String traderId = "";
    ExecMode execMode;
    private String resourceId = "";
    private String reference = "";
    private String riskDetail = "";
    private String wthUserId = "";
    private String wthTime = "";
    private double realFee = 0.0;
    private double commision = 0.0;
    private double chgOwnerFee = 0.0;
    private double stampTax = 0.0;
    private double handleFee = 0.0;
    private double secAdminFee = 0.0;
    private double otherFee = 0.0;
    private double tradeAmount;
    private int tif;
    private int maxPriceLevels;
    private String errInfo = "";
    private transient String neeqErrInfo;
    private String wthErrInfo;
    private String clOrdId = "";
    private String extSecAccntId;
    private String subSecAccntId;
    private Instrument underlying;
    private String extCashAccntId;
    private String subCashAccntId;
    private String portfolioId = "";
    private transient String portfolioName = "";
    private String investorId = "";
    private String investorName = "";
    private String brokerId;
    private OrdStatus preOrdStatus;
    private double filledAvgPrice;
    private int frozenQty;
    private int wthQty;
    private int wthErrCode;
    private int errCode;
    private String attachment;
    private int canCancelFlag;
    private String extAccntId;
    private String subAccntId;
    private boolean inactive;
    private LegMode legMode;
    private CcsOrder object;
    private String parentId = "";
    private boolean canCancel = false;
    private String investorSecId = "";
    private transient String securityId = "";
    private transient String securityName = "";
    private transient String securitySubType = "";
    private transient String securityGroup = "";
    private transient String source = "";
    private transient String sourceId = "";
    private transient String ordCategory = "\u666e\u901a\u5355";
    private transient String unit = "";
    private transient String tradeName = "";
    private transient String market = "";
    private transient double donePercent = 0.0;
    private transient double yield;
    private transient String marketIndicator;
    private transient String issueId = "";
    private transient String issueName = "";
    private static final String COMMON_ISSUE = "COMMON_ISSUE";
    private transient boolean canCancelReplace = true;
    private String positionEffect = "";
    private String algoId = "";

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.ordDate == null ? 0 : this.ordDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SingleOrder other = (SingleOrder)((Object)obj);
        if (this.orderId == null ? other.orderId != null : !this.orderId.equals(other.orderId)) {
            return false;
        }
        return !(this.ordDate == null ? other.ordDate != null : !this.ordDate.equals(other.ordDate));
    }

    public void update(Object obj) {
        if (obj instanceof SingleOrder) {
            SingleOrder s = (SingleOrder)((Object)SingleOrder.class.cast(obj));
            this.update(s);
        } else if (obj instanceof EntrustInfo) {
            EntrustInfo s = (EntrustInfo)((Object)EntrustInfo.class.cast(obj));
            this.update(s);
        }
    }

    private void update(EntrustInfo o) {
        this.setSecurityId(o.getSecurity());
        this.setSecurityName(o.getSymbol());
        this.setMarket(o.getMarket());
        this.setMarketIndicator(o.getSide());
        this.setPrice(o.getPrice());
        this.setOrderQty(o.getQty());
        this.setOrderAmount(o.getOrdAmt());
        this.setCumQty(o.getTradeQty());
        this.setDonePercent(o.getPercent());
        this.setAvgPx(o.getAvgPrice());
        this.setOrdTime(o.getEntrustTime());
        this.setExtOrderId(o.getEntrustNo());
        this.setInvestorId(o.getFundAccnt());
        this.setInvestorSecId(o.getSecAccntId());
        this.setReference(o.getAlgoOrderId());
        this.setErrInfo(o.getRemark());
    }

    private void update(SingleOrder o) {
        this.setUserId(o.getUserId());
        this.setOrderId(o.getOrderId());
        this.setExtOrderId(o.getExtOrderId());
        this.setInstrument(o.getInstrument());
        this.setUnderlying(o.getUnderlying());
        this.setSecurityGroup(o.getSecurityGroup());
        this.setSide(o.getSide());
        this.setSideString(o.getSide().getValue());
        this.setOrdType(o.getOrdType());
        this.setOrderQty(o.getOrderQty());
        this.setPrice(o.getPrice());
        this.setExecId(o.getExecId());
        this.setExecTime(o.getExecTime());
        this.setOrdStatus(o.getOrdStatus());
        this.setStatus(o.getOrdStatus().getDes());
        this.setLastQty(o.getLastQty());
        this.setLastPx(o.getLastPx());
        this.setCumQty(o.getCumQty());
        this.setLeavesQty(o.getLeavesQty());
        this.setTotalValue(o.getTotalValue());
        this.setErrInfo(o.getErrInfo());
        this.setOrdDate(o.getOrdDate());
        this.setOrdTime(o.getOrdTime());
        this.setOrderAmount(o.getOrderAmount());
        this.setExecMode(o.getExecMode());
        this.setMatchType(o.getMatchType());
        this.setTraderId(o.getTraderId());
        this.setSelfParty(o.getSelfParty());
        this.setTraderId(o.getSelfParty() == null ? "" : o.getSelfParty().getTraderId());
        this.setWthErrInfo(o.getWthErrInfo());
        this.setReference(o.getReference());
        this.setUserName(o.getUserName());
        this.setSource(o.getSource());
        this.setSourceId(o.getSourceId());
        this.setOrdCategory(o.getOrdCategory());
        this.setAlgoId(o.getAlgoId());
        this.setExtCashAccntId(o.getExtCashAccntId());
        this.setAvgPx(o.getAvgPx());
        this.setAvgYield(o.getAvgYield());
        this.setObject(o.getObject());
        this.setClOrdId(o.getClOrdId());
        this.setParentId(o.getParentId());
        this.setCanCancel(o.isCanCancel());
        this.setInvestorId(o.getInvestorId());
        this.setInvestorSecId(o.getInvestorSecId());
        this.setWthQty(o.getWthQty());
        this.setWthTime(o.getWthTime());
        this.setRiskDetail(o.getRiskDetail());
        if (o.getYieldData() != null) {
            this.setYield(o.getYieldData().getYield());
        }
        this.setTif(o.getTif());
        this.setMaxPriceLevels(o.getMaxPriceLevels());
        this.setOrdTypeDesc(this.translateOrdType(this));
        this.setFrozenMargin(o.getFrozenMargin());
        this.setNeeqErrInfo(o.getNeeqErrInfo());
        this.setOrdDateTime(o.getOrdDateTime());
        if (o.getInstrument() != null) {
            if (COMMON_ISSUE.equals(o.getInstrument().getMarketIndicator())) {
                this.setIssueId(o.getInstrument().getSecurityId());
                this.setIssueName(o.getInstrument().getSymbol());
                if (o.getUnderlying() != null) {
                    this.setSecurityId(o.getUnderlying().getSecurityId());
                    this.setSecurityName(o.getUnderlying().getSymbol());
                }
            } else {
                this.setSecurityId(o.getInstrument().getSecurityId());
                this.setSecurityName(o.getInstrument().getSymbol());
            }
        }
        this.setPositionEffect(o.getPositionEffect());
        this.setDonePercent(o.getDonePercent());
        this.setMarket(o.getMarket());
        this.setMarketIndicator(o.getMarketIndicator());
        this.setUnit(o.getUnit());
        this.setInvestorName(o.getInvestorName());
    }

    private String translateOrdType(SingleOrder order) {
        block34: {
            StringBuilder sb;
            block36: {
                block37: {
                    block35: {
                        if (order.getOrdType() == null) {
                            return "";
                        }
                        if ("50".equals(order.getOrdType().getValue())) {
                            return "\u9650\u4ef7";
                        }
                        if ("99".equals(order.getOrdType().getValue()) || "80".equals(order.getOrdType().getValue())) {
                            return "\u76d8\u540e\u56fa\u5b9a\u4ef7";
                        }
                        if (!"49".equals(order.getOrdType().getValue())) break block34;
                        sb = new StringBuilder("\u5e02\u4ef7");
                        if (!"XSHE".equals(order.getInstrument().getMarket())) break block35;
                        switch (order.getTif()) {
                            case 48: {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                if (order.getMaxPriceLevels() == 1) {
                                    sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                break block36;
                            }
                            case 51: {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("-\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                                    break;
                                }
                                if (order.getMaxPriceLevels() == 5) {
                                    sb.append("-\u4e94\u6863\u5373\u6210\u5269\u64a4");
                                    break;
                                }
                                break block36;
                            }
                            case 52: {
                                sb.append("-\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                                break;
                            }
                        }
                        break block36;
                    }
                    if (!"XSHG".equals(order.getInstrument().getMarket())) break block37;
                    switch (order.getTif()) {
                        case 48: {
                            if (order.getInstrument().getSecurityId().startsWith("688")) {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                } else if (order.getMaxPriceLevels() == 1) {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                } else if (order.getMaxPriceLevels() == 5) {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                }
                                sb.append((double)Math.round(order.getPrice() * 100.0) / 100.0);
                                break;
                            }
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 1) {
                                sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 5) {
                                sb.append("-\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7");
                                break;
                            }
                            break block36;
                        }
                        case 51: {
                            if (order.getInstrument().getSecurityId().startsWith("688")) {
                                sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4-\u4fdd\u62a4\u4ef7\u683c-");
                                sb.append((double)Math.round(order.getPrice() * 100.0) / 100.0);
                                break;
                            }
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                            break;
                        }
                    }
                    break block36;
                }
                if ("NEEQ".equals(order.getInstrument().getMarket())) {
                    switch (order.getTif()) {
                        case 48: {
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18");
                                break;
                            }
                            if (order.getMaxPriceLevels() != 1) break;
                            sb.append("-\u5bf9\u624b\u65b9\u6700\u4f18");
                            break;
                        }
                        case 51: {
                            sb.append("-\u6700\u4f18\u4e94\u6863\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                            break;
                        }
                        case 66: {
                            sb.append("-\u6700\u4f18\u4e94\u6863\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u8f6c\u9650\u4ef7\u7533\u62a5");
                            break;
                        }
                        case 52: {
                            sb.append("-\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                            break;
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public void setExtraFields() {
        if (this.getSelfParty() != null) {
            this.setTraderId(this.getSelfParty().getTraderId());
        }
        double unit = 1.0;
        if ("XcfeXBond".equals(this.getInstrument().getSecuritySubType())) {
            unit = 10000.0;
        } else if ("XcfeXRepo".equals(this.getInstrument().getSecuritySubType())) {
            unit = 1.0E8;
        }
        this.setOrderQty(this.getOrderQty() / unit);
        this.setLeavesQty(this.getLeavesQty() / unit);
        this.setCumQty(this.getCumQty() / unit);
        if (this.getInstrument() == null || !BsDict.HKUSA_MARKET.contains(this.getInstrument().getMarket()) && !"SGEX".equals(this.getInstrument().getMarket())) {
            this.setOrdTime(this.getOrdTime().substring(0, 8));
        }
        if (this.getExecMode() != null) {
            String source = this.getExecMode().getEmName();
            if ("XHKG".equals(this.getInstrument().getMarket())) {
                StringBuffer type = new StringBuffer(this.getOrdType().getValue());
                type.append("#").append(this.getSource());
                MxNode node = MxNodeFactory.create((String)"hk_algo_name", (String)type.toString());
                if (node != null) {
                    source = node.getValue();
                }
            }
            this.setSource(source);
            this.setSourceId(String.valueOf(this.getExecMode().getEmId()));
            MxNode node = MxNodeFactory.create((String)"xbond_ord_type", (String)this.getExecMode().getEmType().strValue());
            this.setOrdCategory(node.getValue());
        }
        double per = 0.0;
        if (this.getCumQty() > 0.0 && this.getOrderQty() > 0.0) {
            per = this.getCumQty() * 100.0 / this.getOrderQty();
        }
        this.setDonePercent(per);
        if (this.getOrdStatus() != null && this.getOrdStatus().getValue() != null) {
            this.setStatus(this.getOrdStatus().getDes());
            this.setCanCancel(CAN_CANCEL_STATUS.contains(this.getOrdStatus().getValue()));
        }
        this.setOrdTypeDesc(this.translateOrdType(this));
        if (this.getYieldData() != null && this.getYieldData().getYield() != null) {
            this.setYield(this.getYieldData().getYield());
        }
        if (this.getInstrument() != null) {
            if (COMMON_ISSUE.equals(this.getInstrument().getMarketIndicator())) {
                this.setIssueId(this.getInstrument().getSecurityId());
                this.setIssueName(this.getInstrument().getSymbol());
                this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
                this.setSecurityGroup(this.getInstrument().getSecurityGroup());
                this.setSecuritySubType(this.getInstrument().getSecuritySubType());
                if (this.getUnderlying() != null) {
                    this.setSecurityId(this.getUnderlying().getSecurityId());
                    this.setSecurityName(this.getUnderlying().getSymbol());
                }
            } else {
                this.setSecurityId(this.getInstrument().getSecurityId());
                this.setSecurityName(this.getInstrument().getSymbol());
                this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
                this.setSecurityGroup(this.getInstrument().getSecurityGroup());
                this.setSecuritySubType(this.getInstrument().getSecuritySubType());
                this.setMarketIndicator(MarketIndicator.getDesc(this.getInstrument().getMarketIndicator()));
            }
        }
        this.setNeeqErrInfo(this.transferErrInfo(this));
        this.setOrdDateTime(String.valueOf(this.getOrdDate()) + this.getOrdTime());
    }

    private String transferErrInfo(SingleOrder en) {
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getWthErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u9519\u8bef\uff08" + en.getWthErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u8be6\u60c5\uff08" + en.getRiskDetail() + "\uff09";
        }
        return errorInfo;
    }

    public double getYield() {
        return this.yield;
    }

    public void setYield(double yield) {
        this.yield = yield;
    }

    public YieldData getYieldData() {
        return this.yieldData;
    }

    public void setYieldData(YieldData yieldData) {
        this.yieldData = yieldData;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getWthErrInfo() {
        return this.wthErrInfo;
    }

    public void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfo = wthErrInfo;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public Party getSelfParty() {
        return this.selfParty;
    }

    public void setSelfParty(Party selfParty) {
        this.selfParty = selfParty;
    }

    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getExtOrderId() {
        return this.extOrderId;
    }

    public void setExtOrderId(String extOrderId) {
        this.extOrderId = extOrderId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getExecId() {
        return this.execId;
    }

    public void setExecId(String execId) {
        this.execId = execId;
    }

    public String getExecTime() {
        return this.execTime;
    }

    public void setExecTime(String execTime) {
        this.execTime = execTime;
    }

    public double getLastQty() {
        return this.lastQty;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType ordType) {
        this.ordType = ordType;
    }

    public OrdStatus getOrdStatus() {
        return this.ordStatus;
    }

    public void setOrdStatus(OrdStatus ordStatus) {
        this.ordStatus = ordStatus;
    }

    public void setLastQty(double lastQty) {
        this.lastQty = lastQty;
    }

    public double getLastPx() {
        return this.lastPx;
    }

    public void setLastPx(double lastPx) {
        this.lastPx = lastPx;
    }

    public double getLeavesQty() {
        return this.leavesQty;
    }

    public void setLeavesQty(double leavesQty) {
        this.leavesQty = leavesQty;
    }

    public double getAvgPx() {
        return this.avgPx;
    }

    public void setAvgPx(double avgPx) {
        this.avgPx = avgPx;
    }

    public double getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(double totalValue) {
        this.totalValue = totalValue;
    }

    public double getFrozenCommission() {
        return this.frozenCommission;
    }

    public void setFrozenCommission(double frozenCommission) {
        this.frozenCommission = frozenCommission;
    }

    public double getMargenTaken() {
        return this.margenTaken;
    }

    public void setMargenTaken(double margenTaken) {
        this.margenTaken = margenTaken;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(String riskDetail) {
        this.riskDetail = riskDetail;
    }

    public String getWthUserId() {
        return this.wthUserId;
    }

    public void setWthUserId(String wthUserId) {
        this.wthUserId = wthUserId;
    }

    public String getWthTime() {
        return this.wthTime;
    }

    public void setWthTime(String wthTime) {
        this.wthTime = wthTime;
    }

    public int getTif() {
        return this.tif;
    }

    public void setTif(int tif) {
        this.tif = tif;
    }

    public int getMaxPriceLevels() {
        return this.maxPriceLevels;
    }

    public void setMaxPriceLevels(int maxPriceLevels) {
        this.maxPriceLevels = maxPriceLevels;
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public double getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(double tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public SettlType getSettlType() {
        return this.settlType;
    }

    public void setSettlType(SettlType settlType) {
        this.settlType = settlType;
    }

    public String getTermToMaturity() {
        return this.termToMaturity;
    }

    public void setTermToMaturity(String termToMaturity) {
        this.termToMaturity = termToMaturity;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public String getTraderId() {
        return this.traderId;
    }

    public void setTraderId(String traderId) {
        this.traderId = traderId;
    }

    public String getClOrdId() {
        return this.clOrdId;
    }

    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public Instrument getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(Instrument underlying) {
        this.underlying = underlying;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public String getSubCashAccntId() {
        return this.subCashAccntId;
    }

    public void setSubCashAccntId(String subCashAccntId) {
        this.subCashAccntId = subCashAccntId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public OrdStatus getPreOrdStatus() {
        return this.preOrdStatus;
    }

    public void setPreOrdStatus(OrdStatus preOrdStatus) {
        this.preOrdStatus = preOrdStatus;
    }

    public double getFilledAvgPrice() {
        return this.filledAvgPrice;
    }

    public void setFilledAvgPrice(double filledAvgPrice) {
        this.filledAvgPrice = filledAvgPrice;
    }

    public int getFrozenQty() {
        return this.frozenQty;
    }

    public void setFrozenQty(int frozenQty) {
        this.frozenQty = frozenQty;
    }

    public int getWthQty() {
        return this.wthQty;
    }

    public void setWthQty(int wthQty) {
        this.wthQty = wthQty;
    }

    public int getWthErrCode() {
        return this.wthErrCode;
    }

    public void setWthErrCode(int wthErrCode) {
        this.wthErrCode = wthErrCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public CcsOrder getObject() {
        return this.object;
    }

    public void setObject(CcsOrder object) {
        this.object = object;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String transferErrInfo() {
        StringBuilder errorInfo = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.getErrInfo())) {
            errorInfo.append("\uff08").append(this.getErrInfo()).append("\uff09");
        }
        if (!StringUtils.isEmpty((String)this.getWthErrInfo())) {
            errorInfo.append("\uff08").append(this.getWthErrInfo()).append("\uff09");
        }
        return errorInfo.toString();
    }

    public String getTradeName() {
        return this.tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public int getCanCancelFlag() {
        return this.canCancelFlag;
    }

    public void setCanCancelFlag(int canCancelFlag) {
        this.canCancelFlag = canCancelFlag;
    }

    public String getSecurityGroup() {
        return this.securityGroup;
    }

    public void setSecurityGroup(String securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getSecuritySubType() {
        return this.securitySubType;
    }

    public void setSecuritySubType(String securitySubType) {
        this.securitySubType = securitySubType;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public String getIssueName() {
        return this.issueName;
    }

    public void setIssueName(String issueName) {
        this.issueName = issueName;
    }

    public String getNeeqErrInfo() {
        return this.neeqErrInfo;
    }

    public void setNeeqErrInfo(String neeqErrInfo) {
        this.neeqErrInfo = neeqErrInfo;
    }

    public String getOrdDateTime() {
        return this.ordDateTime;
    }

    public void setOrdDateTime(String ordDateTime) {
        this.ordDateTime = ordDateTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSideString() {
        return this.sideString;
    }

    public void setSideString(String sideString) {
        this.sideString = sideString;
    }

    public String getOrdTypeDesc() {
        return this.ordTypeDesc;
    }

    public void setOrdTypeDesc(String ordTypeDesc) {
        this.ordTypeDesc = ordTypeDesc;
    }

    public double getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(double orderQty) {
        this.orderQty = orderQty;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public double getCumQty() {
        return this.cumQty;
    }

    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    public double getFrozenMargin() {
        return this.frozenMargin;
    }

    public void setFrozenMargin(double frozenMargin) {
        this.frozenMargin = frozenMargin;
    }

    public String getOrdDate() {
        return this.ordDate;
    }

    public void setOrdDate(String ordDate) {
        this.ordDate = ordDate;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public double getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public double getRealFee() {
        return this.realFee;
    }

    public void setRealFee(double realFee) {
        this.realFee = realFee;
    }

    public double getCommision() {
        return this.commision;
    }

    public void setCommision(double commision) {
        this.commision = commision;
    }

    public double getStampTax() {
        return this.stampTax;
    }

    public void setStampTax(double stampTax) {
        this.stampTax = stampTax;
    }

    public double getHandleFee() {
        return this.handleFee;
    }

    public void setHandleFee(double handleFee) {
        this.handleFee = handleFee;
    }

    public double getSecAdminFee() {
        return this.secAdminFee;
    }

    public void setSecAdminFee(double secAdminFee) {
        this.secAdminFee = secAdminFee;
    }

    public double getOtherFee() {
        return this.otherFee;
    }

    public void setOtherFee(double otherFee) {
        this.otherFee = otherFee;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInvestorSecId() {
        return this.investorSecId;
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecId = investorSecId;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public double getDonePercent() {
        return this.donePercent;
    }

    public void setDonePercent(double donePercent) {
        this.donePercent = donePercent;
    }

    public double getChgOwnerFee() {
        return this.chgOwnerFee;
    }

    public void setChgOwnerFee(double chgOwnerFee) {
        this.chgOwnerFee = chgOwnerFee;
    }

    public String getPositionEffect() {
        return this.positionEffect;
    }

    public void setPositionEffect(String positionEffect) {
        this.positionEffect = positionEffect;
    }

    public String getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(String extAccntId) {
        this.extAccntId = extAccntId;
    }

    public String getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(String subAccntId) {
        this.subAccntId = subAccntId;
    }

    public LegMode getLegMode() {
        return this.legMode;
    }

    public void setLegMode(LegMode legMode) {
        this.legMode = legMode;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public Order convert() {
        Order order = new Order();
        order.setOrderId(this.getOrderId());
        order.setClOrdId(this.getClOrdId());
        order.setExtOrderId(this.getExtOrderId());
        order.setParentId(this.getParentId());
        order.setResourceId(this.getResourceId());
        order.setReference(this.getReference());
        if (this.getInstrument() != null) {
            order.setInstrument(this.getInstrument());
        }
        if (this.getUnderlying() != null) {
            order.setInstrument(this.getInstrument());
        }
        order.getExtAccntId().setCashAccntId(this.getExtCashAccntId());
        order.getExtAccntId().setSecAccntId(this.getExtSecAccntId());
        order.getExtAccntId().setAccntId(this.getExtAccntId());
        if (order.getSubAccntId() != null) {
            order.getSubAccntId().setAccntId(this.getSubAccntId());
            order.getSubAccntId().setCashAccntId(this.getSubCashAccntId());
            order.getSubAccntId().setSecAccntId(this.getSubSecAccntId());
        }
        order.setPortfolioId(this.getPortfolioId());
        order.setBrokerId(this.getBrokerId());
        order.setInvestorId(this.getInvestorId());
        order.setInvestorSecId(this.getInvestorSecId());
        order.setSide(this.getSide());
        order.setOrdType(this.getOrdType());
        if (this.getLegMode() != null) {
            order.setLegMode(this.getLegMode());
        }
        if (this.getExecMode() != null) {
            order.setExecMode(this.getExecMode());
        }
        order.setMatchType(this.getMatchType());
        order.setInactive(this.inactive);
        order.setOrdStatus(this.getOrdStatus());
        order.setPreOrdStatus(this.getPreOrdStatus());
        order.setOrderQty(this.getOrderQty());
        order.setPrice(this.getPrice());
        order.setTif(this.getTif());
        order.setUserId(this.getUserId());
        order.setUserName(this.getUserName());
        order.setOrdDate(this.getOrdDate());
        order.setOrdTime(this.getOrdTime());
        order.setTradeAmount(this.getTradeAmount());
        order.setOrderAmount(this.getOrderAmount());
        order.setMaxPriceLevels(this.getMaxPriceLevels());
        order.setPortfolioName(this.getPortfolioName());
        order.setCxlQty(this.getWthQty());
        order.setCxlTime(this.getWthTime());
        order.setCxlUserId(this.getWthUserId());
        order.setCanCancelFlag(this.getCanCancelFlag());
        order.setFrozenQty(this.getFrozenQty());
        order.setFrozenMargin(this.getFrozenMargin());
        order.setFrozenCommission(this.getFrozenCommission());
        order.setMargenTaken(this.getMargenTaken());
        order.setRiskDetail(this.getRiskDetail());
        order.setExecId(this.getExecId());
        order.setLastQty(this.getLastQty());
        order.setLastPx(this.getLastPx());
        order.setCumQty(this.getCumQty());
        order.setLeavesQty(this.getLeavesQty());
        order.setAvgPx(this.getAvgPx());
        order.setTotalValue(this.getTotalValue());
        order.setErrCode(this.getErrCode());
        order.setErrInfo(this.getErrInfo());
        order.setCxlErrCode(this.getWthErrCode());
        order.setCxlErrInfo(this.getWthErrInfo());
        order.setRealFee(this.getRealFee());
        order.setCommission(this.getCommision());
        order.setChgOwnerFee(this.getChgOwnerFee());
        order.setStampTax(this.getStampTax());
        order.setHandleFee(this.getHandleFee());
        order.setOtherFee(this.getOtherFee());
        order.setSettlType(this.getSettlType());
        if (this.getYieldData() != null) {
            order.setYieldData(this.getYieldData());
        }
        order.setTermToMaturity(this.getTermToMaturity());
        if (this.getSelfParty() != null) {
            order.setSelfparty(this.getSelfParty());
        }
        order.setAttachment(this.getAttachment());
        order.setUnit(this.getUnit());
        order.setOrdTypeDesc(this.getOrdTypeDesc());
        order.setSelected(this.isSelected());
        order.setMarket(this.getMarket());
        order.setPositionEffect(this.getPositionEffect());
        return order;
    }

    public String getMarketIndicator() {
        return this.marketIndicator;
    }

    public void setMarketIndicator(String marketIndicator) {
        this.marketIndicator = marketIndicator;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public boolean isCanCancelReplace() {
        return this.canCancelReplace;
    }

    public void setCanCancelReplace(boolean canCancelReplace) {
        this.canCancelReplace = canCancelReplace;
    }

    public double getAvgYield() {
        return this.avgYield;
    }

    public void setAvgYield(double avgYield) {
        this.avgYield = avgYield;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getAlgoId() {
        return this.algoId;
    }

    public void setAlgoId(String algoId) {
        this.algoId = algoId;
    }

    public String getInvestorName() {
        return this.investorName;
    }

    public void setInvestorName(String investorName) {
        this.investorName = investorName;
    }

    public String getOrdCategory() {
        return this.ordCategory;
    }

    public void setOrdCategory(String ordCategory) {
        this.ordCategory = ordCategory;
    }
}

