/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.javafx.MxNode;
import cms.tmx.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum Side {
    SIDE_UNDEFINED("0"),
    SIDE_BUY("49"),
    SIDE_SELL("50"),
    SIDE_BUY_MINUS("51"),
    SIDE_SELL_PLUS("52"),
    SIDE_SELL_SHORT("53"),
    SIDE_AS_DEFINED("66"),
    SIDE_OPPOSITE("67"),
    SIDE_SUBSCRIBE("68"),
    SIDE_REDEEM("69"),
    SIDE_LEND("70"),
    SIDE_BORROW("71"),
    SIDE_CREATION("72"),
    SIDE_CASH_DIVIDEND("73"),
    SIDE_DIVIDEND_REINVEST("74"),
    SIDE_BID("80"),
    SIDE_OFFER("81"),
    SIDE_IMPAWN_IN("82"),
    SIDE_IMPAWN_OUT("83"),
    SIDE_TRANSFER("136"),
    SIDE_TRANSFER_IN("137"),
    SIDE_TRANSFER_OUT("138"),
    SIDE_PROVISTON("141"),
    SIDE_BOND_ISSUE("200"),
    SIDE_STOCK_ISSUE("201");

    private String value;
    private static final Map<String, String> NAME_MAP;

    static {
        NAME_MAP = new HashMap<String, String>(){
            {
                this.put("49", "\u4e70\u5165");
                this.put("50", "\u5356\u51fa");
                this.put("201", "\u65b0\u80a1\u7533\u8d2d");
                this.put("70", "\u9006\u56de\u8d2d");
                this.put("71", "\u6b63\u56de\u8d2d");
                this.put("68", "\u8ba4\u8d2d");
                this.put("69", "\u8d4e\u56de");
                this.put("72", "\u7533\u8d2d");
                this.put("73", "\u73b0\u91d1\u5206\u7ea2");
                this.put("74", "\u7ea2\u5229\u518d\u6295\u8d44");
                this.put("80", "BID");
                this.put("81", "OFFER");
                this.put("82", "\u8d28\u62bc\u5165\u5e93");
                this.put("83", "\u8d28\u62bc\u51fa\u5e93");
                this.put("200", "\u53ef\u8f6c\u503a\u7533\u8d2d");
                this.put("99", "\u4e70\u5356");
                this.put("53", "\u5356\u7a7a");
                this.put("136", "\u8f6c\u6362");
                this.put("137", "\u8f6c\u5165");
                this.put("138", "\u8f6c\u51fa");
                this.put("141", "\u4e1a\u7ee9\u8ba1\u63d0");
            }
        };
    }

    private Side(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static Side get(String str) {
        Side[] sideArray = Side.values();
        int n = sideArray.length;
        int n2 = 0;
        while (n2 < n) {
            Side item = sideArray[n2];
            if (item.getValue().equals(str)) {
                return item;
            }
            ++n2;
        }
        return SIDE_UNDEFINED;
    }

    public String getSideName() {
        return NAME_MAP.get(this.getValue());
    }

    public String toString() {
        MxNode node = new MxNode().load("side", this.getValue());
        return StringUtils.isEmpty((String)node.getValue()) ? this.getValue() : node.getValue();
    }
}

