/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.extra.PositionSummaryExtra;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.PosAccnt;
import cms.tmx.http.api.strategy.dto.PosExtra;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.PosType;
import cms.tmx.http.api.strategy.dto.PositionQty;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.utils.MarketUtils;
import java.util.List;

public class Position
extends MxDirtyObj {
    private String investorId;
    private String inverstorSecId;
    private AccntType accntType;
    private PosAccnt posAccnt;
    private Instrument instrument;
    private List<PositionQty> posQty;
    private PosStatistic posStatistic;
    private PosExtra posExtra;
    private String trdDate = "";
    private PositionSummaryExtra object;
    private SecSubType secSubType;
    transient double sodQty = 0.0;
    transient double intraDayQty = 0.0;
    transient double frozenQty = 0.0;
    transient double secBalance = 0.0;
    transient double secAvail = 0.0;
    transient double secWithDraw = 0.0;
    transient double cashBalance = 0.0;
    transient double cashAvail = 0.0;
    transient double cashWithDraw = 0.0;
    transient double marginQty = 0.0;
    transient double receivable = 0.0;
    transient double payable = 0.0;
    private String secAccntId;
    private String cashAccntId;
    private transient String securityId = "";
    private transient String securityName = "";
    private transient String market = "";
    private transient String unit;
    private transient double cost = 0.0;
    private transient double holdCostAmt = 0.0;
    private transient double marketValue = 0.0;
    private transient double buyCost = 0.0;
    private transient double yield = 0.0;
    private transient double floatPnl = 0.0;
    private transient double totalProfit = 0.0;
    private transient double todayRealizedPl = 0.0;
    private double nowPrice = 0.0;
    private transient double closePrice = 0.0;
    private transient double percent = 0.0;
    private String side = "";
    private int status = 0;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String unique() {
        return String.valueOf(this.getPosAccnt().getSecAccntId()) + this.getInstrument().getSecurityId() + this.getPosStatistic().getStatus();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.instrument.getSecurityId() == null ? 0 : this.instrument.getSecurityId().hashCode());
        result = 31 * result + (this.instrument.getMarket() == null ? 0 : this.instrument.getMarket().hashCode());
        result = 31 * result + (this.instrument.getSecurityType() == null ? 0 : this.instrument.getSecurityType().hashCode());
        result = 31 * result + (this.posAccnt.getSecAccntId() == null ? 0 : this.posAccnt.getSecAccntId().hashCode());
        result = 31 * result + (this.trdDate == null ? 0 : this.trdDate.hashCode());
        result = 31 * result + (this.secSubType == null ? 0 : this.secSubType.hashCode());
        result = 31 * result + this.status;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)((Object)obj);
        if (this.instrument.getSecurityId() == null ? other.getInstrument().getSecurityId() != null : !this.instrument.getSecurityId().equals(other.getInstrument().getSecurityId())) {
            return false;
        }
        if (this.instrument.getMarket() == null ? other.getInstrument().getMarket() != null : !this.instrument.getMarket().equals(other.getInstrument().getMarket())) {
            return false;
        }
        if (this.instrument.getSecurityType() == null ? other.getInstrument().getSecurityType() != null : !this.instrument.getSecurityType().equals(other.getInstrument().getSecurityType())) {
            return false;
        }
        if (this.posAccnt.getSecAccntId() == null ? other.getPosAccnt().getSecAccntId() != null : !this.posAccnt.getSecAccntId().equals(other.getPosAccnt().getSecAccntId())) {
            return false;
        }
        if (this.trdDate == null ? other.getTrdDate() != null : !this.trdDate.equals(other.getTrdDate())) {
            return false;
        }
        if (this.secSubType == null ? other.getSecSubType() != null : !this.secSubType.equals((Object)other.getSecSubType())) {
            return false;
        }
        return this.status == other.status;
    }

    public void update(Object obj) {
        if (obj instanceof Position) {
            Position s = (Position)((Object)Position.class.cast(obj));
            this.update(s);
        } else if (obj instanceof Positions) {
            Positions s = (Positions)Positions.class.cast(obj);
            this.update(s);
        }
    }

    private void update(Positions p) {
        this.setAccntType(p.getAccntType());
        this.setPosAccnt(p.getPosAccnt());
        this.setInstrument(p.getInstrument());
        this.setPosQty(p.getPosQty());
        this.setPosExtra(p.getPosExtra());
        this.setTrdDate(p.getTrdDate());
    }

    private void update(Position p) {
        this.setUnit(p.getUnit());
        this.setSodQty(p.getSodQty());
        this.setIntraDayQty(p.getIntraDayQty());
        this.setFrozenQty(p.getFrozenQty());
        this.setSecBalance(p.getSecBalance());
        this.setSecAvail(p.getSecAvail());
        this.setCashBalance(p.getCashBalance());
        this.setCashAvail(p.getCashAvail());
        this.setMarginQty(p.getMarginQty());
        this.setPosAccnt(p.getPosAccnt());
        this.setInstrument(p.getInstrument());
        this.setPosStatistic(p.getPosStatistic());
        this.setReceivable(p.getReceivable());
        this.setPayable(p.getPayable());
        this.setObject(p.getObject());
        this.setInvestorId(p.getInvestorId());
        this.setInverstorSecId(p.getInverstorSecId());
        this.setSecurityId(p.getSecurityId());
        this.setMarket(p.getMarket());
        this.setSecAccntId(p.getSecAccntId());
        this.setCashAccntId(p.getCashAccntId());
    }

    public void transformQty() {
        if (this.posQty == null) {
            return;
        }
        for (PositionQty position : this.posQty) {
            if (this.getPosStatistic() != null && position.getStatus() != this.getPosStatistic().getStatus()) continue;
            if (position.getType() == PosType.kPosTypeSod) {
                this.sodQty = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypeIntraday) {
                this.intraDayQty = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypeFrozen) {
                this.frozenQty = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypeMargin) {
                this.marginQty = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypeReceivable) {
                this.receivable = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypePayable) {
                this.payable = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypeBalance) {
                if (this.accntType == AccntType.ACCNT_TYPE_SEC) {
                    this.secBalance = position.getLongQty();
                    continue;
                }
                if (this.accntType != AccntType.ACCNT_TYPE_CASH) continue;
                this.cashBalance = position.getLongQty();
                continue;
            }
            if (position.getType() == PosType.kPosTypeAvail) {
                if (this.accntType == AccntType.ACCNT_TYPE_SEC) {
                    this.secAvail = position.getLongQty();
                    continue;
                }
                if (this.accntType != AccntType.ACCNT_TYPE_CASH) continue;
                this.cashAvail = position.getLongQty();
                continue;
            }
            if (position.getType() != PosType.kPosTypeSyncWithDraw) continue;
            if (this.accntType == AccntType.ACCNT_TYPE_SEC) {
                this.secWithDraw = position.getLongQty();
                continue;
            }
            if (this.accntType != AccntType.ACCNT_TYPE_CASH) continue;
            this.cashWithDraw = position.getLongQty();
        }
    }

    public void setExtraFields() {
        if (this.getInstrument() != null) {
            this.setSecurityId(this.getInstrument().getSecurityId());
            this.setSecurityName(this.getInstrument().getSymbol());
            this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
        }
        if (this.getPosStatistic() != null) {
            this.setStatus(this.getPosStatistic().getStatus());
        }
        if (this.getPosStatistic() != null) {
            this.setCost(this.getPosStatistic().getCost());
            this.setHoldCostAmt(this.getPosStatistic().getHoldCostAmt());
            this.setBuyCost(this.getPosStatistic().getBuyCost());
            this.setTodayRealizedPl(this.getPosStatistic().getRealPnl() - (double)Math.round(this.getPosStatistic().getPreRealPnl() * 1000.0) / 1000.0);
        }
    }

    public double getReceivable() {
        return this.receivable;
    }

    public void setReceivable(double receivable) {
        this.receivable = receivable;
    }

    public double getPayable() {
        return this.payable;
    }

    public void setPayable(double payable) {
        this.payable = payable;
    }

    public AccntType getAccntType() {
        return this.accntType;
    }

    public void setAccntType(AccntType accntType) {
        this.accntType = accntType;
    }

    public PosAccnt getPosAccnt() {
        return this.posAccnt;
    }

    public void setPosAccnt(PosAccnt posAccnt) {
        this.posAccnt = posAccnt;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public List<PositionQty> getPosQty() {
        return this.posQty;
    }

    public void setPosQty(List<PositionQty> posQty) {
        this.posQty = posQty;
    }

    public PosStatistic getPosStatistic() {
        return this.posStatistic;
    }

    public void setPosStatistic(PosStatistic posStatistic) {
        this.posStatistic = posStatistic;
    }

    public PosExtra getPosExtra() {
        return this.posExtra;
    }

    public void setPosExtra(PosExtra posExtra) {
        this.posExtra = posExtra;
    }

    public double getSodQty() {
        return this.sodQty;
    }

    public void setSodQty(double sodQty) {
        this.sodQty = sodQty;
    }

    public double getIntraDayQty() {
        return this.intraDayQty;
    }

    public void setIntraDayQty(double intraDayQty) {
        this.intraDayQty = intraDayQty;
    }

    public double getFrozenQty() {
        return this.frozenQty;
    }

    public void setFrozenQty(double frozenQty) {
        this.frozenQty = frozenQty;
    }

    public double getSecBalance() {
        return this.secBalance;
    }

    public void setSecBalance(double secBalance) {
        this.secBalance = secBalance;
    }

    public double getSecAvail() {
        return this.secAvail;
    }

    public void setSecAvail(double secAvail) {
        this.secAvail = secAvail;
    }

    public double getCashBalance() {
        return this.cashBalance;
    }

    public void setCashBalance(double cashBalance) {
        this.cashBalance = cashBalance;
    }

    public double getCashAvail() {
        return this.cashAvail;
    }

    public void setCashAvail(double cashAvail) {
        this.cashAvail = cashAvail;
    }

    public double getMarginQty() {
        return this.marginQty;
    }

    public void setMarginQty(double marginQty) {
        this.marginQty = marginQty;
    }

    public String getTrdDate() {
        return this.trdDate;
    }

    public void setTrdDate(String trdDate) {
        this.trdDate = trdDate;
    }

    public PositionSummaryExtra getObject() {
        return this.object;
    }

    public void setObject(PositionSummaryExtra object) {
        this.object = object;
    }

    public SecSubType getSecSubType() {
        return this.secSubType;
    }

    public void setSecSubType(SecSubType secSubType) {
        this.secSubType = secSubType;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInverstorSecId() {
        return this.inverstorSecId;
    }

    public void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecId = inverstorSecId;
    }

    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getSecAccntId() {
        return this.secAccntId;
    }

    public void setSecAccntId(String secAccntId) {
        this.secAccntId = secAccntId;
    }

    public String getCashAccntId() {
        return this.cashAccntId;
    }

    public void setCashAccntId(String cashAccntId) {
        this.cashAccntId = cashAccntId;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public double getHoldCostAmt() {
        return this.holdCostAmt;
    }

    public void setHoldCostAmt(double holdCostAmt) {
        this.holdCostAmt = holdCostAmt;
    }

    public double getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(double marketValue) {
        this.marketValue = marketValue;
    }

    public double getBuyCost() {
        return this.buyCost;
    }

    public void setBuyCost(double buyCost) {
        this.buyCost = buyCost;
    }

    public double getYield() {
        return this.yield;
    }

    public void setYield(double yield) {
        this.yield = yield;
    }

    public double getFloatPnl() {
        return this.floatPnl;
    }

    public void setFloatPnl(double floatPnl) {
        this.floatPnl = floatPnl;
    }

    public double getTotalProfit() {
        return this.totalProfit;
    }

    public void setTotalProfit(double totalProfit) {
        this.totalProfit = totalProfit;
    }

    public double getTodayRealizedPl() {
        return this.todayRealizedPl;
    }

    public void setTodayRealizedPl(double todayRealizedPl) {
        this.todayRealizedPl = todayRealizedPl;
    }

    public double getNowPrice() {
        return this.nowPrice;
    }

    public void setNowPrice(double nowPrice) {
        this.nowPrice = nowPrice;
    }

    public double getClosePrice() {
        return this.closePrice;
    }

    public void setClosePrice(double closePrice) {
        this.closePrice = closePrice;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public double getSecWithDraw() {
        return this.secWithDraw;
    }

    public void setSecWithDraw(double secWithDraw) {
        this.secWithDraw = secWithDraw;
    }

    public double getCashWithDraw() {
        return this.cashWithDraw;
    }

    public void setCashWithDraw(double cashWithDraw) {
        this.cashWithDraw = cashWithDraw;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }
}

