/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.marketdata.dto.YieldData;
import cms.tmx.http.api.pricingit.ExecMode;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.OrdStatus;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.query.CcsOrder;
import cms.tmx.http.query.LegMode;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxSelObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class Order
extends MxSelObj {
    public static final List<String> CAN_CANCEL_STATUS = Arrays.asList("90", "87", "65", "48", "49", "54");
    private String userId = "";
    private String userName = "";
    private String orderId = "";
    private String extOrderId = "";
    private Instrument instrument;
    private Side side;
    private String sideString = "";
    private OrdType ordType;
    private String ordTypeDesc = "";
    YieldData yieldData;
    private double orderQty = 0.0;
    private double price;
    private double newPrice;
    private String execId = "";
    private String execTime = "";
    private OrdStatus ordStatus;
    private String status = "";
    private double lastQty;
    private double lastPx;
    private double cumQty = 0.0;
    private double leavesQty;
    private double avgPx;
    private double totalValue;
    private double frozenMargin = 0.0;
    private double frozenCommission;
    private double margenTaken;
    private String ordDate = "";
    private String ordTime = "";
    private String ordDateTime = "";
    private double orderAmount = 0.0;
    private MatchType matchType;
    private SettlType settlType;
    private String termToMaturity = "";
    private Party selfparty;
    private String traderId = "";
    ExecMode execMode;
    private String resourceId = "";
    private String reference = "";
    private String riskDetail = "";
    private String wthUserId = "";
    private String wthTime = "";
    private double realFee = 0.0;
    private double chgOwnerFee = 0.0;
    private double stampTax = 0.0;
    private double handleFee = 0.0;
    private double secAdminFee = 0.0;
    private double otherFee = 0.0;
    private double tradeAmount;
    private int tif;
    private int maxPriceLevels;
    private String errInfo = "";
    private transient String neeqErrInfo;
    private String wthErrInfo;
    private String clOrdId = "";
    private String extSecAccntId;
    private String subSecAccntId;
    private Instrument underlying;
    private String extCashAccntId;
    private String subCashAccntId;
    private String portfolioId = "";
    private String investorId = "";
    private String brokerId;
    private OrdStatus preOrdStatus;
    private double filledAvgPrice;
    private double frozenQty;
    private int wthQty;
    private int wthErrCode;
    private int errCode;
    private String attachment;
    private int canCancelFlag;
    private CcsOrder object;
    private String parentId = "";
    private boolean canCancel = false;
    private String investorSecId = "";
    private transient String securityId = "";
    private transient String securityName = "";
    private transient String securitySubType = "";
    private transient SecSubType secSubType;
    private transient String securityGroup = "";
    private transient String source = "";
    private transient String sourceId = "";
    private transient String ordCategory = "\u666e\u901a\u5355";
    private transient String unit = "";
    private transient String tradeName = "";
    private transient String market = "";
    private transient double donePercent = 0.0;
    private transient double yield;
    private transient String issueId = "";
    private transient String issueName = "";
    private static final String COMMON_ISSUE = "COMMON_ISSUE";
    private AccountId extAccntId = new AccountId();
    private AccountId subAccntId = new AccountId();
    private String productId;
    private LegMode legMode;
    boolean inactive;
    String opMarks;
    double cxlQty;
    String cxlDate;
    String cxlTime;
    String cxlUserId;
    String execDate;
    String cxlOpMarks;
    int cxlErrCode;
    String cxlErrInfo;
    double stampTx;
    Party counterparty;
    double commission = 0.0;
    private String portfolioName = "";
    private String positionEffect = "";
    private String tifName;
    private String ocFlag;
    private double avalQty;

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.ordDate == null ? 0 : this.ordDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)((Object)obj);
        if (this.orderId == null ? other.orderId != null : !this.orderId.equals(other.orderId)) {
            return false;
        }
        return !(this.ordDate == null ? other.ordDate != null : !this.ordDate.equals(other.ordDate));
    }

    public void update(Object obj) {
        if (obj instanceof Order) {
            Order s = (Order)((Object)Order.class.cast(obj));
            this.update(s);
        } else if (obj instanceof SingleOrder) {
            SingleOrder order = (SingleOrder)((Object)obj);
            this.update(order);
        }
    }

    public void update(SingleOrder order) {
        this.setInstrument(order.getInstrument());
        this.setSecurityId(order.getInstrument().getSecurityId());
        this.setSide(order.getSide());
        this.setPrice(order.getPrice());
        this.setOrderQty(order.getOrderQty());
        this.setCumQty(order.getCumQty());
        this.setLeavesQty(order.getLeavesQty());
        this.setOrdStatus(order.getOrdStatus());
        this.setOrdType(order.getOrdType());
        this.setSettlType(order.getSettlType());
        this.setOrderId(order.getOrderId());
        this.setOrdDate(order.getOrdDate());
        this.setOrdTime(order.getOrdTime());
        this.setCxlTime(order.getWthTime());
        this.setErrInfo(order.getErrInfo());
        this.setPositionEffect(order.getPositionEffect());
        this.setTraderId(order.getSelfParty().getTraderId());
        this.setUserId(order.getUserId());
        this.setUserName(order.getUserName());
        this.setExtOrderId(order.getExtOrderId());
        this.setSelfparty(order.getSelfParty());
        this.setPositionEffect(order.getPositionEffect());
        this.setOrdTypeDesc(order.getOrdTypeDesc());
        this.setSelected(order.isSelected());
        this.setMarket(order.getMarket());
        this.setInactive(order.isInactive());
        this.setRiskDetail(order.getRiskDetail());
        this.setTifName(this.setTifString(this.getTif()));
        this.setExecMode(order.getExecMode());
        this.setSource(order.getSource());
        this.setSourceId(order.getSourceId());
        this.setOrdCategory(order.getOrdCategory());
    }

    private void update(Order o) {
        this.setUserId(o.getUserId());
        this.setOrderId(o.getOrderId());
        this.setExtOrderId(o.getExtOrderId());
        this.setInstrument(o.getInstrument());
        this.setUnderlying(o.getUnderlying());
        this.setSecurityGroup(o.getSecurityGroup());
        this.setSide(o.getSide());
        if (o.getSide() != null) {
            this.setSideString(o.getSide().getValue());
        }
        this.setOrdType(o.getOrdType());
        this.setSettlType(o.getSettlType());
        this.setOrderQty(o.getOrderQty());
        this.setPrice(o.getPrice());
        this.setExecId(o.getExecId());
        this.setExecTime(o.getExecTime());
        this.setOrdStatus(o.getOrdStatus());
        if (o.getOrdStatus() != null) {
            this.setStatus(o.getOrdStatus().getDes());
        }
        this.setLastQty(o.getLastQty());
        this.setLastPx(o.getLastPx());
        this.setCumQty(o.getCumQty());
        this.setLeavesQty(o.getLeavesQty());
        this.setTotalValue(o.getTotalValue());
        this.setErrInfo(o.getErrInfo());
        this.setOrdDate(o.getOrdDate());
        this.setOrdTime(o.getOrdTime());
        this.setOrderAmount(o.getOrderAmount());
        this.setExecMode(o.getExecMode());
        this.setMatchType(o.getMatchType());
        this.setTraderId(o.getTraderId());
        this.setSelfparty(o.getSelfparty());
        this.setTraderId(o.getSelfparty() == null ? "" : o.getSelfparty().getTraderId());
        this.setWthErrInfo(o.getWthErrInfo());
        this.setUserName(o.getUserName());
        this.setSource(o.getSource());
        this.setSourceId(o.getSourceId());
        this.setOrdCategory(o.getOrdCategory());
        this.setExtCashAccntId(o.getExtCashAccntId());
        this.setAvgPx(o.getAvgPx());
        this.setObject(o.getObject());
        this.setClOrdId(o.getClOrdId());
        this.setParentId(o.getParentId());
        this.setCanCancel(o.isCanCancel());
        this.setInvestorId(o.getInvestorId());
        this.setInvestorSecId(o.getInvestorSecId());
        this.setWthQty(o.getWthQty());
        this.setWthTime(o.getWthTime());
        this.setRiskDetail(o.getRiskDetail());
        if (o.getYieldData() != null) {
            this.setYield(o.getYieldData().getYield());
        }
        this.setOrdTypeDesc(this.translateOrdType(this));
        this.setFrozenMargin(o.getFrozenMargin());
        this.setErrInfo(this.transferErrInfo(this));
        this.setNeeqErrInfo(o.getNeeqErrInfo());
        this.setOrdDateTime(o.getOrdDateTime());
        if (o.getInstrument() != null) {
            if (COMMON_ISSUE.equals(o.getInstrument().getMarketIndicator())) {
                this.setIssueId(o.getInstrument().getSecurityId());
                this.setIssueName(o.getInstrument().getSymbol());
                if (o.getUnderlying() != null) {
                    this.setSecurityId(o.getUnderlying().getSecurityId());
                    this.setSecurityName(o.getUnderlying().getSymbol());
                }
            } else {
                this.setSecurityId(o.getInstrument().getSecurityId());
                this.setSecurityName(o.getInstrument().getSymbol());
            }
        }
        this.setExtAccntId(o.getExtAccntId());
        this.setSubAccntId(o.getSubAccntId());
        this.setProductId(o.getProductId());
        this.setLegMode(o.getLegMode());
        this.setInactive(o.isInactive());
        this.setCxlDate(o.getCxlDate());
        this.setOpMarks(o.getOpMarks());
        this.setCxlQty(o.getCxlQty());
        this.setCxlDate(o.getCxlDate());
        this.setCxlTime(o.getCxlTime());
        this.setCxlUserId(o.getCxlUserId());
        this.setExecDate(o.getExecDate());
        this.setCxlOpMarks(o.getCxlOpMarks());
        this.setCxlErrCode(o.getCxlErrCode());
        this.setCxlErrInfo(o.getCxlErrInfo());
        this.setStampTx(o.getStampTx());
        this.setCounterparty(o.getCounterparty());
        this.setPortfolioName(o.getPortfolioName());
        this.setPositionEffect(o.getPositionEffect());
        this.setSelfparty(o.getSelfparty());
        if ("".equals(this.getExtCashAccntId()) && "".equals(this.getExtSecAccntId())) {
            this.setExtSecAccntId(o.getExtAccntId().getSecAccntId());
            this.setExtCashAccntId(o.getExtAccntId().getCashAccntId());
        }
        this.setSelected(o.isSelected());
        this.setTifName(this.setTifString(this.getTif()));
        this.setAvalQty(o.getOrderQty() - o.getCumQty() - o.getCxlQty());
    }

    protected String translateOrdType(Order order) {
        block40: {
            StringBuilder sb;
            block42: {
                block43: {
                    block41: {
                        if (order.getOrdType() == null) {
                            return "";
                        }
                        if ("50".equals(order.getOrdType().getValue())) {
                            StringBuilder sb2 = new StringBuilder("\u9650\u4ef7");
                            if ("SHSC".equals(order.getInstrument().getMarket()) || "SZSC".equals(order.getInstrument().getMarket())) {
                                switch (order.getMaxPriceLevels()) {
                                    case 2: {
                                        sb2.append("-\u9650\u4ef7\u76d8(\u96f6\u80a1)");
                                        break;
                                    }
                                    case 1: {
                                        sb2.append("-\u7ade\u4ef7\u9650\u4ef7\u76d8");
                                        break;
                                    }
                                    case 0: {
                                        sb2.append("-\u589e\u5f3a\u9650\u4ef7\u76d8");
                                        break;
                                    }
                                }
                            }
                            return sb2.toString();
                        }
                        if ("99".equals(order.getOrdType().getValue()) || "80".equals(order.getOrdType().getValue())) {
                            return "\u76d8\u540e\u56fa\u5b9a\u4ef7";
                        }
                        if (!"49".equals(order.getOrdType().getValue())) break block40;
                        sb = new StringBuilder("\u5e02\u4ef7");
                        if (!"XSHE".equals(order.getInstrument().getMarket())) break block41;
                        switch (order.getTif()) {
                            case 48: {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                if (order.getMaxPriceLevels() == 1) {
                                    sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                break block42;
                            }
                            case 51: {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("-\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                                    break;
                                }
                                if (order.getMaxPriceLevels() == 5) {
                                    sb.append("-\u4e94\u6863\u5373\u6210\u5269\u64a4");
                                    break;
                                }
                                break block42;
                            }
                            case 52: {
                                sb.append("-\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                                break;
                            }
                        }
                        break block42;
                    }
                    if (!"XSHG".equals(order.getInstrument().getMarket())) break block43;
                    switch (order.getTif()) {
                        case 48: {
                            if (order.getInstrument().getSecurityId().startsWith("688")) {
                                if (order.getMaxPriceLevels() == 0) {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                } else if (order.getMaxPriceLevels() == 1) {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                } else if (order.getMaxPriceLevels() == 5) {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                }
                                sb.append((double)Math.round(order.getPrice() * 100.0) / 100.0);
                                break;
                            }
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 1) {
                                sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (order.getMaxPriceLevels() == 5) {
                                sb.append("-\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7");
                                break;
                            }
                            break block42;
                        }
                        case 51: {
                            if (order.getInstrument().getSecurityId().startsWith("688")) {
                                sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4-\u4fdd\u62a4\u4ef7\u683c-");
                                sb.append((double)Math.round(order.getPrice() * 100.0) / 100.0);
                                break;
                            }
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                            break;
                        }
                    }
                    break block42;
                }
                if ("NEEQ".equals(order.getInstrument().getMarket())) {
                    switch (order.getTif()) {
                        case 48: {
                            if (order.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18");
                                break;
                            }
                            if (order.getMaxPriceLevels() != 1) break;
                            sb.append("-\u5bf9\u624b\u65b9\u6700\u4f18");
                            break;
                        }
                        case 51: {
                            sb.append("-\u6700\u4f18\u4e94\u6863\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                            break;
                        }
                        case 66: {
                            sb.append("-\u6700\u4f18\u4e94\u6863\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u8f6c\u9650\u4ef7\u7533\u62a5");
                            break;
                        }
                        case 52: {
                            sb.append("-\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                            break;
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public void setExtraFields() {
        if (this.getSelfparty() != null) {
            this.setTraderId(this.getSelfparty().getTraderId());
        }
        double unit = 1.0;
        if ("XcfeXBond".equals(this.getInstrument().getSecuritySubType())) {
            unit = 10000.0;
        } else if ("XcfeXRepo".equals(this.getInstrument().getSecuritySubType())) {
            unit = 1.0E8;
        }
        this.setOrderQty(this.getOrderQty() / unit);
        this.setLeavesQty(this.getLeavesQty() / unit);
        this.setCumQty(this.getCumQty() / unit);
        if (this.getInstrument() == null || !"XHKG".equals(this.getInstrument().getMarket()) && !"SGEX".equals(this.getInstrument().getMarket())) {
            if (this.getOrdTime() != null && this.getOrdTime().length() > 8) {
                this.setOrdTime(this.getOrdTime().substring(0, 8));
            } else {
                this.setOrdTime(this.getOrdTime());
            }
        }
        if (this.getExecMode() != null) {
            this.setSource(this.getExecMode().getEmName());
            this.setSourceId(String.valueOf(this.getExecMode().getEmId()));
            MxNode node = MxNodeFactory.create((String)"xbond_ord_type", (String)this.getExecMode().getEmType().strValue());
            this.setOrdCategory(node.getValue());
        }
        double per = 0.0;
        if (this.getCumQty() > 0.0 && this.getOrderQty() > 0.0) {
            per = this.getCumQty() * 100.0 / this.getOrderQty();
        }
        this.setDonePercent(per);
        if (this.getOrdStatus() != null && this.getOrdStatus().getValue() != null) {
            if ("XHKG".equals(this.getInstrument().getMarket())) {
                String ordStatus = this.getOrdStatus().getDes();
                if (OrdStatus.ORD_STATUS_DONE_FOR_DAY.equals(this.getOrdStatus())) {
                    ordStatus = this.getCumQty() > 0.0 ? "\u90e8\u6210\u90e8\u8fc7\u671f" : "\u5df2\u8fc7\u671f";
                }
                this.setStatus(ordStatus);
            }
            this.setCanCancel(CAN_CANCEL_STATUS.contains(this.getOrdStatus().getValue()));
        }
        this.setOrdTypeDesc(this.translateOrdType(this));
        if (this.getYieldData() != null) {
            this.setYield(this.getYieldData().getYield());
        }
        if (this.getInstrument() != null) {
            if (COMMON_ISSUE.equals(this.getInstrument().getMarketIndicator())) {
                this.setIssueId(this.getInstrument().getSecurityId());
                this.setIssueName(this.getInstrument().getSymbol());
                this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
                this.setSecurityGroup(this.getInstrument().getSecurityGroup());
                this.setSecuritySubType(this.getInstrument().getSecuritySubType());
                if (this.getUnderlying() != null) {
                    this.setSecurityId(this.getUnderlying().getSecurityId());
                    this.setSecurityName(this.getUnderlying().getSymbol());
                }
            } else {
                this.setSecurityId(this.getInstrument().getSecurityId());
                this.setSecurityName(this.getInstrument().getSymbol());
                this.setMarket(MarketUtils.getMarketNameById((String)this.getInstrument().getMarket()));
                this.setSecurityGroup(this.getInstrument().getSecurityGroup());
                this.setSecuritySubType(this.getInstrument().getSecuritySubType());
                this.setSecSubType(SecSubType.get(this.getInstrument().getSecuritySubType()));
            }
        }
        this.setNeeqErrInfo(this.transferErrInfo(this));
        this.setOrdDateTime(String.valueOf(this.getOrdDate()) + this.getOrdTime());
        this.setTifName(this.setTifString(this.getTif()));
        this.setOcFlag(this.transferOc(this.getPositionEffect()));
        this.setStatus(this.getOrdStatus().getDes());
    }

    public String setTifString(int tif) {
        if (tif == 48) {
            return "\u5f53\u65e5\u6709\u6548";
        }
        if (tif == 51) {
            return "\u7acb\u5373\u6210\u4ea4\u5269\u4f59\u64a4\u5355";
        }
        if (tif == 52) {
            return "\u5168\u90e8\u6210\u4ea4\u5426\u5219\u64a4\u5355";
        }
        return String.valueOf(tif);
    }

    public String transferErrInfo(Order en) {
        String errorInfo = "";
        if (!StringUtils.isEmpty((String)en.getErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u4e0b\u5355\u9519\u8bef\uff08" + en.getErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getCxlErrInfo())) {
            errorInfo = String.valueOf(errorInfo) + "\u64a4\u5355\u8be6\u60c5\uff08" + en.getCxlErrInfo() + "\uff09";
        }
        if (!StringUtils.isEmpty((String)en.getRiskDetail())) {
            errorInfo = String.valueOf(errorInfo) + "\u98ce\u63a7\u8be6\u60c5\uff08" + en.getRiskDetail() + "\uff09";
        }
        return errorInfo;
    }

    private String transferOc(String positionEffect) {
        if ("PE_CLOSE".equals(positionEffect)) {
            return "\u5e73\u4ed3";
        }
        if ("PE_OPEN".equals(positionEffect)) {
            return "\u5f00\u4ed3";
        }
        if ("PE_FIFO".equals(positionEffect)) {
            return "\u81ea\u52a8";
        }
        return null;
    }

    public double getYield() {
        return this.yield;
    }

    public void setYield(double yield) {
        this.yield = yield;
    }

    public YieldData getYieldData() {
        return this.yieldData;
    }

    public void setYieldData(YieldData yieldData) {
        this.yieldData = yieldData;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getWthErrInfo() {
        return this.wthErrInfo;
    }

    public void setWthErrInfo(String wthErrInfo) {
        this.wthErrInfo = wthErrInfo;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public Party getSelfparty() {
        return this.selfparty;
    }

    public void setSelfparty(Party selfParty) {
        this.selfparty = selfParty;
    }

    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getExtOrderId() {
        return this.extOrderId;
    }

    public void setExtOrderId(String extOrderId) {
        this.extOrderId = extOrderId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getExecId() {
        return this.execId;
    }

    public void setExecId(String execId) {
        this.execId = execId;
    }

    public String getExecTime() {
        return this.execTime;
    }

    public void setExecTime(String execTime) {
        this.execTime = execTime;
    }

    public double getLastQty() {
        return this.lastQty;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType ordType) {
        this.ordType = ordType;
    }

    public OrdStatus getOrdStatus() {
        return this.ordStatus;
    }

    public void setOrdStatus(OrdStatus ordStatus) {
        this.ordStatus = ordStatus;
    }

    public void setLastQty(double lastQty) {
        this.lastQty = lastQty;
    }

    public double getLastPx() {
        return this.lastPx;
    }

    public void setLastPx(double lastPx) {
        this.lastPx = lastPx;
    }

    public double getLeavesQty() {
        return this.leavesQty;
    }

    public void setLeavesQty(double leavesQty) {
        this.leavesQty = leavesQty;
    }

    public double getAvgPx() {
        return this.avgPx;
    }

    public void setAvgPx(double avgPx) {
        this.avgPx = avgPx;
    }

    public double getTotalValue() {
        return this.totalValue;
    }

    public void setTotalValue(double totalValue) {
        this.totalValue = totalValue;
    }

    public double getFrozenCommission() {
        return this.frozenCommission;
    }

    public void setFrozenCommission(double frozenCommission) {
        this.frozenCommission = frozenCommission;
    }

    public double getMargenTaken() {
        return this.margenTaken;
    }

    public void setMargenTaken(double margenTaken) {
        this.margenTaken = margenTaken;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getRiskDetail() {
        return this.riskDetail;
    }

    public void setRiskDetail(String riskDetail) {
        this.riskDetail = riskDetail;
    }

    public String getWthUserId() {
        return this.wthUserId;
    }

    public void setWthUserId(String wthUserId) {
        this.wthUserId = wthUserId;
    }

    public String getWthTime() {
        return this.wthTime;
    }

    public void setWthTime(String wthTime) {
        this.wthTime = wthTime;
    }

    public int getTif() {
        return this.tif;
    }

    public void setTif(int tif) {
        this.tif = tif;
    }

    public int getMaxPriceLevels() {
        return this.maxPriceLevels;
    }

    public void setMaxPriceLevels(int maxPriceLevels) {
        this.maxPriceLevels = maxPriceLevels;
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public double getTradeAmount() {
        return this.tradeAmount;
    }

    public void setTradeAmount(double tradeAmount) {
        this.tradeAmount = tradeAmount;
    }

    public SettlType getSettlType() {
        return this.settlType;
    }

    public void setSettlType(SettlType settlType) {
        this.settlType = settlType;
    }

    public String getTermToMaturity() {
        return this.termToMaturity;
    }

    public void setTermToMaturity(String termToMaturity) {
        this.termToMaturity = termToMaturity;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public String getTraderId() {
        return this.traderId;
    }

    public void setTraderId(String traderId) {
        this.traderId = traderId;
    }

    public String getClOrdId() {
        return this.clOrdId;
    }

    public void setClOrdId(String clOrdId) {
        this.clOrdId = clOrdId;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public String getSubSecAccntId() {
        return this.subSecAccntId;
    }

    public void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntId = subSecAccntId;
    }

    public Instrument getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(Instrument underlying) {
        this.underlying = underlying;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public String getSubCashAccntId() {
        return this.subCashAccntId;
    }

    public void setSubCashAccntId(String subCashAccntId) {
        this.subCashAccntId = subCashAccntId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public OrdStatus getPreOrdStatus() {
        return this.preOrdStatus;
    }

    public void setPreOrdStatus(OrdStatus preOrdStatus) {
        this.preOrdStatus = preOrdStatus;
    }

    public double getFilledAvgPrice() {
        return this.filledAvgPrice;
    }

    public void setFilledAvgPrice(double filledAvgPrice) {
        this.filledAvgPrice = filledAvgPrice;
    }

    public double getFrozenQty() {
        return this.frozenQty;
    }

    public void setFrozenQty(double frozenQty) {
        this.frozenQty = frozenQty;
    }

    public int getWthQty() {
        return this.wthQty;
    }

    public void setWthQty(int wthQty) {
        this.wthQty = wthQty;
    }

    public int getWthErrCode() {
        return this.wthErrCode;
    }

    public void setWthErrCode(int wthErrCode) {
        this.wthErrCode = wthErrCode;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public CcsOrder getObject() {
        return this.object;
    }

    public void setObject(CcsOrder object) {
        this.object = object;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public String transferErrInfo() {
        StringBuilder errorInfo = new StringBuilder();
        if (!StringUtils.isEmpty((String)this.getErrInfo())) {
            errorInfo.append("\uff08").append(this.getErrInfo()).append("\uff09");
        }
        if (!StringUtils.isEmpty((String)this.getWthErrInfo())) {
            errorInfo.append("\uff08").append(this.getWthErrInfo()).append("\uff09");
        }
        return errorInfo.toString();
    }

    public String getTradeName() {
        return this.tradeName;
    }

    public void setTradeName(String tradeName) {
        this.tradeName = tradeName;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public int getCanCancelFlag() {
        return this.canCancelFlag;
    }

    public void setCanCancelFlag(int canCancelFlag) {
        this.canCancelFlag = canCancelFlag;
    }

    public String getSecurityGroup() {
        return this.securityGroup;
    }

    public void setSecurityGroup(String securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getSecuritySubType() {
        return this.securitySubType;
    }

    public void setSecuritySubType(String securitySubType) {
        this.securitySubType = securitySubType;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public String getIssueName() {
        return this.issueName;
    }

    public void setIssueName(String issueName) {
        this.issueName = issueName;
    }

    public String getNeeqErrInfo() {
        return this.neeqErrInfo;
    }

    public void setNeeqErrInfo(String neeqErrInfo) {
        this.neeqErrInfo = neeqErrInfo;
    }

    public String getOrdDateTime() {
        return this.ordDateTime;
    }

    public void setOrdDateTime(String ordDateTime) {
        this.ordDateTime = ordDateTime;
    }

    public AccountId getExtAccntId() {
        return this.extAccntId;
    }

    public void setExtAccntId(AccountId extAccntId) {
        this.extAccntId = extAccntId;
    }

    public AccountId getSubAccntId() {
        return this.subAccntId;
    }

    public void setSubAccntId(AccountId subAccntId) {
        this.subAccntId = subAccntId;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public LegMode getLegMode() {
        return this.legMode;
    }

    public void setLegMode(LegMode legMode) {
        this.legMode = legMode;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public String getOpMarks() {
        return this.opMarks;
    }

    public void setOpMarks(String opMarks) {
        this.opMarks = opMarks;
    }

    public double getCxlQty() {
        return this.cxlQty;
    }

    public void setCxlQty(double cxlQty) {
        this.cxlQty = cxlQty;
    }

    public String getCxlDate() {
        return this.cxlDate;
    }

    public void setCxlDate(String cxlDate) {
        this.cxlDate = cxlDate;
    }

    public String getCxlTime() {
        return this.cxlTime;
    }

    public void setCxlTime(String cxlTime) {
        this.cxlTime = cxlTime;
    }

    public String getCxlUserId() {
        return this.cxlUserId;
    }

    public void setCxlUserId(String cxlUserId) {
        this.cxlUserId = cxlUserId;
    }

    public String getExecDate() {
        return this.execDate;
    }

    public void setExecDate(String execDate) {
        this.execDate = execDate;
    }

    public String getCxlOpMarks() {
        return this.cxlOpMarks;
    }

    public void setCxlOpMarks(String cxlOpMarks) {
        this.cxlOpMarks = cxlOpMarks;
    }

    public int getCxlErrCode() {
        return this.cxlErrCode;
    }

    public void setCxlErrCode(int cxlErrCode) {
        this.cxlErrCode = cxlErrCode;
    }

    public String getCxlErrInfo() {
        return this.cxlErrInfo;
    }

    public void setCxlErrInfo(String cxlErrInfo) {
        this.cxlErrInfo = cxlErrInfo;
    }

    public double getStampTx() {
        return this.stampTx;
    }

    public void setStampTx(double stampTx) {
        this.stampTx = stampTx;
    }

    public Party getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(Party counterparty) {
        this.counterparty = counterparty;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getSideString() {
        return this.sideString;
    }

    public void setSideString(String sideString) {
        this.sideString = sideString;
    }

    public String getOrdTypeDesc() {
        return this.ordTypeDesc;
    }

    public void setOrdTypeDesc(String ordTypeDesc) {
        this.ordTypeDesc = ordTypeDesc;
    }

    public double getOrderQty() {
        return this.orderQty;
    }

    public void setOrderQty(double orderQty) {
        this.orderQty = orderQty;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public double getCumQty() {
        return this.cumQty;
    }

    public void setCumQty(double cumQty) {
        this.cumQty = cumQty;
    }

    public double getFrozenMargin() {
        return this.frozenMargin;
    }

    public void setFrozenMargin(double frozenMargin) {
        this.frozenMargin = frozenMargin;
    }

    public String getOrdDate() {
        return this.ordDate;
    }

    public void setOrdDate(String ordDate) {
        this.ordDate = ordDate;
    }

    public String getOrdTime() {
        return this.ordTime;
    }

    public void setOrdTime(String ordTime) {
        this.ordTime = ordTime;
    }

    public double getOrderAmount() {
        return this.orderAmount;
    }

    public void setOrderAmount(double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public double getRealFee() {
        return this.realFee;
    }

    public void setRealFee(double realFee) {
        this.realFee = realFee;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double commission) {
        this.commission = commission;
    }

    public double getStampTax() {
        return this.stampTax;
    }

    public void setStampTax(double stampTax) {
        this.stampTax = stampTax;
    }

    public double getHandleFee() {
        return this.handleFee;
    }

    public void setHandleFee(double handleFee) {
        this.handleFee = handleFee;
    }

    public double getSecAdminFee() {
        return this.secAdminFee;
    }

    public void setSecAdminFee(double secAdminFee) {
        this.secAdminFee = secAdminFee;
    }

    public double getOtherFee() {
        return this.otherFee;
    }

    public void setOtherFee(double otherFee) {
        this.otherFee = otherFee;
    }

    public String getErrInfo() {
        return this.errInfo;
    }

    public void setErrInfo(String errInfo) {
        this.errInfo = errInfo;
    }

    public String getPortfolioId() {
        return this.portfolioId;
    }

    public void setPortfolioId(String portfolioId) {
        this.portfolioId = portfolioId;
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }

    public String getInvestorSecId() {
        return this.investorSecId;
    }

    public void setInvestorSecId(String investorSecId) {
        this.investorSecId = investorSecId;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public double getDonePercent() {
        return this.donePercent;
    }

    public void setDonePercent(double donePercent) {
        this.donePercent = donePercent;
    }

    public double getChgOwnerFee() {
        return this.chgOwnerFee;
    }

    public void setChgOwnerFee(double chgOwnerFee) {
        this.chgOwnerFee = chgOwnerFee;
    }

    public String getPortfolioName() {
        return this.portfolioName;
    }

    public void setPortfolioName(String portfolioName) {
        this.portfolioName = portfolioName;
    }

    public String getPositionEffect() {
        return this.positionEffect;
    }

    public void setPositionEffect(String positionEffect) {
        this.positionEffect = positionEffect;
    }

    public SecSubType getSecSubType() {
        return this.secSubType;
    }

    public void setSecSubType(SecSubType secSubType) {
        this.secSubType = secSubType;
    }

    public String getTifName() {
        return this.tifName;
    }

    public void setTifName(String tifName) {
        this.tifName = tifName;
    }

    public double getAvalQty() {
        return this.avalQty;
    }

    public void setAvalQty(double avalQty) {
        this.avalQty = avalQty;
    }

    public String getOcFlag() {
        return this.ocFlag;
    }

    public void setOcFlag(String ocFlag) {
        this.ocFlag = ocFlag;
    }

    public String getOrdCategory() {
        return this.ordCategory;
    }

    public void setOrdCategory(String ordCategory) {
        this.ordCategory = ordCategory;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}

