/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.query.marginxt.XtSingleOrder;
import cms.tmx.javafx.obj.MxSelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObSingleOrderMargin
extends MxSelObj {
    private String orderId = "";
    private StringProperty extOrderId = new SimpleStringProperty("");
    private Instrument instrument;
    private ObjectProperty<Side> side = new SimpleObjectProperty();
    private IntegerProperty orderQty = new SimpleIntegerProperty(0);
    private DoubleProperty price = new SimpleDoubleProperty(0.0);
    private double newPrice;
    private StringProperty status = new SimpleStringProperty("");
    private IntegerProperty cumQty = new SimpleIntegerProperty(0);
    private DoubleProperty avgPx = new SimpleDoubleProperty(0.0);
    private StringProperty ordDate = new SimpleStringProperty("");
    private StringProperty ordTime = new SimpleStringProperty("");
    private StringProperty errInfo = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private IntegerProperty wthQty = new SimpleIntegerProperty(0);
    private StringProperty parentId = new SimpleStringProperty("");
    private boolean canCancel = false;
    private boolean canCancelReplace = true;
    private StringProperty investorSecId = new SimpleStringProperty("");
    private String extCashAccntId;
    private String extSecAccntId;
    private OrdType ordType;
    private StringProperty ordTypeDesc = new SimpleStringProperty("");
    private StringProperty unit = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private StringProperty userName = new SimpleStringProperty("");
    private StringProperty reference = new SimpleStringProperty("");
    private DoubleProperty orderAmount = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenMargin = new SimpleDoubleProperty(0.0);
    private DoubleProperty donePercent = new SimpleDoubleProperty(0.0);
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty securityName = new SimpleStringProperty("");
    private StringProperty marketIndicator = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private StringProperty algoId = new SimpleStringProperty("");

    public ObSingleOrderMargin() {
        this.instrument = new Instrument();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.ordDate.get() == null ? 0 : ((String)this.ordDate.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObSingleOrderMargin other = (ObSingleOrderMargin)((Object)obj);
        if (this.orderId == null ? other.orderId != null : !this.orderId.equals(other.orderId)) {
            return false;
        }
        return !(this.ordDate.get() == null ? other.ordDate.get() != null : !((String)this.ordDate.get()).equals(other.ordDate.get()));
    }

    public void update(Object obj) {
        if (obj instanceof ObSingleOrderMargin) {
            ObSingleOrderMargin s = (ObSingleOrderMargin)((Object)ObSingleOrderMargin.class.cast(obj));
            this.update(s);
        } else if (obj instanceof SingleOrder) {
            SingleOrder s = (SingleOrder)((Object)SingleOrder.class.cast(obj));
            this.update(s);
        } else if (obj instanceof XtSingleOrder) {
            XtSingleOrder s = (XtSingleOrder)((Object)XtSingleOrder.class.cast(obj));
            this.update(s);
        }
    }

    private void update(ObSingleOrderMargin o) {
        this.setOrderId(o.getOrderId());
        this.setExtOrderId(o.getExtOrderId());
        this.setInstrument(o.getInstrument());
        this.setSide(o.getSide());
        this.setOrderQty(o.getOrderQty());
        this.setPrice(o.getPrice());
        this.setCumQty(o.getCumQty());
        this.setErrInfo(o.getErrInfo());
        this.setOrdDate(o.getOrdDate());
        this.setOrdTime(o.getOrdTime());
        this.setStatus(o.getStatus());
        this.setAvgPx(o.getAvgPx());
        this.setParentId(o.getParentId());
        this.setCanCancel(o.isCanCancel());
        this.setCanCancelReplace(o.isCanCancelReplace());
        this.setInvestorId(o.getInvestorId());
        this.setInvestorSecId(o.getInvestorSecId());
        this.setWthQty(o.getWthQty());
        this.setNewPrice(o.getNewPrice());
        this.setExtCashAccntId(o.getExtCashAccntId());
        this.setOrdType(o.getOrdType());
        this.setOrdTypeDesc(o.getOrdTypeDesc());
        this.setExtSecAccntId(o.getExtSecAccntId());
        this.setUnit(o.getUnit());
        this.setUserId(o.getUserId());
        this.setUserName(o.getUserName());
        this.setReference(o.getReference());
        this.setDonePercent(o.getDonePercent());
        this.setOrderAmount(o.getOrderAmount());
        this.setFrozenMargin(o.getFrozenMargin());
        this.setSecurityId(o.getSecurityId());
        this.setSecurityName(o.getSecurityName());
        this.setMarket(o.getMarket());
        this.setMarketIndicator(o.getMarketIndicator());
    }

    private void update(SingleOrder o) {
        this.setOrderId(o.getOrderId());
        this.setExtOrderId(o.getExtOrderId());
        this.setInstrument(o.getInstrument());
        this.setAlgoId(o.getAlgoId());
        this.setSide(o.getSide());
        this.setOrderQty((int)o.getOrderQty());
        this.setPrice((double)Math.round(o.getPrice() * 1000.0) / 1000.0);
        this.setStatus(o.getOrdStatus().getDes());
        this.setCumQty((int)o.getCumQty());
        this.setErrInfo(o.getErrInfo());
        this.setOrdDate(o.getOrdDate());
        this.setOrdTime(o.getOrdTime());
        this.setAvgPx((double)Math.round(o.getAvgPx() * 10000.0) / 10000.0);
        this.setParentId(o.getParentId());
        this.setCanCancel(o.isCanCancel());
        this.setInvestorId(o.getInvestorId());
        this.setInvestorSecId(o.getInvestorSecId());
        this.setWthQty(o.getWthQty());
        this.setNewPrice(o.getNewPrice());
        this.setExtCashAccntId(o.getExtCashAccntId());
        this.setOrdType(o.getOrdType());
        this.setOrdTypeDesc(this.translateOrdType(o));
        this.setExtSecAccntId(o.getExtSecAccntId());
        this.setDonePercent(o.getDonePercent());
        this.setUnit(o.getUnit());
        this.setUserId(o.getUserId());
        this.setReference(o.getReference());
        this.setOrderAmount((double)Math.round(o.getOrderAmount() * 1000.0) / 1000.0);
        this.setFrozenMargin((double)Math.round(o.getFrozenMargin() * 1000.0) / 1000.0);
        this.setSecurityId(o.getSecurityId());
        this.setSecurityName(o.getSecurityName());
        this.setMarket(o.getMarket());
        this.setMarketIndicator(o.getMarketIndicator());
        this.setUserName(o.getUserName());
    }

    private void update(XtSingleOrder o) {
        this.setOrderId(o.getOrderId());
        this.setExtOrderId(o.getExtOrderId());
        this.setInstrument(o.getInstrument());
        this.setSide(o.getSide());
        this.setOrderQty((int)o.getOrderQty());
        this.setPrice((double)Math.round(o.getPrice() * 1000.0) / 1000.0);
        if (o.getOrdStatus() != null) {
            this.setStatus(o.getOrdStatus().getDes());
        }
        this.setCumQty((int)o.getCumQty());
        this.setErrInfo(o.getErrInfo());
        this.setOrdDate(o.getOrdDate());
        this.setOrdTime(o.getOrdTime());
        this.setAvgPx((double)Math.round(o.getAvgPx() * 10000.0) / 10000.0);
        this.setCanCancel(o.isCanCancel());
        this.setInvestorId(o.getInvestorId());
        this.setInvestorSecId(o.getInvestorSecId());
        this.setWthQty(o.getWthQty());
        this.setNewPrice(o.getNewPrice());
        this.setExtCashAccntId(o.getExtCashAccntId());
        this.setOrdType(o.getOrdType());
        this.setOrdTypeDesc(this.translateOrdType(o));
        this.setExtSecAccntId(o.getExtSecAccntId());
        this.setDonePercent(o.getDonePercent());
        this.setUnit(o.getUnit());
        this.setUserId(o.getUserId());
        this.setReference(o.getReference());
        this.setOrderAmount((double)Math.round(o.getOrderAmount() * 1000.0) / 1000.0);
        this.setFrozenMargin((double)Math.round(o.getFrozenMargin() * 1000.0) / 1000.0);
        this.setSecurityId(o.getSecurityId());
        this.setSecurityName(o.getSecurityName());
        this.setMarket(o.getMarket());
        this.setMarketIndicator(o.getMarketIndicator());
        this.setUserName(o.getUserName());
    }

    private String translateOrdType(SingleOrder en) {
        block30: {
            StringBuilder sb;
            block32: {
                block31: {
                    if (en.getOrdType() == null) {
                        return "";
                    }
                    if ("50".equals(en.getOrdType().getValue())) {
                        return "\u9650\u4ef7";
                    }
                    if ("80".equals(en.getOrdType().getValue())) {
                        return "\u76d8\u540e\u56fa\u5b9a\u4ef7";
                    }
                    if (!"49".equals(en.getOrdType().getValue())) break block30;
                    sb = new StringBuilder("\u5e02\u4ef7-");
                    if (!"XSHE".equals(en.getInstrument().getMarket())) break block31;
                    switch (en.getTif()) {
                        case 48: {
                            if (en.getMaxPriceLevels() == 1) {
                                sb.append("\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (en.getMaxPriceLevels() == 0) {
                                sb.append("\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            break block32;
                        }
                        case 51: {
                            if (en.getMaxPriceLevels() == 0) {
                                sb.append("\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                                break;
                            }
                            if (en.getMaxPriceLevels() == 5) {
                                sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                                break;
                            }
                            break block32;
                        }
                        case 52: {
                            sb.append("\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                            break;
                        }
                    }
                    break block32;
                }
                if ("XSHG".equals(en.getInstrument().getMarket())) {
                    if (48 == en.getTif()) {
                        if (en.getInstrument().getSecurityId().startsWith("688")) {
                            switch (en.getMaxPriceLevels()) {
                                case 5: {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                                case 0: {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                                case 1: {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                            }
                            sb.append((double)Math.round(en.getPrice() * 100.0) / 100.0);
                        } else {
                            switch (en.getMaxPriceLevels()) {
                                case 5: {
                                    sb.append("\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7");
                                    break;
                                }
                                case 0: {
                                    sb.append("\u672c\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                case 1: {
                                    sb.append("\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                            }
                        }
                    } else if (51 == en.getTif() && 5 == en.getMaxPriceLevels()) {
                        if (en.getInstrument().getSecurityId().startsWith("688")) {
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4-\u4fdd\u62a4\u4ef7\u683c-");
                            sb.append((double)Math.round(en.getPrice() * 100.0) / 100.0);
                        } else {
                            sb.append("\u4e94\u6863\u5373\u6210\u5269\u64a4");
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    private String translateOrdType(XtSingleOrder en) {
        block30: {
            StringBuilder sb;
            block32: {
                block31: {
                    if (en.getOrdType() == null) {
                        return "";
                    }
                    if ("50".equals(en.getOrdType().getValue())) {
                        return "\u9650\u4ef7";
                    }
                    if ("80".equals(en.getOrdType().getValue())) {
                        return "\u76d8\u540e\u56fa\u5b9a\u4ef7";
                    }
                    if (!"49".equals(en.getOrdType().getValue())) break block30;
                    sb = new StringBuilder("\u5e02\u4ef7");
                    if (!"XSHE".equals(en.getInstrument().getMarket())) break block31;
                    switch (en.getTif()) {
                        case 48: {
                            if (en.getMaxPriceLevels() == 1) {
                                sb.append("-\u5bf9\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            if (en.getMaxPriceLevels() == 0) {
                                sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                break;
                            }
                            break block32;
                        }
                        case 51: {
                            if (en.getMaxPriceLevels() == 0) {
                                sb.append("-\u5373\u65f6\u6210\u4ea4\u5269\u4f59\u64a4\u9500");
                                break;
                            }
                            if (en.getMaxPriceLevels() == 5) {
                                sb.append("-\u4e94\u6863\u5373\u6210\u5269\u64a4");
                                break;
                            }
                            break block32;
                        }
                        case 52: {
                            sb.append("-\u5168\u989d\u6210\u4ea4\u6216\u64a4\u9500");
                            break;
                        }
                    }
                    break block32;
                }
                if ("XSHG".equals(en.getInstrument().getMarket())) {
                    if (48 == en.getTif()) {
                        if (en.getInstrument().getSecurityId().startsWith("688")) {
                            switch (en.getMaxPriceLevels()) {
                                case 5: {
                                    sb.append("-\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                                case 0: {
                                    sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                                case 1: {
                                    sb.append("-\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7-\u4fdd\u62a4\u4ef7\u683c-");
                                    break;
                                }
                            }
                            sb.append((double)Math.round(en.getPrice() * 100.0) / 100.0);
                        } else {
                            switch (en.getMaxPriceLevels()) {
                                case 5: {
                                    sb.append("-\u4e94\u6863\u5373\u6210\u8f6c\u9650\u4ef7");
                                    break;
                                }
                                case 0: {
                                    sb.append("-\u672c\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                                case 1: {
                                    sb.append("-\u5bf9\u624b\u65b9\u6700\u4f18\u4ef7");
                                    break;
                                }
                            }
                        }
                    } else if (51 == en.getTif() && 5 == en.getMaxPriceLevels()) {
                        if (en.getInstrument().getSecurityId().startsWith("688")) {
                            sb.append("-\u4e94\u6863\u5373\u6210\u5269\u64a4-\u4fdd\u62a4\u4ef7\u683c-");
                            sb.append((double)Math.round(en.getPrice() * 100.0) / 100.0);
                        } else {
                            sb.append("-\u4e94\u6863\u5373\u6210\u5269\u64a4");
                        }
                    }
                }
            }
            return sb.toString();
        }
        return "";
    }

    public final StringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public final String getExtOrderId() {
        return (String)this.extOrderIdProperty().get();
    }

    public final void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set((Object)extOrderId);
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public final Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    public final void setSide(Side side) {
        this.sideProperty().set((Object)side);
    }

    public final IntegerProperty orderQtyProperty() {
        return this.orderQty;
    }

    public final int getOrderQty() {
        return this.orderQtyProperty().get();
    }

    public final void setOrderQty(int orderQty) {
        this.orderQtyProperty().set(orderQty);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final IntegerProperty cumQtyProperty() {
        return this.cumQty;
    }

    public final int getCumQty() {
        return this.cumQtyProperty().get();
    }

    public final void setCumQty(int cumQty) {
        this.cumQtyProperty().set(cumQty);
    }

    public final DoubleProperty avgPxProperty() {
        return this.avgPx;
    }

    public final double getAvgPx() {
        return this.avgPxProperty().get();
    }

    public final void setAvgPx(double avgPx) {
        this.avgPxProperty().set(avgPx);
    }

    public final StringProperty ordDateProperty() {
        return this.ordDate;
    }

    public final String getOrdDate() {
        return (String)this.ordDateProperty().get();
    }

    public final void setOrdDate(String ordDate) {
        this.ordDateProperty().set((Object)ordDate);
    }

    public final StringProperty ordTimeProperty() {
        return this.ordTime;
    }

    public final String getOrdTime() {
        return (String)this.ordTimeProperty().get();
    }

    public final void setOrdTime(String ordTime) {
        this.ordTimeProperty().set((Object)ordTime);
    }

    public final StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public final String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public final void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final IntegerProperty wthQtyProperty() {
        return this.wthQty;
    }

    public final int getWthQty() {
        return this.wthQtyProperty().get();
    }

    public final void setWthQty(int wthQty) {
        this.wthQtyProperty().set(wthQty);
    }

    public final StringProperty parentIdProperty() {
        return this.parentId;
    }

    public final String getParentId() {
        return (String)this.parentIdProperty().get();
    }

    public final void setParentId(String parentId) {
        this.parentIdProperty().set((Object)parentId);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public double getNewPrice() {
        return this.newPrice;
    }

    public void setNewPrice(double newPrice) {
        this.newPrice = newPrice;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public String getExtCashAccntId() {
        return this.extCashAccntId;
    }

    public void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntId = extCashAccntId;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType ordType) {
        this.ordType = ordType;
    }

    public String getExtSecAccntId() {
        return this.extSecAccntId;
    }

    public void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntId = extSecAccntId;
    }

    public final StringProperty ordTypeDescProperty() {
        return this.ordTypeDesc;
    }

    public final String getOrdTypeDesc() {
        return (String)this.ordTypeDescProperty().get();
    }

    public final void setOrdTypeDesc(String ordTypeDesc) {
        this.ordTypeDescProperty().set((Object)ordTypeDesc);
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final StringProperty userNameProperty() {
        return this.userName;
    }

    public final String getUserName() {
        return (String)this.userNameProperty().get();
    }

    public final void setUserName(String userName) {
        this.userNameProperty().set((Object)userName);
    }

    public final StringProperty referenceProperty() {
        return this.reference;
    }

    public final String getReference() {
        return (String)this.referenceProperty().get();
    }

    public final void setReference(String reference) {
        this.referenceProperty().set((Object)reference);
    }

    public final DoubleProperty orderAmountProperty() {
        return this.orderAmount;
    }

    public final double getOrderAmount() {
        return this.orderAmountProperty().get();
    }

    public final void setOrderAmount(double orderAmount) {
        this.orderAmountProperty().set(orderAmount);
    }

    public final DoubleProperty donePercentProperty() {
        return this.donePercent;
    }

    public final double getDonePercent() {
        return this.donePercentProperty().get();
    }

    public final void setDonePercent(double donePercent) {
        this.donePercentProperty().set(donePercent);
    }

    public final DoubleProperty frozenMarginProperty() {
        return this.frozenMargin;
    }

    public final double getFrozenMargin() {
        return this.frozenMarginProperty().get();
    }

    public final void setFrozenMargin(double frozenMargin) {
        this.frozenMarginProperty().set(frozenMargin);
    }

    public final StringProperty statusProperty() {
        return this.status;
    }

    public final String getStatus() {
        return (String)this.statusProperty().get();
    }

    public final void setStatus(String status) {
        this.statusProperty().set((Object)status);
    }

    public boolean isCanCancelReplace() {
        return this.canCancelReplace;
    }

    public void setCanCancelReplace(boolean canCancelReplace) {
        this.canCancelReplace = canCancelReplace;
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public final StringProperty marketIndicatorProperty() {
        return this.marketIndicator;
    }

    public final String getMarketIndicator() {
        return (String)this.marketIndicatorProperty().get();
    }

    public final void setMarketIndicator(String marketIndicator) {
        this.marketIndicatorProperty().set((Object)marketIndicator);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty algoIdProperty() {
        return this.algoId;
    }

    public final String getAlgoId() {
        return (String)this.algoIdProperty().get();
    }

    public final void setAlgoId(String algoId) {
        this.algoIdProperty().set((Object)algoId);
    }
}

