/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.ObInstrument;
import cms.tmx.http.api.strategy.dto.ObPosAccnt;
import cms.tmx.http.api.strategy.dto.ObPosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.statement.api.TransferPosition;
import cms.tmx.javafx.obj.MxDirtySelObj;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObPositionMargin
extends MxDirtySelObj {
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty inverstorSecId = new SimpleStringProperty("");
    private ObPosAccnt posAccnt;
    private ObInstrument instrument;
    private ObPosStatistic posStatistic;
    private String trdDate = "";
    private DoubleProperty secBalance = new SimpleDoubleProperty(0.0);
    private DoubleProperty secAvail = new SimpleDoubleProperty(0.0);
    private DoubleProperty marketValue = new SimpleDoubleProperty(0.0);
    private StringProperty unit = new SimpleStringProperty("");
    private DoubleProperty secTransfer = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyIn = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellOut = new SimpleDoubleProperty(0.0);

    public ObPositionMargin() {
        this.posAccnt = new ObPosAccnt();
        this.instrument = new ObInstrument();
        this.posStatistic = new ObPosStatistic();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.instrument.getSecId() == null ? 0 : this.instrument.getSecId().hashCode());
        result = 31 * result + (this.instrument.getMarket() == null ? 0 : this.instrument.getMarket().getRaw().hashCode());
        result = 31 * result + (this.instrument.getSecType() == null ? 0 : this.instrument.getSecType().hashCode());
        result = 31 * result + (this.posAccnt.getSecAccntId() == null ? 0 : this.posAccnt.getSecAccntId().hashCode());
        result = 31 * result + (this.inverstorSecId.get() == null ? 0 : ((String)this.inverstorSecId.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObPositionMargin other = (ObPositionMargin)((Object)obj);
        if (this.instrument.getSecId() == null ? other.getInstrument().getSecId() != null : !this.instrument.getSecId().equals(other.getInstrument().getSecId())) {
            return false;
        }
        if (this.instrument.getMarket() == null ? other.getInstrument().getMarket() != null : !this.instrument.getMarket().getRaw().equals(other.getInstrument().getMarket().getRaw())) {
            return false;
        }
        if (this.instrument.getSecType() == null ? other.getInstrument().getSecType() != null : !this.instrument.getSecType().equals(other.getInstrument().getSecType())) {
            return false;
        }
        if (this.posAccnt.getSecAccntId() == null ? other.getPosAccnt().getSecAccntId() != null : !this.posAccnt.getSecAccntId().equals(other.getPosAccnt().getSecAccntId())) {
            return false;
        }
        return !(this.inverstorSecId.get() == null ? other.inverstorSecId.get() != null : !((String)this.inverstorSecId.get()).equals(other.inverstorSecId.get()));
    }

    public void update(Object obj) {
        if (obj instanceof ObPositionMargin) {
            ObPositionMargin s = (ObPositionMargin)((Object)ObPositionMargin.class.cast(obj));
            this.update(s);
        } else if (obj instanceof Position) {
            Position s = (Position)((Object)Position.class.cast(obj));
            this.update(s);
        } else if (obj instanceof XtPosition) {
            XtPosition s = (XtPosition)((Object)XtPosition.class.cast(obj));
            this.update(s);
        } else if (obj instanceof TransferPosition) {
            TransferPosition s = (TransferPosition)TransferPosition.class.cast(obj);
            this.update(s);
        }
    }

    private void update(TransferPosition p) {
        this.setInvestorId(p.getInvertorId());
        this.setInverstorSecId(p.getInvestorSecId());
        this.getInstrument().setSecId(p.getSecCode());
        this.getInstrument().getMarket().setRaw(p.getMarket());
        this.setSecAvail(p.getTransferAvailable());
    }

    private void update(ObPositionMargin p) {
        this.setSecBalance(p.getSecBalance());
        this.setSecAvail(p.getSecAvail());
        this.posAccnt.update((Object)p.getPosAccnt());
        this.instrument.update((Object)p.getInstrument());
        this.posStatistic.update((Object)p.getPosStatistic());
        this.setInvestorId(p.getInvestorId());
        this.setInverstorSecId(p.getInverstorSecId());
        this.setTrdDate(p.getTrdDate());
        this.setUnit(p.getUnit());
        this.setMarketValue(p.getMarketValue());
        this.setBuyIn(p.getBuyIn());
        this.setSellOut(p.getSellOut());
        this.setSecTransfer(this.getSecTransfer() > 0.0 ? this.getSecTransfer() : p.getSecTransfer());
    }

    private void update(Position p) {
        this.setSecBalance((double)Math.round(p.getSecBalance() * 1000.0) / 1000.0);
        this.setSecAvail((double)Math.round(p.getSecAvail() * 1000.0) / 1000.0);
        this.setSecTransfer(this.getSecAvail());
        this.posAccnt.update((Object)p.getPosAccnt());
        this.instrument.update((Object)p.getInstrument());
        this.posStatistic.update((Object)p.getPosStatistic());
        this.setInvestorId(p.getInvestorId());
        this.setInverstorSecId(p.getInverstorSecId());
        this.setTrdDate(p.getTrdDate());
    }

    private void update(XtPosition p) {
        this.setSecBalance(Math.round(p.getBalance()));
        this.setSecAvail(Math.round(p.getAvailable()));
        this.setMarketValue((double)Math.round(p.getMarketValue() * 1000.0) / 1000.0);
        this.setBuyIn(Math.round(p.getBuyIn()));
        this.setSellOut(Math.round(p.getSellOut()));
        this.instrument.update((Object)p.getInstrument());
        this.setInvestorId(p.getInvestorId());
        this.setInverstorSecId(p.getInvestorSecurityId());
        this.setTrdDate(p.getTradingDay());
        this.setSecTransfer((double)Math.round((p.getBalance() - p.getTransOutQty()) * 1000.0) / 1000.0);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty inverstorSecIdProperty() {
        return this.inverstorSecId;
    }

    public final String getInverstorSecId() {
        return (String)this.inverstorSecIdProperty().get();
    }

    public final void setInverstorSecId(String inverstorSecId) {
        this.inverstorSecIdProperty().set((Object)inverstorSecId);
    }

    public final DoubleProperty secBalanceProperty() {
        return this.secBalance;
    }

    public final double getSecBalance() {
        return this.secBalanceProperty().get();
    }

    public final void setSecBalance(double secBalance) {
        this.secBalanceProperty().set(secBalance);
    }

    public final DoubleProperty secAvailProperty() {
        return this.secAvail;
    }

    public final double getSecAvail() {
        return this.secAvailProperty().get();
    }

    public final void setSecAvail(double secAvail) {
        this.secAvailProperty().set(secAvail);
    }

    public ObPosAccnt getPosAccnt() {
        return this.posAccnt;
    }

    public void setPosAccnt(ObPosAccnt posAccnt) {
        this.posAccnt = posAccnt;
    }

    public ObInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(ObInstrument instrument) {
        this.instrument = instrument;
    }

    public ObPosStatistic getPosStatistic() {
        return this.posStatistic;
    }

    public void setPosStatistic(ObPosStatistic posStatistic) {
        this.posStatistic = posStatistic;
    }

    public String getTrdDate() {
        return this.trdDate;
    }

    public void setTrdDate(String trdDate) {
        this.trdDate = trdDate;
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final DoubleProperty marketValueProperty() {
        return this.marketValue;
    }

    public final double getMarketValue() {
        return this.marketValueProperty().get();
    }

    public final void setMarketValue(double marketValue) {
        this.marketValueProperty().set(marketValue);
    }

    public final DoubleProperty secTransferProperty() {
        return this.secTransfer;
    }

    public final double getSecTransfer() {
        return this.secTransferProperty().get();
    }

    public final void setSecTransfer(double secTransfer) {
        this.secTransferProperty().set(secTransfer);
    }

    public final DoubleProperty buyInProperty() {
        return this.buyIn;
    }

    public final double getBuyIn() {
        return this.buyInProperty().get();
    }

    public final void setBuyIn(double buyIn) {
        this.buyInProperty().set(buyIn);
    }

    public final DoubleProperty sellOutProperty() {
        return this.sellOut;
    }

    public final double getSellOut() {
        return this.sellOutProperty().get();
    }

    public final void setSellOut(double sellOut) {
        this.sellOutProperty().set(sellOut);
    }
}

