/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.extra.PositionSummaryExtra;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.PosAccnt;
import cms.tmx.http.api.strategy.dto.PosExtra;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.PositionNew;
import cms.tmx.http.api.strategy.dto.PositionQty;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObPosition
extends MxDirtyObj {
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty investorName = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private AccntType accntType;
    private PosAccnt posAccnt;
    private Instrument instrument;
    private List<PositionQty> posQty;
    private PosStatistic posStatistic;
    private PosExtra posExtra;
    private StringProperty trdDate = new SimpleStringProperty("");
    private long updateTime;
    private PositionSummaryExtra object;
    private DoubleProperty sodQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty intraDayQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty frozenQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty secBalance = new SimpleDoubleProperty(0.0);
    private DoubleProperty secAvail = new SimpleDoubleProperty(0.0);
    private DoubleProperty secWithDraw = new SimpleDoubleProperty(0.0);
    private DoubleProperty cashBalance = new SimpleDoubleProperty(0.0);
    private DoubleProperty cashAvail = new SimpleDoubleProperty(0.0);
    private DoubleProperty cashWithDraw = new SimpleDoubleProperty(0.0);
    private DoubleProperty marginQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty receivable = new SimpleDoubleProperty(0.0);
    private DoubleProperty payable = new SimpleDoubleProperty(0.0);
    private StringProperty secAccntId = new SimpleStringProperty("");
    private StringProperty cashAccntId = new SimpleStringProperty("");
    private StringProperty securityId = new SimpleStringProperty("");
    private String secType = "";
    private StringProperty securityName = new SimpleStringProperty("");
    private ObjectProperty<SecSubType> secSubType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private StringProperty unit = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private StringProperty totalStockPercent = new SimpleStringProperty("");
    private DoubleProperty cost = new SimpleDoubleProperty(0.0);
    private DoubleProperty holdCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty marketValue = new SimpleDoubleProperty(0.0);
    private DoubleProperty capitalCNY = new SimpleDoubleProperty(0.0);
    private DoubleProperty net = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyCost = new SimpleDoubleProperty(0.0);
    private DoubleProperty yield = new SimpleDoubleProperty(0.0);
    private DoubleProperty floatPnl = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalProfit = new SimpleDoubleProperty(0.0);
    private DoubleProperty todayRealizedPl = new SimpleDoubleProperty(0.0);
    private DoubleProperty realPnl = new SimpleDoubleProperty(0.0);
    private DoubleProperty nowPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty closePrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty percent = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyInQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellOutQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty buyInAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty sellOutAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty cashDividend = new SimpleDoubleProperty(0.0);
    private DoubleProperty posDividend = new SimpleDoubleProperty(0.0);
    private StringProperty portGrpName = new SimpleStringProperty("");
    private DoubleProperty buyCostAmt = new SimpleDoubleProperty(0.0);
    private DoubleProperty rate = new SimpleDoubleProperty();
    private StringProperty type = new SimpleStringProperty("");
    private StringProperty netValueDate = new SimpleStringProperty("");
    private DoubleProperty fee = new SimpleDoubleProperty(0.0);
    private DoubleProperty fundSize = new SimpleDoubleProperty(0.0);
    private DoubleProperty concentration = new SimpleDoubleProperty(0.0);
    private double openPrice;
    private int status = 0;
    private String exMarket;
    private double hkRate;
    private String assetGroupId;
    private StringProperty side = new SimpleStringProperty("");
    private String direction;

    public ObPosition() {
        this.setMarket(MxNodeFactory.create((String)"market_code"));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.securityId.get() == null ? 0 : ((String)this.securityId.get()).hashCode());
        result = 31 * result + (((MxNode)this.market.get()).getRaw() == null ? 0 : ((MxNode)this.market.get()).getRaw().hashCode());
        result = 31 * result + (this.secType == null ? 0 : this.secType.hashCode());
        result = 31 * result + (this.investorId.get() == null ? 0 : ((String)this.investorId.get()).hashCode());
        result = 31 * result + (this.investorSecId.get() == null ? 0 : ((String)this.investorSecId.get()).hashCode());
        result = 31 * result + (this.trdDate.get() == null ? 0 : ((String)this.trdDate.get()).hashCode());
        result = 31 * result + (this.portfolioId.get() == null ? 0 : ((String)this.portfolioId.get()).hashCode());
        result = 31 * result + (this.secSubType.get() == null ? 0 : ((SecSubType)((Object)this.secSubType.get())).hashCode());
        result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
        result = 31 * result + this.status;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObPosition other = (ObPosition)((Object)obj);
        if (this.securityId.get() == null ? other.securityId.get() != null : !((String)this.securityId.get()).equals(other.securityId.get())) {
            return false;
        }
        if (((MxNode)this.market.get()).getRaw() == null ? ((MxNode)other.market.get()).getRaw() != null : !((MxNode)this.market.get()).getRaw().equals(((MxNode)other.market.get()).getRaw())) {
            return false;
        }
        if (this.secType == null ? other.secType != null : !this.secType.equals(other.secType)) {
            return false;
        }
        if (this.investorId.get() == null ? other.investorId.get() != null : !((String)this.investorId.get()).equals(other.investorId.get())) {
            return false;
        }
        if (this.investorSecId.get() == null ? other.investorSecId.get() != null : !((String)this.investorSecId.get()).equals(other.investorSecId.get())) {
            return false;
        }
        if (this.trdDate.get() == null ? other.trdDate.get() != null : !((String)this.trdDate.get()).equals(other.trdDate.get())) {
            return false;
        }
        if (this.portfolioId.get() == null ? other.portfolioId.get() != null : !((String)this.portfolioId.get()).equals(other.portfolioId.get())) {
            return false;
        }
        if (this.secSubType.get() == null ? other.secSubType.get() != null : !((SecSubType)((Object)this.secSubType.get())).equals(other.secSubType.get())) {
            return false;
        }
        if (this.direction == null ? other.direction != null : !this.direction.equals(other.direction)) {
            return false;
        }
        return this.status == other.status;
    }

    public String unique() {
        return String.valueOf(this.getSecAccntId()) + this.getSecurityId() + this.getStatus();
    }

    public void update(Object obj) {
        if (obj instanceof ObPosition) {
            ObPosition s = (ObPosition)((Object)ObPosition.class.cast(obj));
            this.update(s);
        } else if (obj instanceof Position) {
            Position s = (Position)((Object)Position.class.cast(obj));
            this.update(s);
        } else if (obj instanceof PositionNew) {
            PositionNew s = (PositionNew)((Object)PositionNew.class.cast(obj));
            this.update(s);
        } else if (obj instanceof Positions) {
            Positions s = (Positions)Positions.class.cast(obj);
            this.update(s);
        }
    }

    private void update(Positions p) {
        this.setSecBalance(p.getPosStatistic().get(0).getBalance());
        this.setSecAvail(p.getPosStatistic().get(0).getAvailable());
        this.setSecurityId(p.getInstrument().getSecurityId());
    }

    private void update(PositionNew p) {
        this.setSodQty(p.getPreBalance());
        this.setSecAvail(p.getAvail());
        this.setSecBalance(p.getBalance());
        this.setFrozenQty(p.getFrozen());
        this.setInvestorId(p.getInvestorId());
        this.setInvestorSecId(p.getInvestorSecId());
        this.setSecAccntId(p.getSecAccntId());
        this.setCashAccntId(p.getAccntId());
        this.setBuyInQty(p.getBuyIn());
        this.setSellOutQty(p.getSellOut());
        this.setBuyInAmt(p.getBuyInNodeal());
        this.setSellOutAmt(p.getSellOutFrozen());
        this.setCashDividend(p.getCashDividend());
        this.setPosDividend(p.getPosDividend());
        this.setNowPrice((double)Math.round(p.getLastPx() * 10000.0) / 10000.0);
        this.setClosePrice((double)Math.round(p.getLastPx() * 10000.0) / 10000.0);
        this.setInstrument(p.getInstrument());
        this.setSecurityId(p.getInstrument().getSecurityId());
        this.setSecurityName(p.getInstrument().getSymbol());
        this.setSecType(p.getInstrument().getSecurityType() == null ? "" : p.getInstrument().getSecurityType());
        this.setSecSubType(p.getInstrument().getSecuritySubType() == null ? SecSubType.UNDEFINED : SecSubType.get(p.getInstrument().getSecuritySubType()));
        this.getMarket().setRaw(p.getInstrument().getMarket());
        this.setExMarket(this.getMarket().getValue());
        this.setStatus(p.getStatus());
        this.setCost((double)Math.round(p.getCost() * 100000.0) / 100000.0);
        this.setHoldCostAmt((double)Math.round(p.getHoldCostAmt() * 10000.0) / 10000.0);
        this.setBuyCost((double)Math.round(p.getBuyCost() * 100000.0) / 100000.0);
        this.setBuyCostAmt(p.getBuyCostAmt());
        this.setTrdDate(p.getTradingDay());
        this.setMarketValue(p.getMarketValue());
        this.setCapitalCNY(p.getMarketValue());
        this.setRealPnl(p.getRealizedPnl());
        this.setTodayRealizedPl((double)Math.round((p.getRealizedPnl() - p.getPreRealizedPnl()) * 1000.0) / 1000.0);
        if ("STD_BOND".equals(this.getSecType())) {
            this.setFloatPnl(0.0);
            this.setTotalProfit(0.0);
        } else {
            this.setFloatPnl((double)Math.round((this.getMarketValue() - this.getBuyCostAmt()) * 1000.0) / 1000.0);
            this.setTotalProfit(this.getFloatPnl() + this.getRealPnl());
        }
        this.setPortfolioId(p.getPortfolioId());
        this.setPortfolioName(p.getPortfolioName());
        this.setYield((double)Math.round(p.getYield() * 10000.0) / 100.0);
        this.setFee(p.getFee());
        this.setNetValueDate(p.getNetValueDate());
        this.setFundSize(p.getFundSize());
        this.setConcentration((double)Math.round(p.getConcentration() * 10000.0) / 100.0);
        this.setPortGrpName(p.getAssetGroupName());
        this.setOpenPrice(p.getPreClosePx());
        this.setAssetGroupId(p.getAssetGroupId());
    }

    private void update(Position p) {
        this.setUnit(p.getUnit());
        this.setSodQty(p.getSodQty());
        this.setIntraDayQty(p.getIntraDayQty());
        if (0.0 != p.getSecBalance() || 0.0 != p.getSecAvail()) {
            this.setSecAvail(p.getSecAvail());
            this.setSecBalance(p.getSecBalance());
        } else {
            this.setSecAvail(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getAvailable());
            this.setSecBalance(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getBalance());
        }
        this.setFrozenQty(p.getFrozenQty());
        this.setCashBalance(p.getCashBalance());
        this.setCashAvail(p.getCashAvail());
        this.setMarginQty(p.getMarginQty());
        this.setReceivable(p.getReceivable());
        this.setPayable(p.getPayable());
        this.setInvestorId(p.getInvestorId());
        this.setInvestorSecId(p.getInverstorSecId());
        this.setSecAccntId(p.getSecAccntId());
        this.setCashAccntId(p.getCashAccntId());
        this.setRealPnl(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getRealPnl());
        this.setBuyInQty(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getBuyInQty());
        this.setSellOutQty(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getSellOutQty());
        this.setBuyInAmt(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getBuyInAmt());
        this.setSellOutAmt(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getSellOutAmt());
        this.setCashDividend(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getCashDividend());
        this.setMarketValue(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getMarketValue());
        this.setNowPrice((double)Math.round(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getLastPx() * 10000.0) / 10000.0);
        this.setClosePrice((double)Math.round(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getLastPx() * 10000.0) / 10000.0);
        this.setInstrument(p.getInstrument());
        this.setSecurityId(p.getSecurityId());
        this.setSecurityName(p.getSecurityName());
        this.setSecType(p.getInstrument().getSecurityType() == null ? "" : p.getInstrument().getSecurityType());
        this.getMarket().setRaw(p.getInstrument().getMarket());
        this.setExMarket(this.getMarket().getValue());
        this.setStatus(p.getStatus());
        this.setCost((double)Math.round(p.getCost() * 10000.0) / 10000.0);
        this.setHoldCostAmt((double)Math.round(p.getHoldCostAmt() * 1000.0) / 1000.0);
        this.setBuyCost((double)Math.round(p.getBuyCost() * 1000.0) / 1000.0);
        this.setTodayRealizedPl(p.getTodayRealizedPl());
        this.setTrdDate(p.getTrdDate());
        this.setBuyCostAmt(p.getPosStatistic() == null ? 0.0 : p.getPosStatistic().getBuyCostAmt());
        if ("STD_BOND".equals(this.getSecType())) {
            this.setFloatPnl(0.0);
            this.setTotalProfit(0.0);
        } else {
            this.setFloatPnl((double)Math.round((this.getMarketValue() - this.getBuyCostAmt()) * 1000.0) / 1000.0);
            this.setTotalProfit(this.getFloatPnl() + this.getRealPnl());
        }
        if (p.getPosExtra() != null) {
            this.setPortfolioId(p.getPosExtra().getPortfolioId());
            this.setPortfolioName(p.getPosExtra().getPortfolioName());
        }
        this.setDirection(p.getPosStatistic().getDirection());
    }

    public void updateProfit() {
        if ("STD_BOND".equals(this.getSecType())) {
            this.setFloatPnl(0.0);
            this.setTotalProfit(0.0);
        } else {
            this.setFloatPnl((double)Math.round((this.getMarketValue() - this.getBuyCostAmt()) * 1000.0) / 1000.0);
            this.setTotalProfit(this.getFloatPnl() + this.getRealPnl());
        }
    }

    private void update(ObPosition p) {
        this.setUnit(p.getUnit());
        this.setSodQty(p.getSodQty());
        this.setIntraDayQty(p.getIntraDayQty());
        this.setFrozenQty(p.getFrozenQty());
        this.setSecBalance(p.getSecBalance());
        this.setSecAvail(p.getSecAvail());
        this.setCashBalance(p.getCashBalance());
        this.setCashAvail(p.getCashAvail());
        this.setMarginQty(p.getMarginQty());
        this.setReceivable(p.getReceivable());
        this.setPayable(p.getPayable());
        this.setInvestorId(p.getInvestorId());
        this.setInvestorSecId(p.getInvestorSecId());
        this.setSecurityId(p.getSecurityId());
        this.setMarket(p.getMarket());
        this.setSecAccntId(p.getSecAccntId());
        this.setCashAccntId(p.getCashAccntId());
        this.setTotalStockPercent(p.getTotalStockPercent());
        this.setBuyInQty(p.getBuyInQty());
        this.setSellOutQty(p.getSellOutQty());
        this.setBuyInAmt(p.getBuyInAmt());
        this.setSellOutAmt(p.getSellOutAmt());
        this.setRealPnl(p.getRealPnl());
        this.setFloatPnl(p.getFloatPnl());
        this.setTotalProfit(p.getTotalProfit());
        this.setCashDividend(p.getCashDividend());
        this.setPosDividend(p.getPosDividend());
        this.setMarketValue(p.getMarketValue());
        this.setCapitalCNY(p.getCapitalCNY());
        this.setNowPrice(p.getNowPrice());
        this.setClosePrice(p.getClosePrice());
        this.setSecurityId(p.getSecurityId());
        this.setSecurityName(p.getSecurityName());
        this.setSecType(p.getSecType());
        this.setMarket(p.getMarket());
        this.setExMarket(p.getExMarket());
        this.setStatus(p.getStatus());
        this.setCost(p.getCost());
        this.setHoldCostAmt(p.getHoldCostAmt());
        this.setBuyCost(p.getBuyCost());
        this.setTodayRealizedPl(p.getTodayRealizedPl());
        this.setTrdDate(p.getTrdDate());
        this.setBuyCostAmt(p.getBuyCostAmt());
        this.setPortfolioId(p.getPortfolioId());
        this.setPortfolioName(p.getPortfolioName());
        this.setNet(p.getNet());
        this.setPortGrpName(p.getPortGrpName());
        this.setAssetGroupId(p.getAssetGroupId());
        this.setOpenPrice(p.getOpenPrice());
        this.setRate(p.getRate());
        this.setType(p.getType());
        this.setSecSubType(p.getSecSubType());
        this.setYield(p.getYield());
        this.setFee(p.getFee());
        this.setNetValueDate(p.getNetValueDate());
        this.setFundSize(p.getFundSize());
        this.setConcentration(p.getConcentration());
        this.setHkRate(p.getHkRate());
        this.setDirection(p.getDirection());
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public final StringProperty trdDateProperty() {
        return this.trdDate;
    }

    public final String getTrdDate() {
        return (String)this.trdDateProperty().get();
    }

    public final void setTrdDate(String trdDate) {
        this.trdDateProperty().set((Object)trdDate);
    }

    public final DoubleProperty sodQtyProperty() {
        return this.sodQty;
    }

    public final double getSodQty() {
        return this.sodQtyProperty().get();
    }

    public final void setSodQty(double sodQty) {
        this.sodQtyProperty().set(sodQty);
    }

    public final DoubleProperty intraDayQtyProperty() {
        return this.intraDayQty;
    }

    public final double getIntraDayQty() {
        return this.intraDayQtyProperty().get();
    }

    public final void setIntraDayQty(double intraDayQty) {
        this.intraDayQtyProperty().set(intraDayQty);
    }

    public final DoubleProperty frozenQtyProperty() {
        return this.frozenQty;
    }

    public final double getFrozenQty() {
        return this.frozenQtyProperty().get();
    }

    public final void setFrozenQty(double frozenQty) {
        this.frozenQtyProperty().set(frozenQty);
    }

    public final DoubleProperty secBalanceProperty() {
        return this.secBalance;
    }

    public final double getSecBalance() {
        return this.secBalanceProperty().get();
    }

    public final void setSecBalance(double secBalance) {
        this.secBalanceProperty().set(secBalance);
    }

    public final DoubleProperty secAvailProperty() {
        return this.secAvail;
    }

    public final double getSecAvail() {
        return this.secAvailProperty().get();
    }

    public final void setSecAvail(double secAvail) {
        this.secAvailProperty().set(secAvail);
    }

    public final DoubleProperty secWithDrawProperty() {
        return this.secWithDraw;
    }

    public final double getSecWithDraw() {
        return this.secWithDrawProperty().get();
    }

    public final void setSecWithDraw(double secWithDraw) {
        this.secWithDrawProperty().set(secWithDraw);
    }

    public final DoubleProperty cashBalanceProperty() {
        return this.cashBalance;
    }

    public final double getCashBalance() {
        return this.cashBalanceProperty().get();
    }

    public final void setCashBalance(double cashBalance) {
        this.cashBalanceProperty().set(cashBalance);
    }

    public final DoubleProperty cashAvailProperty() {
        return this.cashAvail;
    }

    public final double getCashAvail() {
        return this.cashAvailProperty().get();
    }

    public final void setCashAvail(double cashAvail) {
        this.cashAvailProperty().set(cashAvail);
    }

    public final DoubleProperty cashWithDrawProperty() {
        return this.cashWithDraw;
    }

    public final double getCashWithDraw() {
        return this.cashWithDrawProperty().get();
    }

    public final void setCashWithDraw(double cashWithDraw) {
        this.cashWithDrawProperty().set(cashWithDraw);
    }

    public final DoubleProperty marginQtyProperty() {
        return this.marginQty;
    }

    public final double getMarginQty() {
        return this.marginQtyProperty().get();
    }

    public final void setMarginQty(double marginQty) {
        this.marginQtyProperty().set(marginQty);
    }

    public final DoubleProperty receivableProperty() {
        return this.receivable;
    }

    public final double getReceivable() {
        return this.receivableProperty().get();
    }

    public final void setReceivable(double receivable) {
        this.receivableProperty().set(receivable);
    }

    public final DoubleProperty payableProperty() {
        return this.payable;
    }

    public final double getPayable() {
        return this.payableProperty().get();
    }

    public final void setPayable(double payable) {
        this.payableProperty().set(payable);
    }

    public final StringProperty secAccntIdProperty() {
        return this.secAccntId;
    }

    public final String getSecAccntId() {
        return (String)this.secAccntIdProperty().get();
    }

    public final void setSecAccntId(String secAccntId) {
        this.secAccntIdProperty().set((Object)secAccntId);
    }

    public final StringProperty cashAccntIdProperty() {
        return this.cashAccntId;
    }

    public final String getCashAccntId() {
        return (String)this.cashAccntIdProperty().get();
    }

    public final void setCashAccntId(String cashAccntId) {
        this.cashAccntIdProperty().set((Object)cashAccntId);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return (String)this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set((Object)securityName);
    }

    public String getExMarket() {
        return this.exMarket;
    }

    public void setExMarket(String exMarket) {
        this.exMarket = exMarket;
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return (String)this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set((Object)unit);
    }

    public final DoubleProperty costProperty() {
        return this.cost;
    }

    public final double getCost() {
        return this.costProperty().get();
    }

    public final void setCost(double cost) {
        this.costProperty().set(cost);
    }

    public final DoubleProperty holdCostAmtProperty() {
        return this.holdCostAmt;
    }

    public final double getHoldCostAmt() {
        return this.holdCostAmtProperty().get();
    }

    public final void setHoldCostAmt(double holdCostAmt) {
        this.holdCostAmtProperty().set(holdCostAmt);
    }

    public final DoubleProperty marketValueProperty() {
        return this.marketValue;
    }

    public final double getMarketValue() {
        return this.marketValueProperty().get();
    }

    public final void setMarketValue(double marketValue) {
        this.marketValueProperty().set(marketValue);
    }

    public final DoubleProperty buyCostProperty() {
        return this.buyCost;
    }

    public final double getBuyCost() {
        return this.buyCostProperty().get();
    }

    public final void setBuyCost(double buyCost) {
        this.buyCostProperty().set(buyCost);
    }

    public final DoubleProperty yieldProperty() {
        return this.yield;
    }

    public final double getYield() {
        return this.yieldProperty().get();
    }

    public final void setYield(double yield) {
        this.yieldProperty().set(yield);
    }

    public final DoubleProperty floatPnlProperty() {
        return this.floatPnl;
    }

    public final double getFloatPnl() {
        return this.floatPnlProperty().get();
    }

    public final void setFloatPnl(double floatPnl) {
        this.floatPnlProperty().set(floatPnl);
    }

    public final DoubleProperty totalProfitProperty() {
        return this.totalProfit;
    }

    public final double getTotalProfit() {
        return this.totalProfitProperty().get();
    }

    public final void setTotalProfit(double totalProfit) {
        this.totalProfitProperty().set(totalProfit);
    }

    public final DoubleProperty todayRealizedPlProperty() {
        return this.todayRealizedPl;
    }

    public final double getTodayRealizedPl() {
        return this.todayRealizedPlProperty().get();
    }

    public final void setTodayRealizedPl(double todayRealizedPl) {
        this.todayRealizedPlProperty().set(todayRealizedPl);
    }

    public final DoubleProperty nowPriceProperty() {
        return this.nowPrice;
    }

    public final double getNowPrice() {
        return this.nowPriceProperty().get();
    }

    public final void setNowPrice(double nowPrice) {
        this.nowPriceProperty().set(nowPrice);
    }

    public final DoubleProperty closePriceProperty() {
        return this.closePrice;
    }

    public final double getClosePrice() {
        return this.closePriceProperty().get();
    }

    public final void setClosePrice(double closePrice) {
        this.closePriceProperty().set(closePrice);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getSecType() {
        return this.secType;
    }

    public void setSecType(String secType) {
        this.secType = secType;
    }

    public final StringProperty totalStockPercentProperty() {
        return this.totalStockPercent;
    }

    public final String getTotalStockPercent() {
        return (String)this.totalStockPercentProperty().get();
    }

    public final void setTotalStockPercent(String totalStockPercent) {
        this.totalStockPercentProperty().set((Object)totalStockPercent);
    }

    public final DoubleProperty realPnlProperty() {
        return this.realPnl;
    }

    public final double getRealPnl() {
        return this.realPnlProperty().get();
    }

    public final void setRealPnl(double realPnl) {
        this.realPnlProperty().set(realPnl);
    }

    public final DoubleProperty buyInQtyProperty() {
        return this.buyInQty;
    }

    public final double getBuyInQty() {
        return this.buyInQtyProperty().get();
    }

    public final void setBuyInQty(double buyInQty) {
        this.buyInQtyProperty().set(buyInQty);
    }

    public final DoubleProperty sellOutQtyProperty() {
        return this.sellOutQty;
    }

    public final double getSellOutQty() {
        return this.sellOutQtyProperty().get();
    }

    public final void setSellOutQty(double sellOutQty) {
        this.sellOutQtyProperty().set(sellOutQty);
    }

    public final DoubleProperty buyInAmtProperty() {
        return this.buyInAmt;
    }

    public final double getBuyInAmt() {
        return this.buyInAmtProperty().get();
    }

    public final void setBuyInAmt(double buyInAmt) {
        this.buyInAmtProperty().set(buyInAmt);
    }

    public final DoubleProperty sellOutAmtProperty() {
        return this.sellOutAmt;
    }

    public final double getSellOutAmt() {
        return this.sellOutAmtProperty().get();
    }

    public final void setSellOutAmt(double sellOutAmt) {
        this.sellOutAmtProperty().set(sellOutAmt);
    }

    public final DoubleProperty cashDividendProperty() {
        return this.cashDividend;
    }

    public final double getCashDividend() {
        return this.cashDividendProperty().get();
    }

    public final void setCashDividend(double cashDividend) {
        this.cashDividendProperty().set(cashDividend);
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public final StringProperty sideProperty() {
        return this.side;
    }

    public final String getSide() {
        return (String)this.sideProperty().get();
    }

    public final void setSide(String side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty netProperty() {
        return this.net;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument) {
        this.instrument = instrument;
    }

    public final double getNet() {
        return this.netProperty().get();
    }

    public final void setNet(double net) {
        this.netProperty().set(net);
    }

    public final StringProperty portGrpNameProperty() {
        return this.portGrpName;
    }

    public final String getPortGrpName() {
        return (String)this.portGrpNameProperty().get();
    }

    public final void setPortGrpName(String portGrpName) {
        this.portGrpNameProperty().set((Object)portGrpName);
    }

    public double getOpenPrice() {
        return this.openPrice;
    }

    public void setOpenPrice(double openPrice) {
        this.openPrice = openPrice;
    }

    public final DoubleProperty rateProperty() {
        return this.rate;
    }

    public final double getRate() {
        return this.rateProperty().get();
    }

    public final void setRate(double rate) {
        this.rateProperty().set(rate);
    }

    public final DoubleProperty buyCostAmtProperty() {
        return this.buyCostAmt;
    }

    public final double getBuyCostAmt() {
        return this.buyCostAmtProperty().get();
    }

    public final void setBuyCostAmt(double buyCostAmt) {
        this.buyCostAmtProperty().set(buyCostAmt);
    }

    public final StringProperty typeProperty() {
        return this.type;
    }

    public final String getType() {
        return (String)this.typeProperty().get();
    }

    public final void setType(String type) {
        this.typeProperty().set((Object)type);
    }

    public final DoubleProperty posDividendProperty() {
        return this.posDividend;
    }

    public final double getPosDividend() {
        return this.posDividendProperty().get();
    }

    public final void setPosDividend(double posDividend) {
        this.posDividendProperty().set(posDividend);
    }

    public final StringProperty netValueDateProperty() {
        return this.netValueDate;
    }

    public final String getNetValueDate() {
        return (String)this.netValueDateProperty().get();
    }

    public final void setNetValueDate(String netValueDate) {
        this.netValueDateProperty().set((Object)netValueDate);
    }

    public final DoubleProperty feeProperty() {
        return this.fee;
    }

    public final double getFee() {
        return this.feeProperty().get();
    }

    public final void setFee(double fee) {
        this.feeProperty().set(fee);
    }

    public final DoubleProperty fundSizeProperty() {
        return this.fundSize;
    }

    public final double getFundSize() {
        return this.fundSizeProperty().get();
    }

    public final void setFundSize(double fundSize) {
        this.fundSizeProperty().set(fundSize);
    }

    public final DoubleProperty concentrationProperty() {
        return this.concentration;
    }

    public final double getConcentration() {
        return this.concentrationProperty().get();
    }

    public final void setConcentration(double concentration) {
        this.concentrationProperty().set(concentration);
    }

    public final ObjectProperty<SecSubType> secSubTypeProperty() {
        return this.secSubType;
    }

    public final SecSubType getSecSubType() {
        return (SecSubType)((Object)this.secSubTypeProperty().get());
    }

    public final void setSecSubType(SecSubType secSubType) {
        this.secSubTypeProperty().set((Object)secSubType);
    }

    public double getHkRate() {
        return this.hkRate;
    }

    public void setHkRate(double hkRate) {
        this.hkRate = hkRate;
    }

    public String getAssetGroupId() {
        return this.assetGroupId;
    }

    public void setAssetGroupId(String assetGroupId) {
        this.assetGroupId = assetGroupId;
    }

    public final DoubleProperty capitalCNYProperty() {
        return this.capitalCNY;
    }

    public final double getCapitalCNY() {
        return this.capitalCNYProperty().get();
    }

    public final void setCapitalCNY(double capitalCNY) {
        this.capitalCNYProperty().set(capitalCNY);
    }

    public final StringProperty investorNameProperty() {
        return this.investorName;
    }

    public final String getInvestorName() {
        return (String)this.investorNameProperty().get();
    }

    public final void setInvestorName(String investorName) {
        this.investorNameProperty().set((Object)investorName);
    }

    public PosStatistic getPosStatistic() {
        return this.posStatistic;
    }

    public void setPosStatistic(PosStatistic posStatistic) {
        this.posStatistic = posStatistic;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }
}

