/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.ObInstrument;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.Attachment;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.workflow.dto.WorkflowAttachment;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.MxNodeFactory;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObExecutionOtc
extends MxObject {
    private ObInstrument instrument;
    private StringProperty securityId = new SimpleStringProperty("");
    private StringProperty symbol = new SimpleStringProperty("");
    private StringProperty market = new SimpleStringProperty("");
    private ObjectProperty<Side> side = new SimpleObjectProperty();
    private DoubleProperty lastQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastPx = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastAmount = new SimpleDoubleProperty(0.0);
    private StringProperty execDate = new SimpleStringProperty("");
    private StringProperty orderId = new SimpleStringProperty("");
    private StringProperty execId = new SimpleStringProperty("");
    private StringProperty investorId = new SimpleStringProperty("");
    private StringProperty accountName = new SimpleStringProperty("");
    private StringProperty investorSecId = new SimpleStringProperty("");
    private StringProperty extCashAccntId = new SimpleStringProperty("");
    private StringProperty extSecAccntId = new SimpleStringProperty("");
    private StringProperty extOrderId = new SimpleStringProperty("");
    private StringProperty source = new SimpleStringProperty("");
    private DoubleProperty interest = new SimpleDoubleProperty(0.0);
    private DoubleProperty changeAmount = new SimpleDoubleProperty(0.0);
    private StringProperty execTime = new SimpleStringProperty("");
    private StringProperty userId = new SimpleStringProperty("");
    private DoubleProperty execFee = new SimpleDoubleProperty(0.0);
    private StringProperty instructionId = new SimpleStringProperty("");
    private StringProperty portfolioId = new SimpleStringProperty("");
    private StringProperty portfolioName = new SimpleStringProperty("");
    private transient List<WorkflowAttachment> attachments = new ArrayList<WorkflowAttachment>();
    private ObjectProperty<SecSubType> secSubType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> positionEffect = new SimpleObjectProperty((Object)new MxNode());
    private IntegerProperty dealTimes = new SimpleIntegerProperty(0);
    private Attachment attachment;

    public ObExecutionOtc() {
        this.instrument = new ObInstrument();
        this.setPositionEffect(new MxNode().load("position_effect", ""));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId.get() == null ? 0 : ((String)this.orderId.get()).hashCode());
        result = 31 * result + (this.execId.get() == null ? 0 : ((String)this.execId.get()).hashCode());
        result = 31 * result + (this.execDate.get() == null ? 0 : ((String)this.execDate.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObExecutionOtc other = (ObExecutionOtc)((Object)obj);
        if (this.orderId.get() == null ? other.orderId.get() != null : !((String)this.orderId.get()).equals(other.orderId.get())) {
            return false;
        }
        if (this.execId.get() == null ? other.execId.get() != null : !((String)this.execId.get()).equals(other.execId.get())) {
            return false;
        }
        return !(this.execDate.get() == null ? other.execDate.get() != null : !((String)this.execDate.get()).equals(other.execDate.get()));
    }

    public void update(Object obj) {
        if (obj instanceof ObExecutionOtc) {
            ObExecutionOtc exec = (ObExecutionOtc)((Object)ObExecutionOtc.class.cast(obj));
            this.update(exec);
        } else if (obj instanceof Execution) {
            Execution exec = (Execution)((Object)Execution.class.cast(obj));
            this.update(exec);
        }
    }

    private void update(Execution s) {
        this.setOrderId(s.getOrderId());
        this.setExtOrderId(s.getExtOrderId());
        this.setSide(s.getSide());
        this.instrument.update((Object)s.getInstrument());
        this.setExecId(s.getExecId());
        switch ((Side)((Object)this.side.getValue())) {
            case SIDE_SUBSCRIBE: 
            case SIDE_REDEEM: 
            case SIDE_CREATION: {
                this.setLastAmount((double)Math.round(s.getLastAmount() * 1000.0) / 1000.0);
                if (this.getLastAmount() != 0.0) break;
                this.setLastAmount((double)Math.round(s.getLastPx() * s.getLastQty() * 1000.0) / 1000.0);
                break;
            }
            case SIDE_BUY: 
            case SIDE_SELL: 
            case SIDE_CASH_DIVIDEND: {
                this.setLastAmount((double)Math.round(s.getLastAmount() * 1000.0) / 1000.0);
                break;
            }
            case SIDE_DIVIDEND_REINVEST: {
                this.setLastAmount(0.0);
                break;
            }
            default: {
                this.setLastAmount((double)Math.round(s.getLastAmount() * 1000.0) / 1000.0);
            }
        }
        this.setLastPx((double)Math.round(s.getLastPx() * 10000.0) / 10000.0);
        if (!Side.SIDE_CASH_DIVIDEND.equals(this.side.get())) {
            this.setLastQty(s.getLastQty());
        }
        this.setExecDate(s.getExecDate());
        this.setExecTime(s.getExecTime());
        this.setUserId(s.getUserId());
        this.setExecFee((double)Math.round(s.getExecFee() * 1000.0) / 1000.0);
        this.setInstructionId(s.getInstructionId());
        this.setPortfolioId(s.getPortfolioId());
        this.setPortfolioName(s.getPortfolioName());
        this.setAttachments(s.getAttachments());
        this.setSecSubType(s.getSecSubType());
        if (this.side.getValue() == Side.SIDE_REDEEM) {
            this.setChangeAmount((double)Math.round((this.getLastAmount() - this.getExecFee()) * 1000.0) / 1000.0);
        } else {
            this.setChangeAmount((double)Math.round((this.getLastAmount() + this.getExecFee()) * 1000.0) / 1000.0);
        }
        this.setSecurityId(s.getInstrument().getSecurityId());
        this.setSymbol(s.getInstrument().getSymbol());
        this.setMarket(s.getInstrument().getMarket());
        this.setOrderId(s.getOrderId());
        this.setExtOrderId(s.getExtOrderId());
        this.setInvestorId(s.getInvestorId());
        this.setInvestorSecId(s.getExtCashAccntId());
        this.setAccountName(s.getAccountName());
        this.setExecId(s.getExecId());
        this.setExtCashAccntId(s.getExtCashAccntId());
        this.setExtSecAccntId(s.getExtSecAccntId());
        this.setInterest(s.getInterest());
        if (s.getExecMode() != null) {
            String source = s.getExecMode().getEmName();
            if ("XHKG".equals(this.getMarket())) {
                StringBuffer type = new StringBuffer(s.getOrdType().getValue());
                type.append("#").append(source);
                MxNode node = MxNodeFactory.create((String)"hk_algo_name", (String)type.toString());
                if (node != null) {
                    source = node.getValue();
                }
                if (s.getAttachment() != null && !s.getAttachment().isEmpty()) {
                    this.setAttachment((Attachment)new Gson().fromJson(s.getAttachment(), Attachment.class));
                }
            }
            this.setSource(source);
        } else {
            this.setSource("");
        }
        this.getPositionEffect().setRaw(s.getPositionEffect() == null ? "" : "" + s.getPositionEffect().getValue());
    }

    private void update(ObExecutionOtc s) {
        this.setOrderId(s.getOrderId());
        this.setExtOrderId(s.getExtOrderId());
        this.setSide(s.getSide());
        this.instrument.update((Object)s.getInstrument());
        this.setExecId(s.getExecId());
        this.setLastAmount(s.getLastAmount());
        this.setLastPx(s.getLastPx());
        this.setLastQty(s.getLastQty());
        this.setExecDate(s.getExecDate());
        this.setExecTime(s.getExecTime());
        this.setUserId(s.getUserId());
        this.setExecFee(s.getExecFee());
        this.setInstructionId(s.getInstructionId());
        this.setPortfolioId(s.getPortfolioId());
        this.setPortfolioName(s.getPortfolioName());
        this.setAttachments(s.getAttachments());
        this.setSecSubType(s.getSecSubType());
        this.setChangeAmount(s.getChangeAmount());
        this.setSecurityId(s.getSecurityId());
        this.setSymbol(s.getSymbol());
        this.setMarket(s.getMarket());
        this.setOrderId(s.getOrderId());
        this.setExtOrderId(s.getExtOrderId());
        this.setInvestorId(s.getInvestorId());
        this.setInvestorSecId(s.getInvestorSecId());
        this.setAccountName(s.getAccountName());
        this.setSource(s.getSource());
        this.setExtCashAccntId(s.getExtCashAccntId());
        this.setExtSecAccntId(s.getExtSecAccntId());
        this.setInterest(s.getInterest());
        this.setPositionEffect(s.getPositionEffect());
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public final Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    public final void setSide(Side side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty lastQtyProperty() {
        return this.lastQty;
    }

    public final double getLastQty() {
        return this.lastQtyProperty().get();
    }

    public final void setLastQty(double lastQty) {
        this.lastQtyProperty().set(lastQty);
    }

    public final DoubleProperty lastPxProperty() {
        return this.lastPx;
    }

    public final double getLastPx() {
        return this.lastPxProperty().get();
    }

    public final void setLastPx(double lastPx) {
        this.lastPxProperty().set(lastPx);
    }

    public final DoubleProperty lastAmountProperty() {
        return this.lastAmount;
    }

    public final double getLastAmount() {
        return this.lastAmountProperty().get();
    }

    public final void setLastAmount(double lastAmount) {
        this.lastAmountProperty().set(lastAmount);
    }

    public final StringProperty execDateProperty() {
        return this.execDate;
    }

    public final String getExecDate() {
        return (String)this.execDateProperty().get();
    }

    public final void setExecDate(String execDate) {
        this.execDateProperty().set((Object)execDate);
    }

    public final DoubleProperty execFeeProperty() {
        return this.execFee;
    }

    public final double getExecFee() {
        return this.execFeeProperty().get();
    }

    public final void setExecFee(double execFee) {
        this.execFeeProperty().set(execFee);
    }

    public final StringProperty instructionIdProperty() {
        return this.instructionId;
    }

    public final String getInstructionId() {
        return (String)this.instructionIdProperty().get();
    }

    public final void setInstructionId(String instructionId) {
        this.instructionIdProperty().set((Object)instructionId);
    }

    public final StringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return (String)this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set((Object)portfolioId);
    }

    public final StringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return (String)this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set((Object)portfolioName);
    }

    public final ObjectProperty<SecSubType> secSubTypeProperty() {
        return this.secSubType;
    }

    public final SecSubType getSecSubType() {
        return (SecSubType)((Object)this.secSubTypeProperty().get());
    }

    public final void setSecSubType(SecSubType secSubType) {
        this.secSubTypeProperty().set((Object)secSubType);
    }

    public ObInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(ObInstrument instrument) {
        this.instrument = instrument;
    }

    public List<WorkflowAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<WorkflowAttachment> attachments) {
        this.attachments = attachments;
    }

    public final StringProperty execTimeProperty() {
        return this.execTime;
    }

    public final String getExecTime() {
        return (String)this.execTimeProperty().get();
    }

    public final void setExecTime(String execTime) {
        this.execTimeProperty().set((Object)execTime);
    }

    public final StringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return (String)this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set((Object)userId);
    }

    public final DoubleProperty changeAmountProperty() {
        return this.changeAmount;
    }

    public final double getChangeAmount() {
        return this.changeAmountProperty().get();
    }

    public final void setChangeAmount(double changeAmount) {
        this.changeAmountProperty().set(changeAmount);
    }

    public final StringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return (String)this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set((Object)securityId);
    }

    public final StringProperty symbolProperty() {
        return this.symbol;
    }

    public final String getSymbol() {
        return (String)this.symbolProperty().get();
    }

    public final void setSymbol(String symbol) {
        this.symbolProperty().set((Object)symbol);
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return (String)this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set((Object)orderId);
    }

    public final StringProperty execIdProperty() {
        return this.execId;
    }

    public final String getExecId() {
        return (String)this.execIdProperty().get();
    }

    public final void setExecId(String execId) {
        this.execIdProperty().set((Object)execId);
    }

    public final StringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return (String)this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set((Object)investorId);
    }

    public final StringProperty accountNameProperty() {
        return this.accountName;
    }

    public final String getAccountName() {
        return (String)this.accountNameProperty().get();
    }

    public final void setAccountName(String accountName) {
        this.accountNameProperty().set((Object)accountName);
    }

    public final StringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return (String)this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set((Object)investorSecId);
    }

    public final StringProperty extCashAccntIdProperty() {
        return this.extCashAccntId;
    }

    public final String getExtCashAccntId() {
        return (String)this.extCashAccntIdProperty().get();
    }

    public final void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntIdProperty().set((Object)extCashAccntId);
    }

    public final StringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return (String)this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set((Object)extSecAccntId);
    }

    public final StringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public final String getExtOrderId() {
        return (String)this.extOrderIdProperty().get();
    }

    public final void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set((Object)extOrderId);
    }

    public final IntegerProperty dealTimesProperty() {
        return this.dealTimes;
    }

    public final int getDealTimes() {
        return this.dealTimesProperty().get();
    }

    public final void setDealTimes(int dealTimes) {
        this.dealTimesProperty().set(dealTimes);
    }

    public final DoubleProperty interestProperty() {
        return this.interest;
    }

    public final StringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return (String)this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set((Object)source);
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public final double getInterest() {
        return this.interestProperty().get();
    }

    public final void setInterest(double interest) {
        this.interestProperty().set(interest);
    }

    public final ObjectProperty<MxNode> positionEffectProperty() {
        return this.positionEffect;
    }

    public final MxNode getPositionEffect() {
        return (MxNode)this.positionEffectProperty().get();
    }

    public final void setPositionEffect(MxNode positionEffect) {
        this.positionEffectProperty().set((Object)positionEffect);
    }
}

