/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.pricingit.ExecMode;
import cms.tmx.http.api.strategy.dto.AccntId;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.strategy.dto.TradeMethod;
import cms.tmx.http.workflow.dto.WorkflowAttachment;
import cms.tmx.javafx.obj.MxObject;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ObExecution
extends MxObject {
    private ObjectProperty<Instrument> instrument = new SimpleObjectProperty();
    private ObjectProperty<Side> side = new SimpleObjectProperty();
    private DoubleProperty lastQty = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastPx = new SimpleDoubleProperty(0.0);
    private DoubleProperty lastAmount = new SimpleDoubleProperty(0.0);
    private SimpleStringProperty sysOrderId = new SimpleStringProperty("");
    private SimpleStringProperty orderId = new SimpleStringProperty("");
    private SimpleStringProperty execTime = new SimpleStringProperty("");
    private SimpleStringProperty execDate = new SimpleStringProperty("");
    private SimpleStringProperty execId = new SimpleStringProperty("");
    private SimpleStringProperty extOrderId = new SimpleStringProperty("");
    private DoubleProperty execFee = new SimpleDoubleProperty(0.0);
    private ObjectProperty<AccntId> extAccntId = new SimpleObjectProperty();
    private SimpleStringProperty extCashAccntId = new SimpleStringProperty("");
    private SimpleStringProperty extSecAccntId = new SimpleStringProperty("");
    private SimpleStringProperty market = new SimpleStringProperty("");
    private SimpleStringProperty marketGrp = new SimpleStringProperty("");
    private DoubleProperty useMargin = new SimpleDoubleProperty(0.0);
    private SimpleStringProperty instructionId = new SimpleStringProperty("");
    ExecMode execMode;
    private DoubleProperty ytm = new SimpleDoubleProperty(0.0);
    private ObjectProperty<SettlType> settlType = new SimpleObjectProperty();
    private SimpleStringProperty termToMaturity = new SimpleStringProperty("");
    private ObjectProperty<MatchType> matchType = new SimpleObjectProperty();
    private ObjectProperty<Party> selfParty = new SimpleObjectProperty();
    private ObjectProperty<Party> counterParty = new SimpleObjectProperty();
    private ObjectProperty<TradeMethod> tradeMethod = new SimpleObjectProperty();
    private ObjectProperty<AccntId> subAccntId = new SimpleObjectProperty();
    private SimpleStringProperty parentId = new SimpleStringProperty("");
    private SimpleStringProperty clOrdId = new SimpleStringProperty("");
    private SimpleStringProperty portfolioId = new SimpleStringProperty("");
    private SimpleStringProperty attachment = new SimpleStringProperty("");
    private SimpleStringProperty portfolioName = new SimpleStringProperty("");
    private transient List<WorkflowAttachment> attachments = new ArrayList<WorkflowAttachment>();
    private ObjectProperty<SecSubType> secSubType = new SimpleObjectProperty();
    private SimpleStringProperty securityId = new SimpleStringProperty("");
    private SimpleStringProperty securityName = new SimpleStringProperty("");
    private SimpleStringProperty securityGroup = new SimpleStringProperty("");
    private SimpleStringProperty chName = new SimpleStringProperty("");
    private SimpleStringProperty counterTraderId = new SimpleStringProperty("");
    private SimpleStringProperty source = new SimpleStringProperty("");
    private SimpleStringProperty sourceId = new SimpleStringProperty("");
    private StringProperty ordCategory = new SimpleStringProperty("");
    private SimpleStringProperty unit = new SimpleStringProperty("");
    private SimpleStringProperty investorId = new SimpleStringProperty("");
    private StringProperty accountName = new SimpleStringProperty("");
    private SimpleStringProperty investorSecId = new SimpleStringProperty("");
    private SimpleStringProperty userId = new SimpleStringProperty("");
    private SimpleStringProperty subCashAccntId = new SimpleStringProperty("");
    private SimpleStringProperty subSecAccntId = new SimpleStringProperty("");
    private SimpleStringProperty brokerId = new SimpleStringProperty("");
    private SimpleStringProperty productId = new SimpleStringProperty("");
    private SimpleStringProperty tradeDate = new SimpleStringProperty("");
    private SimpleStringProperty symbol = new SimpleStringProperty("");
    private SimpleStringProperty positionEffect = new SimpleStringProperty("");
    private double lastAmountSum = 0.0;
    private SimpleLongProperty dealTimes = new SimpleLongProperty(0L);
    private SimpleStringProperty traderName = new SimpleStringProperty("");
    private SimpleStringProperty authorizer = new SimpleStringProperty("");
    private IntegerProperty dealCount = new SimpleIntegerProperty(0);

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.orderId == null ? 0 : this.orderId.hashCode());
        result = 31 * result + (this.execId == null ? 0 : this.execId.hashCode());
        result = 31 * result + (this.execDate == null ? 0 : this.execDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ObExecution other = (ObExecution)((Object)obj);
        if (this.orderId == null ? other.orderId != null : !this.orderId.equals(other.orderId)) {
            return false;
        }
        if (this.execId == null ? other.execId != null : !this.execId.equals(other.execId)) {
            return false;
        }
        return !(this.execDate == null ? other.execDate != null : !this.execDate.equals(other.execDate));
    }

    public void update(Object obj) {
        if (obj instanceof Execution) {
            Execution s = (Execution)((Object)Execution.class.cast(obj));
            this.update(s);
        } else if (obj instanceof ObExecution) {
            ObExecution s = (ObExecution)((Object)ObExecution.class.cast(obj));
            this.update(s);
        }
    }

    private void update(ObExecution exec) {
        this.setInstrument(exec.getInstrument());
        this.setSecurityId(exec.getSecurityId());
        this.setSecurityName(exec.getSecurityName());
        this.setSymbol(exec.getInstrument().getSymbol());
        this.setSecurityGroup(exec.getSecurityGroup());
        this.setMarket(exec.getMarket());
        this.setInvestorId(exec.getInvestorId());
        this.setInvestorSecId(exec.getInvestorSecId());
        this.setExtCashAccntId(exec.getExtCashAccntId());
        this.setSubCashAccntId(exec.getSubCashAccntId());
        this.setSubSecAccntId(exec.getSubSecAccntId());
        this.setAccountName(exec.getAccountName());
        this.setOrderId(exec.getOrderId());
        this.setSysOrderId(exec.getSysOrderId());
        this.setExtOrderId(exec.getExtOrderId());
        this.setSide(exec.getSide());
        this.setExecId(exec.getExecId());
        this.setExecDate(exec.getExecDate());
        this.setExecTime(exec.getExecTime());
        this.setLastAmount(exec.getLastAmount());
        this.setLastPx(exec.getLastPx());
        this.setLastQty(exec.getLastQty());
        this.setSource(exec.getSource());
        this.setSourceId(exec.getSourceId());
        this.setOrdCategory(exec.getOrdCategory());
        this.setUserId(exec.getUserId());
        this.setBrokerId(exec.getBrokerId());
        this.setProductId(exec.getProductId());
        this.setTradeDate(exec.getTradeDate());
        this.setUnit(exec.getUnit(this.getInstrument()));
        this.setPortfolioName(exec.getPortfolioName());
        this.setPositionEffect(exec.getPositionEffect());
        this.setTraderName(exec.getSelfParty() == null ? "" : exec.getSelfParty().getTraderId());
        this.setAuthorizer(exec.getAuthorizer());
        this.setDealCount(exec.getDealCount());
        this.setExecFee(exec.getExecFee());
        this.setSecSubType(exec.getSecSubType());
        this.setInstructionId(exec.getInstructionId());
        this.setDealCount(exec.getDealCount());
    }

    private void update(Execution exec) {
        this.setInstrument(exec.getInstrument());
        this.setSecurityId(exec.getInstrument().getSecurityId());
        this.setSecurityName(exec.getInstrument().getSymbol());
        this.setSymbol(exec.getInstrument().getSymbol());
        this.setSecurityGroup(exec.getSecurityGroup());
        this.setMarket(exec.getMarket());
        this.setSecSubType(SecSubType.get(exec.getSecuritySubType()));
        this.setInvestorId(exec.getInvestorId());
        this.setInvestorSecId(exec.getInvestorSecId());
        this.setExtCashAccntId(exec.getExtCashAccntId());
        this.setSubCashAccntId(exec.getSubCashAccntId());
        this.setSubSecAccntId(exec.getSubSecAccntId());
        this.setAccountName(exec.getAccountName());
        this.setOrderId(exec.getOrderId());
        this.setSide(exec.getSide());
        this.setExecId(exec.getExecId());
        this.setLastAmount(exec.getLastAmount());
        this.setLastPx(exec.getLastPx());
        this.setLastQty(exec.getLastQty());
        this.setSource(exec.getSource());
        this.setSourceId(exec.getSourceId());
        this.setOrdCategory(exec.getOrdCategory());
        this.setSysOrderId(exec.getSysOrderId());
        this.setExtOrderId(exec.getExtOrderId());
        this.setExecTime(exec.getExecTime());
        this.setExecDate(exec.getExecDate());
        this.setUserId(exec.getUserId());
        this.setBrokerId(exec.getBrokerId());
        this.setProductId(exec.getProductId());
        this.setTradeDate(exec.getTradeDate());
        this.setUnit(exec.getUnit());
        this.setPortfolioName(exec.getPortfolioName());
        this.setPositionEffect(exec.getPositionEffect() == null ? "" : this.transferOc(exec.getPositionEffect().toString()));
        this.setSelfParty(exec.getSelfparty());
        this.setTraderName(exec.getSelfparty() == null ? "" : exec.getSelfparty().getTraderId());
        this.setExecFee(exec.getExecFee());
        this.setInstructionId(exec.getInstructionId());
        this.setDealCount(exec.getDealCount());
        this.setAuthorizer(exec.getUserName());
    }

    private String transferOc(String positionEffect) {
        if ("PE_CLOSE".equals(positionEffect)) {
            return "\u5e73\u4ed3";
        }
        if ("PE_OPEN".equals(positionEffect)) {
            return "\u5f00\u4ed3";
        }
        if ("PE_FIFO".equals(positionEffect)) {
            return "\u81ea\u52a8";
        }
        return null;
    }

    public String getUnit(Instrument inst) {
        String type = inst.getSecurityType();
        return ObExecution.getUnit(type, this.getMarket());
    }

    public static String getUnit(String secType, String market) {
        if ("STOCK".equals(secType) || "OIS".equals(secType)) {
            return "\u80a1";
        }
        if ("BOND".equals(secType) && "XSHG".equals(market) || "STD_BOND".equals(secType) && "XSHG".equals(market) || "REPO".equals(secType) && "XSHG".equals(market) || "PLEDGE".equals(secType) && "XSHG".equals(market)) {
            return "\u624b";
        }
        if ("BOND".equals(secType) && "XSHE".equals(market) || "STD_BOND".equals(secType) && "XSHE".equals(market) || "REPO".equals(secType) && "XSHE".equals(market) || "PLEDGE".equals(secType) && "XSHE".equals(market)) {
            return "\u5f20";
        }
        if ("FUND".equals(secType)) {
            return "\u4efd";
        }
        return "";
    }

    public final ObjectProperty<Instrument> instrumentProperty() {
        return this.instrument;
    }

    public final Instrument getInstrument() {
        return (Instrument)this.instrumentProperty().get();
    }

    public final void setInstrument(Instrument instrument) {
        this.instrumentProperty().set((Object)instrument);
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public final Side getSide() {
        return (Side)((Object)this.sideProperty().get());
    }

    public final void setSide(Side side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty lastQtyProperty() {
        return this.lastQty;
    }

    public final double getLastQty() {
        return this.lastQtyProperty().get();
    }

    public final void setLastQty(double lastQty) {
        this.lastQtyProperty().set(lastQty);
    }

    public final DoubleProperty lastPxProperty() {
        return this.lastPx;
    }

    public final double getLastPx() {
        return this.lastPxProperty().get();
    }

    public final void setLastPx(double lastPx) {
        this.lastPxProperty().set(lastPx);
    }

    public final DoubleProperty lastAmountProperty() {
        return this.lastAmount;
    }

    public final double getLastAmount() {
        return this.lastAmountProperty().get();
    }

    public final void setLastAmount(double lastAmount) {
        this.lastAmountProperty().set(lastAmount);
    }

    public final SimpleStringProperty sysOrderIdProperty() {
        return this.sysOrderId;
    }

    public final String getSysOrderId() {
        return this.sysOrderIdProperty().get();
    }

    public final void setSysOrderId(String sysOrderId) {
        this.sysOrderIdProperty().set(sysOrderId);
    }

    public final SimpleStringProperty orderIdProperty() {
        return this.orderId;
    }

    public final String getOrderId() {
        return this.orderIdProperty().get();
    }

    public final void setOrderId(String orderId) {
        this.orderIdProperty().set(orderId);
    }

    public final SimpleStringProperty execTimeProperty() {
        return this.execTime;
    }

    public final String getExecTime() {
        return this.execTimeProperty().get();
    }

    public final void setExecTime(String execTime) {
        this.execTimeProperty().set(execTime);
    }

    public final SimpleStringProperty execDateProperty() {
        return this.execDate;
    }

    public final String getExecDate() {
        return this.execDateProperty().get();
    }

    public final void setExecDate(String execDate) {
        this.execDateProperty().set(execDate);
    }

    public final SimpleStringProperty execIdProperty() {
        return this.execId;
    }

    public final String getExecId() {
        return this.execIdProperty().get();
    }

    public final void setExecId(String execId) {
        this.execIdProperty().set(execId);
    }

    public final SimpleStringProperty extOrderIdProperty() {
        return this.extOrderId;
    }

    public final String getExtOrderId() {
        return this.extOrderIdProperty().get();
    }

    public final void setExtOrderId(String extOrderId) {
        this.extOrderIdProperty().set(extOrderId);
    }

    public final DoubleProperty execFeeProperty() {
        return this.execFee;
    }

    public final double getExecFee() {
        return this.execFeeProperty().get();
    }

    public final void setExecFee(double execFee) {
        this.execFeeProperty().set(execFee);
    }

    public final ObjectProperty<AccntId> extAccntIdProperty() {
        return this.extAccntId;
    }

    public final AccntId getExtAccntId() {
        return (AccntId)this.extAccntIdProperty().get();
    }

    public final void setExtAccntId(AccntId extAccntId) {
        this.extAccntIdProperty().set((Object)extAccntId);
    }

    public final SimpleStringProperty extCashAccntIdProperty() {
        return this.extCashAccntId;
    }

    public final String getExtCashAccntId() {
        return this.extCashAccntIdProperty().get();
    }

    public final void setExtCashAccntId(String extCashAccntId) {
        this.extCashAccntIdProperty().set(extCashAccntId);
    }

    public final SimpleStringProperty extSecAccntIdProperty() {
        return this.extSecAccntId;
    }

    public final String getExtSecAccntId() {
        return this.extSecAccntIdProperty().get();
    }

    public final void setExtSecAccntId(String extSecAccntId) {
        this.extSecAccntIdProperty().set(extSecAccntId);
    }

    public final SimpleStringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set(market);
    }

    public final SimpleStringProperty marketGrpProperty() {
        return this.marketGrp;
    }

    public final String getMarketGrp() {
        return this.marketGrpProperty().get();
    }

    public final void setMarketGrp(String marketGrp) {
        this.marketGrpProperty().set(marketGrp);
    }

    public final DoubleProperty useMarginProperty() {
        return this.useMargin;
    }

    public final double getUseMargin() {
        return this.useMarginProperty().get();
    }

    public final void setUseMargin(double useMargin) {
        this.useMarginProperty().set(useMargin);
    }

    public final SimpleStringProperty instructionIdProperty() {
        return this.instructionId;
    }

    public final String getInstructionId() {
        return this.instructionIdProperty().get();
    }

    public final void setInstructionId(String instructionId) {
        this.instructionIdProperty().set(instructionId);
    }

    public final DoubleProperty ytmProperty() {
        return this.ytm;
    }

    public final double getYtm() {
        return this.ytmProperty().get();
    }

    public final void setYtm(double ytm) {
        this.ytmProperty().set(ytm);
    }

    public final ObjectProperty<SettlType> settlTypeProperty() {
        return this.settlType;
    }

    public final SettlType getSettlType() {
        return (SettlType)((Object)this.settlTypeProperty().get());
    }

    public final void setSettlType(SettlType settlType) {
        this.settlTypeProperty().set((Object)settlType);
    }

    public final SimpleStringProperty termToMaturityProperty() {
        return this.termToMaturity;
    }

    public final String getTermToMaturity() {
        return this.termToMaturityProperty().get();
    }

    public final void setTermToMaturity(String termToMaturity) {
        this.termToMaturityProperty().set(termToMaturity);
    }

    public final ObjectProperty<MatchType> matchTypeProperty() {
        return this.matchType;
    }

    public final MatchType getMatchType() {
        return (MatchType)this.matchTypeProperty().get();
    }

    public final void setMatchType(MatchType matchType) {
        this.matchTypeProperty().set((Object)matchType);
    }

    public final ObjectProperty<Party> selfPartyProperty() {
        return this.selfParty;
    }

    public final Party getSelfParty() {
        return (Party)this.selfPartyProperty().get();
    }

    public final void setSelfParty(Party selfParty) {
        this.selfPartyProperty().set((Object)selfParty);
    }

    public final ObjectProperty<Party> counterPartyProperty() {
        return this.counterParty;
    }

    public final Party getCounterParty() {
        return (Party)this.counterPartyProperty().get();
    }

    public final void setCounterParty(Party counterParty) {
        this.counterPartyProperty().set((Object)counterParty);
    }

    public final ObjectProperty<TradeMethod> tradeMethodProperty() {
        return this.tradeMethod;
    }

    public final TradeMethod getTradeMethod() {
        return (TradeMethod)((Object)this.tradeMethodProperty().get());
    }

    public final void setTradeMethod(TradeMethod tradeMethod) {
        this.tradeMethodProperty().set((Object)tradeMethod);
    }

    public final ObjectProperty<AccntId> subAccntIdProperty() {
        return this.subAccntId;
    }

    public final AccntId getSubAccntId() {
        return (AccntId)this.subAccntIdProperty().get();
    }

    public final void setSubAccntId(AccntId subAccntId) {
        this.subAccntIdProperty().set((Object)subAccntId);
    }

    public final SimpleStringProperty parentIdProperty() {
        return this.parentId;
    }

    public final String getParentId() {
        return this.parentIdProperty().get();
    }

    public final void setParentId(String parentId) {
        this.parentIdProperty().set(parentId);
    }

    public final SimpleStringProperty clOrdIdProperty() {
        return this.clOrdId;
    }

    public final String getClOrdId() {
        return this.clOrdIdProperty().get();
    }

    public final void setClOrdId(String clOrdId) {
        this.clOrdIdProperty().set(clOrdId);
    }

    public final SimpleStringProperty portfolioIdProperty() {
        return this.portfolioId;
    }

    public final String getPortfolioId() {
        return this.portfolioIdProperty().get();
    }

    public final void setPortfolioId(String portfolioId) {
        this.portfolioIdProperty().set(portfolioId);
    }

    public final SimpleStringProperty attachmentProperty() {
        return this.attachment;
    }

    public final String getAttachment() {
        return this.attachmentProperty().get();
    }

    public final void setAttachment(String attachment) {
        this.attachmentProperty().set(attachment);
    }

    public final SimpleStringProperty portfolioNameProperty() {
        return this.portfolioName;
    }

    public final String getPortfolioName() {
        return this.portfolioNameProperty().get();
    }

    public final void setPortfolioName(String portfolioName) {
        this.portfolioNameProperty().set(portfolioName);
    }

    public final ObjectProperty<SecSubType> secSubTypeProperty() {
        return this.secSubType;
    }

    public final SecSubType getSecSubType() {
        return (SecSubType)((Object)this.secSubTypeProperty().get());
    }

    public final void setSecSubType(SecSubType secSubType) {
        this.secSubTypeProperty().set((Object)secSubType);
    }

    public final SimpleStringProperty securityIdProperty() {
        return this.securityId;
    }

    public final String getSecurityId() {
        return this.securityIdProperty().get();
    }

    public final void setSecurityId(String securityId) {
        this.securityIdProperty().set(securityId);
    }

    public final SimpleStringProperty securityNameProperty() {
        return this.securityName;
    }

    public final String getSecurityName() {
        return this.securityNameProperty().get();
    }

    public final void setSecurityName(String securityName) {
        this.securityNameProperty().set(securityName);
    }

    public final SimpleStringProperty securityGroupProperty() {
        return this.securityGroup;
    }

    public final String getSecurityGroup() {
        return this.securityGroupProperty().get();
    }

    public final void setSecurityGroup(String securityGroup) {
        this.securityGroupProperty().set(securityGroup);
    }

    public final SimpleStringProperty chNameProperty() {
        return this.chName;
    }

    public final String getChName() {
        return this.chNameProperty().get();
    }

    public final void setChName(String chName) {
        this.chNameProperty().set(chName);
    }

    public final SimpleStringProperty counterTraderIdProperty() {
        return this.counterTraderId;
    }

    public final String getCounterTraderId() {
        return this.counterTraderIdProperty().get();
    }

    public final void setCounterTraderId(String counterTraderId) {
        this.counterTraderIdProperty().set(counterTraderId);
    }

    public final SimpleStringProperty sourceProperty() {
        return this.source;
    }

    public final String getSource() {
        return this.sourceProperty().get();
    }

    public final void setSource(String source) {
        this.sourceProperty().set(source);
    }

    public final SimpleStringProperty unitProperty() {
        return this.unit;
    }

    public final String getUnit() {
        return this.unitProperty().get();
    }

    public final void setUnit(String unit) {
        this.unitProperty().set(unit);
    }

    public final SimpleStringProperty investorIdProperty() {
        return this.investorId;
    }

    public final String getInvestorId() {
        return this.investorIdProperty().get();
    }

    public final void setInvestorId(String investorId) {
        this.investorIdProperty().set(investorId);
    }

    public final SimpleStringProperty investorSecIdProperty() {
        return this.investorSecId;
    }

    public final String getInvestorSecId() {
        return this.investorSecIdProperty().get();
    }

    public final void setInvestorSecId(String investorSecId) {
        this.investorSecIdProperty().set(investorSecId);
    }

    public final SimpleStringProperty userIdProperty() {
        return this.userId;
    }

    public final String getUserId() {
        return this.userIdProperty().get();
    }

    public final void setUserId(String userId) {
        this.userIdProperty().set(userId);
    }

    public final SimpleStringProperty subCashAccntIdProperty() {
        return this.subCashAccntId;
    }

    public final String getSubCashAccntId() {
        return this.subCashAccntIdProperty().get();
    }

    public final void setSubCashAccntId(String subCashAccntId) {
        this.subCashAccntIdProperty().set(subCashAccntId);
    }

    public final SimpleStringProperty subSecAccntIdProperty() {
        return this.subSecAccntId;
    }

    public final String getSubSecAccntId() {
        return this.subSecAccntIdProperty().get();
    }

    public final void setSubSecAccntId(String subSecAccntId) {
        this.subSecAccntIdProperty().set(subSecAccntId);
    }

    public final SimpleStringProperty brokerIdProperty() {
        return this.brokerId;
    }

    public final String getBrokerId() {
        return this.brokerIdProperty().get();
    }

    public final void setBrokerId(String brokerId) {
        this.brokerIdProperty().set(brokerId);
    }

    public final SimpleStringProperty productIdProperty() {
        return this.productId;
    }

    public final String getProductId() {
        return this.productIdProperty().get();
    }

    public final void setProductId(String productId) {
        this.productIdProperty().set(productId);
    }

    public final SimpleStringProperty tradeDateProperty() {
        return this.tradeDate;
    }

    public final String getTradeDate() {
        return this.tradeDateProperty().get();
    }

    public final void setTradeDate(String tradeDate) {
        this.tradeDateProperty().set(tradeDate);
    }

    public final SimpleStringProperty symbolProperty() {
        return this.symbol;
    }

    public final String getSymbol() {
        return this.symbolProperty().get();
    }

    public final void setSymbol(String symbol) {
        this.symbolProperty().set(symbol);
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    public void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public final SimpleStringProperty positionEffectProperty() {
        return this.positionEffect;
    }

    public final String getPositionEffect() {
        return this.positionEffectProperty().get();
    }

    public final void setPositionEffect(String positionEffect) {
        this.positionEffectProperty().set(positionEffect);
    }

    public double getLastAmountSum() {
        return this.lastAmountSum;
    }

    public void setLastAmountSum(double lastAmountSum) {
        this.lastAmountSum = lastAmountSum;
    }

    public final SimpleLongProperty dealTimesProperty() {
        return this.dealTimes;
    }

    public final long getDealTimes() {
        return this.dealTimesProperty().get();
    }

    public final void setDealTimes(long dealTimes) {
        this.dealTimesProperty().set(dealTimes);
    }

    public final SimpleStringProperty traderNameProperty() {
        return this.traderName;
    }

    public final String getTraderName() {
        return this.traderNameProperty().get();
    }

    public final void setTraderName(String traderName) {
        this.traderNameProperty().set(traderName);
    }

    public final SimpleStringProperty authorizerProperty() {
        return this.authorizer;
    }

    public final String getAuthorizer() {
        return this.authorizerProperty().get();
    }

    public final void setAuthorizer(String authorizer) {
        this.authorizerProperty().set(authorizer);
    }

    public final IntegerProperty dealCountProperty() {
        return this.dealCount;
    }

    public final int getDealCount() {
        return this.dealCountProperty().get();
    }

    public final void setDealCount(int dealCount) {
        this.dealCountProperty().set(dealCount);
    }

    public final StringProperty accountNameProperty() {
        return this.accountName;
    }

    public final String getAccountName() {
        return (String)this.accountNameProperty().get();
    }

    public final void setAccountName(String accountName) {
        this.accountNameProperty().set((Object)accountName);
    }

    public final SimpleStringProperty sourceIdProperty() {
        return this.sourceId;
    }

    public final String getSourceId() {
        return this.sourceIdProperty().get();
    }

    public final void setSourceId(String sourceId) {
        this.sourceIdProperty().set(sourceId);
    }

    public final StringProperty ordCategoryProperty() {
        return this.ordCategory;
    }

    public final String getOrdCategory() {
        return (String)this.ordCategoryProperty().get();
    }

    public final void setOrdCategory(String ordCategory) {
        this.ordCategoryProperty().set((Object)ordCategory);
    }
}

