/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.utils.GsonEnum;
import cms.tmx.javafx.MxNode;
import cms.tmx.utils.StringUtils;

public enum MatchType implements GsonEnum<MatchType>
{
    UNKNOWN_MATCHTYPE("0", "", ""),
    CONTINUOUS_MATCHING("9", "B", "\u8fde\u7eed\u7ade\u4ef7"),
    CENTRALIZED_MATCHING("10", "C", "\u96c6\u5408\u7ade\u4ef7"),
    AGREEMENT_MATCHING("90", "T", "\u534f\u8bae\u65b9\u5f0f(\u5b9a\u4ef7)"),
    MARKET_MAKER_MATCHING("11", "M", "\u505a\u5e02\u8f6c\u8ba9"),
    UNITED_QUERY_MATCHING("92", "J", "\u8054\u5408\u67e5\u8be2\u65b9\u5f0f(B+C\u9650\u4ef7)"),
    ISSUE_MATCHING("94", "P", "\u53d1\u884c\u65b9\u5f0f"),
    OTHERS_MATCHING("93", "O", "\u5176\u4ed6\u7c7b\u578b");

    private String value;
    private String refKey;
    private String des;

    private MatchType(String value, String refKey, String des) {
        this.value = value;
        this.refKey = refKey;
        this.des = des;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRefKey() {
        return this.refKey;
    }

    public void setRefKey(String refKey) {
        this.refKey = refKey;
    }

    public String getDes() {
        return this.des;
    }

    public void setDes(String des) {
        this.des = des;
    }

    public static MatchType getMatchTypeByRefKey(String refKey) {
        MatchType[] matchTypeArray = MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchType type = matchTypeArray[n2];
            if (refKey.equals(type.getRefKey())) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN_MATCHTYPE;
    }

    public static String getDes(String refKey) {
        if (refKey == null) {
            return "";
        }
        MatchType[] matchTypeArray = MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchType type = matchTypeArray[n2];
            if (refKey.equals(type.getRefKey())) {
                return type.des;
            }
            ++n2;
        }
        return "";
    }

    public static MatchType getMatchType(String value) {
        if (value.equals("9")) {
            return CONTINUOUS_MATCHING;
        }
        if (value.equals("10")) {
            return CENTRALIZED_MATCHING;
        }
        return UNKNOWN_MATCHTYPE;
    }

    public static MatchType getMatchTypeByDes(String des) {
        MatchType[] matchTypeArray = MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchType type = matchTypeArray[n2];
            if (des.equals(type.getDes())) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN_MATCHTYPE;
    }

    public static MatchType getMatchTypeByValue(String value) {
        MatchType[] matchTypeArray = MatchType.values();
        int n = matchTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchType type = matchTypeArray[n2];
            if (value.equals(type.getValue())) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN_MATCHTYPE;
    }

    public String toString() {
        MxNode node = new MxNode().load("neeq_match_type", this.getValue());
        return node.getValue();
    }

    @Override
    public String serialize() {
        return this.getValue();
    }

    @Override
    public MatchType deserialize(String jsonEnum) {
        if (StringUtils.isNum((String)jsonEnum)) {
            return MatchType.getMatchTypeByValue(jsonEnum);
        }
        return Enum.valueOf(MatchType.class, jsonEnum);
    }
}

