/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.dto;

import cms.tmx.http.utils.GsonEnum;
import cms.tmx.utils.StringUtils;

public enum ExecModeType implements GsonEnum<ExecModeType>
{
    EXEC_MODE_TYPE_UNDEFINED(0),
    EXEC_MODE_TYPE_MANUAL(1),
    EXEC_MODE_TYPE_AUTO(2),
    EXEC_MODE_TYPE_ALGORITHM(3),
    EXEC_MODE_TYPE_INSTRUCTION(4),
    EXEC_MODE_TYPE_ALGOORDER(5),
    EXEC_MODE_TYPE_MARKETMAKING(6),
    EXEC_MODE_TYPE_HEDGE(7),
    EXEC_MODE_TYPE_SDF_ARBITRAGE(8),
    EXEC_MODE_TYPE_TBF_ARBITRAGE(9),
    EXEC_MODE_TYPE_HEDGE_MANUAL(10),
    EXEC_MODE_TYPE_XBOND_ACTIVE_DEAL(11),
    EXEC_MODE_TYPE_XBOND_BOTH_DEAL(12),
    EXEC_MODE_TYPE_XBOND_SINGLE_DEAL(13),
    EXEC_MODE_TYPE_XBOND_ACTIVE_DEAL_HEDGE(14),
    EXEC_MODE_TYPE_XBOND_SINGLE_DEAL_HEDGE(15),
    EXEC_MODE_TYPE_XBOND_CUSTOM_BUY(16),
    EXEC_MODE_TYPE_XBOND_CUSTOM_SELL(17),
    EXEC_MODE_TYPE_XBOND_CUSTOM_MARKETMAKING(18),
    EXEC_MODE_TYPE_XBOND_CUSTOM_HEGED(19),
    EXEC_MODE_TYPE_SBF_ARBITRAE_BUY(200),
    EXEC_MODE_TYPE_SBF_ARBITRAE_SELL(201),
    EXEC_MODE_TYPE_SBF_ARBITRAE_MARKETMAKING(202),
    EXEC_MODE_TYPE_REPO_ALGO(300);

    private int value;

    private ExecModeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String strValue() {
        return String.valueOf(this.value);
    }

    public void setValue(int value) {
        this.value = value;
    }

    public static ExecModeType getExecModeType(int value) {
        switch (value) {
            case 0: {
                return EXEC_MODE_TYPE_UNDEFINED;
            }
            case 1: {
                return EXEC_MODE_TYPE_MANUAL;
            }
            case 2: {
                return EXEC_MODE_TYPE_AUTO;
            }
            case 3: {
                return EXEC_MODE_TYPE_ALGORITHM;
            }
            case 4: {
                return EXEC_MODE_TYPE_INSTRUCTION;
            }
            case 5: {
                return EXEC_MODE_TYPE_ALGOORDER;
            }
            case 6: {
                return EXEC_MODE_TYPE_MARKETMAKING;
            }
            case 7: {
                return EXEC_MODE_TYPE_HEDGE;
            }
            case 8: {
                return EXEC_MODE_TYPE_SDF_ARBITRAGE;
            }
            case 9: {
                return EXEC_MODE_TYPE_TBF_ARBITRAGE;
            }
            case 10: {
                return EXEC_MODE_TYPE_HEDGE_MANUAL;
            }
            case 11: {
                return EXEC_MODE_TYPE_XBOND_ACTIVE_DEAL;
            }
            case 12: {
                return EXEC_MODE_TYPE_XBOND_BOTH_DEAL;
            }
            case 13: {
                return EXEC_MODE_TYPE_XBOND_SINGLE_DEAL;
            }
            case 14: {
                return EXEC_MODE_TYPE_XBOND_ACTIVE_DEAL_HEDGE;
            }
            case 15: {
                return EXEC_MODE_TYPE_XBOND_SINGLE_DEAL_HEDGE;
            }
            case 16: {
                return EXEC_MODE_TYPE_XBOND_CUSTOM_BUY;
            }
            case 17: {
                return EXEC_MODE_TYPE_XBOND_CUSTOM_SELL;
            }
            case 18: {
                return EXEC_MODE_TYPE_XBOND_CUSTOM_MARKETMAKING;
            }
            case 19: {
                return EXEC_MODE_TYPE_XBOND_CUSTOM_HEGED;
            }
        }
        return EXEC_MODE_TYPE_UNDEFINED;
    }

    public static ExecModeType getEnumByValue(int value) {
        ExecModeType[] execModeTypeArray = ExecModeType.values();
        int n = execModeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecModeType type = execModeTypeArray[n2];
            if (value == type.getValue()) {
                return type;
            }
            ++n2;
        }
        return EXEC_MODE_TYPE_UNDEFINED;
    }

    @Override
    public String serialize() {
        return String.valueOf(this.getValue());
    }

    @Override
    public ExecModeType deserialize(String jsonEnum) {
        if (StringUtils.isNum((String)jsonEnum)) {
            return ExecModeType.getEnumByValue(Integer.parseInt(jsonEnum));
        }
        return Enum.valueOf(ExecModeType.class, jsonEnum);
    }
}

