/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.GetTransferPosReq;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.http.api.strategy.dto.ResetPosReq;
import cms.tmx.http.api.strategy.dto.ResetPosResp;
import cms.tmx.http.base.AccntLevel;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PositionServiceApi
extends HttpService {
    @Inject
    private HttpBaseApi baseApi;
    private static final Logger logger = LogManager.getLogger(PositionServiceApi.class);

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/position/PositionService";
    }

    public GetExtPositionsResp getPositions(GetPositionsReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("GetPositions", body);
        logger.info("\u65b0\u6846\u67b6\u6301\u4ed3\u67e5\u8be2\u7ed3\u679c" + respBody);
        GetExtPositionsResp resp = (GetExtPositionsResp)this.gson.fromJson(respBody, GetExtPositionsResp.class);
        this.checkStatus(resp.getStatus());
        LinkedList<Position> realPositions = new LinkedList<Position>();
        List<Positions> positions = resp.getPositions();
        for (Positions pos : positions) {
            List<PosStatistic> posStatistic = pos.getPosStatistic();
            for (PosStatistic posStatisctic : posStatistic) {
                Position position = new Position();
                position.setPosStatistic(posStatisctic);
                position.update((Object)pos);
                position.setExtraFields();
                position.transformQty();
                realPositions.add(position);
            }
        }
        resp.setRealPosition(realPositions);
        return resp;
    }

    public ResetPosResp resetPositions(ResetPosReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("ResetPos", body);
        ResetPosResp resp = (ResetPosResp)this.gson.fromJson(respBody, ResetPosResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public List<Position> getExtAccntCash(String extAccntId) throws IOException, MException {
        GetPositionsReq req = new GetPositionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("CCS");
        req.setAccntType(AccntType.ACCNT_TYPE_CASH);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
        LinkedList<String> list = new LinkedList<String>();
        list.add(extAccntId);
        req.setAccntId(list);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        String body = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetPositions", body);
        GetExtPositionsResp resp = (GetExtPositionsResp)this.gson.fromJson(respBody, GetExtPositionsResp.class);
        this.checkStatus(resp.getStatus());
        LinkedList<Position> realPositions = new LinkedList<Position>();
        List<Positions> positions = resp.getPositions();
        for (Positions pos : positions) {
            List<PosStatistic> posStatistic = pos.getPosStatistic();
            for (PosStatistic posStatisctic : posStatistic) {
                Position position = new Position();
                position.setPosStatistic(posStatisctic);
                position.update((Object)pos);
                position.transformQty();
                realPositions.add(position);
            }
        }
        return realPositions;
    }

    public GetExtPositionsResp getExtPositionList(GetPositionsReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        logger.info("\u878d\u8d44\u878d\u5238\u6301\u4ed3\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
        String respBody = this.doPost("GetPositions", json);
        logger.info("\u878d\u8d44\u878d\u5238\u6301\u4ed3\u7ed3\u679c" + respBody);
        GetExtPositionsResp resp = new GetExtPositionsResp();
        if (respBody == null) {
            return resp;
        }
        resp = (GetExtPositionsResp)this.gson.fromJson(respBody, GetExtPositionsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getPositions() == null) {
            return resp;
        }
        LinkedList<Position> list = new LinkedList<Position>();
        List<Positions> lists = resp.getPositions();
        for (Positions pos : lists) {
            List<PosStatistic> posStatistic = pos.getPosStatistic();
            Position position = new Position();
            position.setPosStatistic(posStatistic.get(0));
            position.update((Object)pos);
            list.add(position);
        }
        resp.setRealPosition(list);
        return resp;
    }

    public GetExtPositionsResp TransferPosition(GetTransferPosReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("TransferPos", body);
        logger.info("\u65b0\u6846\u67b6\u6301\u4ed3\u5212\u8f6c\u67e5\u8be2\u7ed3\u679c" + respBody);
        GetExtPositionsResp resp = (GetExtPositionsResp)this.gson.fromJson(respBody, GetExtPositionsResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }
}

