/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.data.GetExecutionsReq;
import cms.tmx.http.data.GetExecutionsResp;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OrderServiceNewApi
extends HttpService {
    @Inject
    private HttpBaseApi httpBase;
    private static final Logger logger = LogManager.getLogger(OrderServiceNewApi.class);

    @Override
    @PostConstruct
    protected void init() {
        super.init();
    }

    public GetOrdersResp getOrders(GetOrdersReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        logger.info("\u67e5\u8be2\u65b0\u6846\u67b6\u5916\u90e8\u8d44\u4ea7\u8bf7\u6c42:" + body);
        String respBody = this.doPostWithUrl("GetOrders", body, String.valueOf(this.url) + "/orders");
        logger.info("\u67e5\u8be2\u65b0\u6846\u67b6\u5916\u90e8\u8d44\u4ea7\u59d4\u6258:" + respBody);
        GetOrdersResp resp = (GetOrdersResp)this.gson.fromJson(respBody, GetOrdersResp.class);
        OpStatus status = new OpStatus();
        status.setStatus(resp.getCode());
        status.setReason(resp.getReason());
        this.checkStatus(status);
        return resp;
    }

    public GetExecutionsResp getNewDeals(GetExecutionsReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPostWithUrl("GetExecutions", body, String.valueOf(this.url) + "/executions");
        logger.info("\u67e5\u8be2\u65b0\u6846\u67b6\u5916\u90e8\u8d44\u4ea7\u59d4\u6258:" + respBody);
        GetExecutionsResp resp = (GetExecutionsResp)this.gson.fromJson(respBody, GetExecutionsResp.class);
        OpStatus status = new OpStatus();
        status.setStatus(resp.getCode());
        status.setReason(resp.getReason());
        this.checkStatus(status);
        return resp;
    }

    public OpStatus sgeOrderCancel(OrderCancelRequest newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPostWithUrl("sge order cancel", json, String.valueOf(this.url) + "/v1/trade/sge/actions/cancel");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }
}

