/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.api;

import cms.tmx.core.MException;
import cms.tmx.define.IErrorMsg;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.dto.DeleteCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.GetCtxSettingsResp;
import cms.tmx.http.api.strategy.dto.GetHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.GetHedgeTasksResp;
import cms.tmx.http.api.strategy.dto.NewCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.PauseContextReq;
import cms.tmx.http.api.strategy.dto.PauseContextResp;
import cms.tmx.http.api.strategy.dto.ResumeContextReq;
import cms.tmx.http.api.strategy.dto.ResumeContextResp;
import cms.tmx.http.api.strategy.dto.StartContextReq;
import cms.tmx.http.api.strategy.dto.StartContextResp;
import cms.tmx.http.api.strategy.dto.StartHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.StartHedgeTasksResp;
import cms.tmx.http.api.strategy.dto.StopContextReq;
import cms.tmx.http.api.strategy.dto.StopContextResp;
import cms.tmx.http.api.strategy.dto.StopHedgeTasksReq;
import cms.tmx.http.api.strategy.dto.StopHedgeTasksResp;
import cms.tmx.http.api.strategy.dto.TaskStatus;
import cms.tmx.http.api.strategy.dto.UpdateCtxSettingsReq;
import cms.tmx.http.api.strategy.dto.UpdateHedgeTaskReq;
import cms.tmx.http.utils.RespResult;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class NewStrategyServiceApi
extends HttpService {
    @Inject
    private IErrorMsg msg;

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/v1/xrepo/tactics/";
    }

    public OpStatus addStrategy(NewCtxSettingsReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPostWithUrl("\u7b56\u7565\u65b0\u589e", json, String.valueOf(this.url) + "algo/newalgo");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }

    public OpStatus updateStrategy(UpdateCtxSettingsReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("UpdateCtxSettings", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }

    public OpStatus deleteStrategy(DeleteCtxSettingsReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("DeleteCtxSettings", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
    }

    public StartContextResp startStrategy(StartContextReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("StartContext", json);
        StartContextResp resp = (StartContextResp)this.gson.fromJson(respBody, StartContextResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public StopContextResp stopStrategy(StopContextReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPostWithUrl("\u7b56\u7565\u505c\u6b62", json, String.valueOf(this.url) + "algo/stop");
        StopContextResp resp = (StopContextResp)this.gson.fromJson(respBody, StopContextResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public PauseContextResp pauseStrategy(PauseContextReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("PauseContext", json);
        PauseContextResp resp = (PauseContextResp)this.gson.fromJson(respBody, PauseContextResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public ResumeContextResp resumeStrategy(ResumeContextReq newReq) throws MException {
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("ResumeContext", json);
        ResumeContextResp resp = (ResumeContextResp)this.gson.fromJson(respBody, ResumeContextResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public GetCtxSettingsResp getStrategy(GetCtxSettingsReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPostWithUrl("\u7b56\u7565\u67e5\u8be2", body, String.valueOf(this.url) + "algo/query");
        GetCtxSettingsResp resp = (GetCtxSettingsResp)this.gson.fromJson(respBody, GetCtxSettingsResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public GetHedgeTasksResp getHedgeTasks(GetHedgeTasksReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetHedgeTasks", json);
        GetHedgeTasksResp resp = (GetHedgeTasksResp)this.gson.fromJson(respBody, GetHedgeTasksResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public void updateStrategy(UpdateHedgeTaskReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("UpdateHedgeTask", json);
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
    }

    public RespResult startHedgeTasks(StartHedgeTasksReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("StartHedgeTasks", json);
        StartHedgeTasksResp resp = (StartHedgeTasksResp)this.gson.fromJson(respBody, StartHedgeTasksResp.class);
        this.checkStatus(resp.getStatus());
        RespResult result = new RespResult();
        for (TaskStatus ctx : resp.getTaskStatus()) {
            if (ctx.getStatus() != 1) {
                String errorInfo = this.msg.getMsg(ctx.getStatus());
                if (errorInfo.isEmpty()) {
                    errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
                }
                result.incrementFailed(errorInfo);
                continue;
            }
            result.incrementSuccessed();
        }
        return result;
    }

    public RespResult stopHedgeTasks(StopHedgeTasksReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("StopHedgeTasks", json);
        StopHedgeTasksResp resp = (StopHedgeTasksResp)this.gson.fromJson(respBody, StopHedgeTasksResp.class);
        this.checkStatus(resp.getStatus());
        RespResult result = new RespResult();
        for (TaskStatus ctx : resp.getTaskStatus()) {
            if (ctx.getStatus() != 1) {
                String errorInfo = this.msg.getMsg(ctx.getStatus());
                if (errorInfo.isEmpty()) {
                    errorInfo = "\u9519\u8bef\u7801: " + ctx.getStatus();
                }
                result.incrementFailed(errorInfo);
                continue;
            }
            result.incrementSuccessed();
        }
        return result;
    }
}

