/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.strategy.api;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.strategy.dto.AlgoDetail;
import cms.tmx.http.api.strategy.dto.BaseAlgoOrderReq;
import cms.tmx.http.api.strategy.dto.CancelBaseAlgoRep;
import cms.tmx.http.api.strategy.dto.CancelBaseAlgoReq;
import cms.tmx.http.api.strategy.dto.ModifyBaseAlgoRep;
import cms.tmx.http.api.strategy.dto.ModifyBaseAlgoReq;
import cms.tmx.http.api.strategy.dto.QueryBaseAlgoReq;
import cms.tmx.http.api.strategy.dto.QueryEntrustReq;
import cms.tmx.http.api.strategy.dto.QueryEntrustRspInfo;
import cms.tmx.http.api.strategy.dto.QueryExecutionRep;
import cms.tmx.http.api.strategy.dto.QueryExecutionReq;
import cms.tmx.http.api.strategy.dto.QueryRspInfo;
import cms.tmx.http.api.strategy.dto.Response;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AlgoOrderServiceApi
extends HttpService {
    private static final Logger logger = LogManager.getLogger(AlgoOrderServiceApi.class);
    private static final int PAGESIZE = 10;

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/v1/algo/account/";
    }

    public List<AlgoDetail> algoQuery(QueryBaseAlgoReq request) throws IOException, MException {
        QueryRspInfo rep = new QueryRspInfo();
        ArrayList<AlgoDetail> data = new ArrayList<AlgoDetail>();
        List<Integer> rowRange = request.getReqInfo().getRowRange();
        rowRange.clear();
        rowRange.add(0, 0);
        rowRange.add(1, 9);
        do {
            String body;
            String respBody;
            if ((rep = (QueryRspInfo)this.gson.fromJson(respBody = this.doPostWithUrl("query", body = this.gson.toJson((Object)request), String.valueOf(this.url) + request.getReqInfo().getAccount() + "/algo_order/query"), QueryRspInfo.class)).getData() != null) {
                data.addAll(rep.getData());
            }
            request.getReqInfo().setAlgoOrderIdIndex(rep.getAlgoOrderIdIndex() != null ? rep.getAlgoOrderIdIndex() : "");
            rowRange.set(0, rowRange.get(0) + 10);
            rowRange.set(1, rowRange.get(1) + 10);
            this.checkCode(rep.getRetCode(), rep.getRetMsg());
        } while (!"".equals(rep.getAlgoOrderIdIndex()) && rep.getAlgoOrderIdIndex() != null);
        return data;
    }

    public CancelBaseAlgoRep algoModify(CancelBaseAlgoReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPostWithUrl("cancel", body, String.valueOf(this.url) + request.getReqInfo().getAccount() + "/algo_order/cancel");
        logger.info("\u64a4\u9500\u6bcd\u5355:" + respBody);
        CancelBaseAlgoRep resp = (CancelBaseAlgoRep)this.gson.fromJson(respBody, CancelBaseAlgoRep.class);
        return resp;
    }

    public QueryEntrustRspInfo algoEntrustQuery(QueryEntrustReq request) throws IOException, MException {
        QueryEntrustRspInfo resp = new QueryEntrustRspInfo();
        request.getReqInfo().setEntrustIdIndex("");
        List<Integer> rowRange = request.getReqInfo().getRowRange();
        rowRange.add(0, 0);
        rowRange.add(1, 9);
        do {
            String body = this.gson.toJson((Object)request);
            String respBody = this.doPostWithUrl("entrustQuery", body, String.valueOf(this.url) + request.getReqInfo().getAccount() + "/entrust/query");
            resp = (QueryEntrustRspInfo)this.gson.fromJson(respBody, QueryEntrustRspInfo.class);
            request.getReqInfo().setEntrustIdIndex(resp.getEntrustIdIndex());
            rowRange.set(0, rowRange.get(0) + 10);
            rowRange.set(1, rowRange.get(1) + 10);
            this.checkCode(resp.getRetCode(), resp.getRetMsg());
        } while ("".equals(resp.getEntrustIdIndex()));
        return resp;
    }

    public QueryExecutionRep algoExecutionQuery(QueryExecutionReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPostWithUrl("tradeQuery", body, String.valueOf(this.url) + "/trade/query");
        QueryExecutionRep resp = (QueryExecutionRep)this.gson.fromJson(respBody, QueryExecutionRep.class);
        this.checkCode(resp.getRspInfo().getRetCode(), resp.getRspInfo().getRetMsg());
        return resp;
    }

    public ModifyBaseAlgoRep algoModify(ModifyBaseAlgoReq request) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPostWithUrl("tradeQuery", body, String.valueOf(this.url) + "/algo_order/modify");
        logger.info("\u4fee\u6539\u6bcd\u5355:" + respBody);
        ModifyBaseAlgoRep resp = (ModifyBaseAlgoRep)this.gson.fromJson(respBody, ModifyBaseAlgoRep.class);
        this.checkCode(resp.getRetCode(), resp.getRetMsg());
        return resp;
    }

    private void checkCode(int code, String msg) throws MException {
        if (code != 0) {
            logger.error("\u878d\u5238\u7b97\u6cd5\u64cd\u4f5c\u5931\u8d25,\u9519\u8bef\u7801:" + code + ", \u539f\u56e0:" + msg);
            MException e = new MException(code, msg);
            throw e;
        }
        logger.info("\u878d\u5238\u7b97\u6cd5\u64cd\u4f5c\u6210\u529f");
    }

    public Response algoNew(BaseAlgoOrderReq request, String accntId) throws IOException, MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPostWithUrl("new", body, String.valueOf(this.url) + accntId + "/algo_order/new");
        logger.info("\u4e24\u878d\u4e0b\u5355\u56de\u62a5\u4fe1\u606f\uff1a" + respBody);
        Response resp = new Response();
        Gson gson = new Gson();
        resp = (Response)gson.fromJson(respBody, Response.class);
        if (StringUtils.isEmpty((String)resp.getAlgoOrderId())) {
            this.checkCode(resp.getRetCode(), resp.getRetMsg());
        }
        logger.info("\u4e24\u878d\u4e0b\u5355\u7b97\u6cd5\u6bcd\u5355\u53f7\uff1a" + resp.getAlgoOrderId());
        return resp;
    }
}

