/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api.pricingit;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.pricingit.GetSecurityListReq;
import cms.tmx.http.api.pricingit.GetSecurityListResp;
import cms.tmx.http.data.FundInfo;
import cms.tmx.http.data.GetFundsReq;
import cms.tmx.http.data.GetFundsResp;
import cms.tmx.http.data.GetInstrumentsReq;
import cms.tmx.http.data.GetInstrumentsResp;
import cms.tmx.http.data.GetIssuesReq;
import cms.tmx.http.data.GetIssuesResp;
import cms.tmx.http.data.GetStocksReq;
import cms.tmx.http.data.SecItem;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.http.security.dto.FutureInfo;
import cms.tmx.http.security.dto.GetFuturesReq;
import cms.tmx.http.security.dto.GetFuturesResp;
import cms.tmx.http.security.dto.Security;
import cms.tmx.http.security.dto.StockInfo;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SecurityServiceApi
extends HttpService {
    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/security/SecurityService";
    }

    public List<FundInfo> getStocks(GetStocksReq newReq) throws MException {
        newReq.setOpUser(this.httpBaseApi.getHttpOpUser());
        Page page = new Page();
        page.setStartRow(1);
        page.setPageSize(100);
        LinkedList<FundInfo> list = new LinkedList<FundInfo>();
        GetFundsResp resp = null;
        do {
            newReq.setPage(page);
            String json = this.gson.toJson((Object)newReq);
            String respBody = this.doPost("GetStocks", json);
            if (respBody == null) {
                OpStatus status = new OpStatus();
                status.setStatus(10);
                this.checkStatus(status);
            }
            resp = (GetFundsResp)this.gson.fromJson(respBody, GetFundsResp.class);
            page.setStartRow(resp.getPage().getStartRow());
            list.addAll(resp.getFund());
        } while (resp != null && !resp.getPage().isLast());
        this.checkStatus(resp.getStatus());
        return list;
    }

    public GetIssuesResp getIssues(GetIssuesReq request) throws MException {
        String body = this.gson.toJson((Object)request);
        String respBody = this.doPost("GetIssues", body);
        logger.info("\u67e5\u8be2\u65b0\u4e09\u677f\u8be2\u4ef7\u7533\u62a5\u4e1a\u52a1\u9759\u6001\u884c\u60c5:" + respBody);
        GetIssuesResp resp = (GetIssuesResp)this.gson.fromJson(respBody, GetIssuesResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public List<FundInfo> getFundsReq(GetFundsReq newReq) throws MException {
        newReq.setOpUser(this.httpBaseApi.getHttpOpUser());
        LinkedList<FundInfo> list = new LinkedList<FundInfo>();
        GetFundsResp resp = null;
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("GetFunds", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        resp = (GetFundsResp)this.gson.fromJson(respBody, GetFundsResp.class);
        list.addAll(resp.getFund());
        this.checkStatus(resp.getStatus());
        return list;
    }

    public List<StockInfo> getStocksReq(GetStocksReq newReq) throws MException {
        newReq.setOpUser(this.httpBaseApi.getHttpOpUser());
        LinkedList<StockInfo> list = new LinkedList<StockInfo>();
        GetFundsResp resp = null;
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("GetStocks", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        if ((resp = (GetFundsResp)this.gson.fromJson(respBody, GetFundsResp.class)).getStock() != null) {
            list.addAll(resp.getStock());
        }
        this.checkStatus(resp.getStatus());
        return list;
    }

    public List<SecItem> getInstruments(GetInstrumentsReq newReq) throws MException {
        newReq.setOpUser(this.httpBaseApi.getHttpOpUser());
        LinkedList<SecItem> list = new LinkedList<SecItem>();
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("GetInstruments", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        GetInstrumentsResp resp = (GetInstrumentsResp)this.gson.fromJson(respBody, GetInstrumentsResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getItem() != null) {
            list.addAll(resp.getItem());
        }
        return list;
    }

    public List<Security> getSecurityList(GetSecurityListReq newReq) throws MException {
        newReq.setOpUser(this.httpBaseApi.getHttpOpUser());
        LinkedList<Security> list = new LinkedList<Security>();
        String json = this.gson.toJson((Object)newReq);
        String respBody = this.doPost("GetSecurityList", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        GetSecurityListResp resp = (GetSecurityListResp)this.gson.fromJson(respBody, GetSecurityListResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getSecurity() != null) {
            list.addAll(resp.getSecurity());
        }
        return list;
    }

    public List<FutureInfo> getFutures(GetFuturesReq req) throws MException {
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setMarket("FUTURES");
        LinkedList<FutureInfo> list = new LinkedList<FutureInfo>();
        Fragment fragment = new Fragment();
        fragment.setSize(150);
        int offset = 1;
        GetFuturesResp resp = null;
        fragment.setOffset(offset);
        req.setFragment(fragment);
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetFutures", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            this.checkStatus(status);
        }
        resp = (GetFuturesResp)this.gson.fromJson(respBody, GetFuturesResp.class);
        this.checkStatus(resp.getStatus());
        if (resp.getFuture() != null) {
            list.addAll(resp.getFuture());
        }
        return list;
    }
}

