/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.http.api.TrustAllCerts;
import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public abstract class WebSocketService {
    protected transient Logger logger = LogManager.getLogger(this.getClass());
    @Inject
    protected MEventService es;
    protected Gson gson = new Gson();
    @Inject
    protected IBaseApi baseApi;
    @Inject
    protected ExecutorService exe;
    @Inject
    protected ScheduledExecutorService ses;
    @Inject
    protected MConfService cs;
    protected Future<?> future;
    protected String url = "";
    protected WebSocketClient socket = null;
    protected LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();

    protected abstract void onConnected();

    protected abstract void onDisConnected(int var1, String var2);

    protected abstract void onPush(String var1);

    protected abstract String getUrl();

    public void delayConnect() {
        if (!this.cs.getValueAsBool("newframe", false)) {
            return;
        }
        if (this.socket != null && !this.socket.isOpen()) {
            this.ses.schedule(() -> this.connect(), 3000L, TimeUnit.MILLISECONDS);
        }
    }

    protected void connect() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.url = this.getUrl();
            this.logger.error("websocket \u8fde\u63a5URL:" + this.url);
            if (this.url.startsWith("https")) {
                this.url = this.url.replace("https", "wss");
            } else if (this.url.startsWith("http")) {
                this.url = this.url.replace("http", "ws");
            }
            URI uri = new URI(this.url);
            this.socket = new WebSocket(uri);
            if (this.url.startsWith("https") || this.url.startsWith("wss")) {
                this.socket.setSocketFactory((SocketFactory)this.createSSLSocketFactory());
            }
            this.socket.connect();
            this.socket.setConnectionLostTimeout(0);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    @PreDestroy
    protected void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    protected SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            this.logger.error("ssl socket factory create error", (Throwable)e);
        }
        return ssfFactory;
    }

    class WebSocket
    extends WebSocketClient {
        public WebSocket(URI serverUri) {
            super(serverUri);
        }

        public void onMessage(String message) {
            WebSocketService.this.logger.info("\u6536\u5230\u63a8\u9001\uff1a" + message);
            WebSocketService.this.onPush(message);
        }

        public void onOpen(ServerHandshake handshake) {
            WebSocketService.this.onConnected();
        }

        public void onClose(int code, String reason, boolean remote) {
            WebSocketService.this.onDisConnected(code, reason);
            WebSocketService.this.delayConnect();
        }

        public void onError(Exception ex) {
            WebSocketService.this.logger.info("trade web socket onError " + ex);
        }
    }
}

