/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api;

import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ObInstrument
extends MxChgObj {
    private StringProperty symbol = new SimpleStringProperty("");
    private StringProperty secId = new SimpleStringProperty("");
    private StringProperty secIdSource = new SimpleStringProperty("");
    private StringProperty secType = new SimpleStringProperty("");
    private StringProperty secSubType = new SimpleStringProperty("");
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private StringProperty applId = new SimpleStringProperty("");
    private StringProperty marketIndicator = new SimpleStringProperty("");

    public ObInstrument() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.setMarket(node);
    }

    public void update(Object obj) {
        if (obj instanceof Instrument) {
            Instrument instrument = (Instrument)Instrument.class.cast(obj);
            this.update(instrument);
        } else if (obj instanceof ObInstrument) {
            ObInstrument instrument = (ObInstrument)((Object)ObInstrument.class.cast(obj));
            this.update(instrument);
        }
    }

    private void update(Instrument in) {
        this.setSymbol(in.getSymbol());
        this.setSecId(in.getSecurityId());
        this.setSecIdSource(in.getSecurityIdSource());
        this.setSecType(in.getSecurityType());
        this.setSecSubType(in.getSecuritySubType());
        this.getMarket().setRaw(in.getMarket() == null ? "" : in.getMarket());
        this.setApplId(in.getApplId());
        this.setMarketIndicator(MarketIndicator.getDesc(in.getMarketIndicator()));
    }

    private void update(ObInstrument in) {
        this.setSymbol(in.getSymbol());
        this.setSecId(in.getSecId());
        this.setSecIdSource(in.getSecIdSource());
        this.setSecType(in.getSecType());
        this.setSecSubType(in.getSecSubType());
        this.setMarket(in.getMarket());
        this.setApplId(in.getApplId());
        this.setMarketIndicator(in.getMarketIndicator());
    }

    public StringProperty symbolProperty() {
        return this.symbol;
    }

    public String getSymbol() {
        return (String)this.symbolProperty().get();
    }

    public void setSymbol(String symbol) {
        this.symbolProperty().set((Object)symbol);
    }

    public StringProperty secIdProperty() {
        return this.secId;
    }

    public String getSecId() {
        return (String)this.secIdProperty().get();
    }

    public void setSecId(String secId) {
        this.secIdProperty().set((Object)secId);
    }

    public StringProperty secIdSourceProperty() {
        return this.secIdSource;
    }

    public String getSecIdSource() {
        return (String)this.secIdSourceProperty().get();
    }

    public void setSecIdSource(String secIdSource) {
        this.secIdSourceProperty().set((Object)secIdSource);
    }

    public StringProperty secTypeProperty() {
        return this.secType;
    }

    public String getSecType() {
        return (String)this.secTypeProperty().get();
    }

    public void setSecType(String secType) {
        this.secTypeProperty().set((Object)secType);
    }

    public StringProperty secSubTypeProperty() {
        return this.secSubType;
    }

    public String getSecSubType() {
        return (String)this.secSubTypeProperty().get();
    }

    public void setSecSubType(String secSubType) {
        this.secSubTypeProperty().set((Object)secSubType);
    }

    public ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty applIdProperty() {
        return this.applId;
    }

    public final String getApplId() {
        return (String)this.applIdProperty().get();
    }

    public final void setApplId(String applId) {
        this.applIdProperty().set((Object)applId);
    }

    public final StringProperty marketIndicatorProperty() {
        return this.marketIndicator;
    }

    public final String getMarketIndicator() {
        return (String)this.marketIndicatorProperty().get();
    }

    public final void setMarketIndicator(String marketIndicator) {
        this.marketIndicatorProperty().set((Object)marketIndicator);
    }
}

