/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api;

import cms.tmx.core.MEvent;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.WebSocketService;
import cms.tmx.http.api.marketdata.dto.CalcResult;
import cms.tmx.http.api.marketdata.dto.Message;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class MarketDataCalcPush
extends WebSocketService {
    private static final Logger logger = LogManager.getLogger(MarketDataCalcPush.class);
    @Inject
    private MScheduler scheduler;

    @PostConstruct
    private void init() {
        this.scheduler.setInterval(10000);
        this.es.subscribe("token.done", event -> {
            this.connect();
            this.future = this.exe.submit(() -> this.threadPush());
        });
        this.es.subscribe("subscribe.market.data.calc", event -> this.subscribe(event));
        this.ses.scheduleAtFixedRate(() -> {
            if (this.socket != null && this.socket.isOpen()) {
                MEvent event = new MEvent();
                Message message = new Message();
                message.setTopic("heartbeat");
                event.setObj((Object)message);
                this.subscribe(event);
            }
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    private void subscribe(MEvent event) {
        if (this.socket == null || !this.socket.isOpen()) {
            return;
        }
        Object obj = event.getObj();
        if (obj instanceof Message) {
            Message message = (Message)obj;
            String json = this.gson.toJson((Object)message);
            this.socket.send(json);
            logger.error(String.valueOf(message.getTopic().equals("heartbeat") ? "\u4e1a\u52a1\u5fc3\u8df3" : "\u4ea4\u6613\u8ba2\u9605\uff1a") + json);
        }
    }

    @Override
    public void onPush(String ePush) {
        try {
            this.queue.put(ePush);
        }
        catch (InterruptedException e) {
            logger.error("push manager enqueue failed: queue size " + this.queue.size() + Thread.currentThread(), (Throwable)e);
        }
    }

    private void threadPush() {
        while (true) {
            String ePush = null;
            try {
                ePush = (String)this.queue.take();
                System.err.println("\u884c\u60c5\uff1a" + ePush);
                JsonObject jo = (JsonObject)this.gson.fromJson(ePush, JsonObject.class);
                CalcResult resp = (CalcResult)this.gson.fromJson((JsonElement)jo.get("data").getAsJsonObject(), CalcResult.class);
                MEvent event = new MEvent();
                event.setObj((Object)resp);
                this.es.postEvent("uap.push." + jo.get("topic").getAsString(), event);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("[push manager] dequeue failed: " + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.error("single push failed: " + Thread.currentThread() + ePush, (Throwable)e);
                continue;
            }
            break;
        }
    }

    @Override
    protected void onConnected() {
        this.scheduler.schedule(event -> {
            logger.error("marketdatacalc web socket connected ");
            this.es.postEvent("websocket.connected", null);
        });
    }

    @Override
    protected String getUrl() {
        return String.valueOf(this.cs.getValue("bond.forward.url", "")) + "/ws/mdcalc?token=" + this.baseApi.getToken();
    }

    @Override
    protected void onDisConnected(int code, String reason) {
        logger.error("marketdatacalc web socket disconnected " + code + "  " + reason);
    }
}

