/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.define.IErrorMsg;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.OpCode;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.TrustAllCerts;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpService {
    protected static final Logger logger = LogManager.getLogger(HttpService.class);
    protected String url = "";
    protected String baseUrl = "";
    private OkHttpClient client = this.buildClient();
    private OkHttpClient clientLong = this.buildClientLong();
    @Inject
    private IErrorMsg msg;
    @Inject
    protected MConfService cs;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    protected HttpBaseApi httpBaseApi;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected Gson gson = GsonFactory.getInstance();

    @PostConstruct
    protected void init() {
        this.url = this.cs.getValue("bond.forward.url", "");
        this.baseUrl = this.cs.getValue("bond.forward.url", "");
    }

    public String doPost(String method, String body) throws MException {
        Request request = this.buildRequest(method, body);
        return this.doRequest(request);
    }

    public String doPostXt(String actions, String body) throws MException {
        return this.doRequestXt(this.buildRequestXt(actions, body));
    }

    public String doPostLong(String method, String body) throws MException {
        Request request = this.buildRequest(method, body);
        return this.doRequestLong(request);
    }

    public String doGet(String url) throws MException {
        Request request = this.buildGetRequest(url);
        return this.doRequest(request);
    }

    private Request buildGetRequest(String url) {
        Request.Builder builder = new Request.Builder();
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        builder.url(url);
        builder.get();
        return builder.build();
    }

    private String doRequestXt(Request request) throws MException {
        Response response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                logger.info("\u8c03\u7528\u8fc5\u6295\u670d\u52a1\u63a5\u53e3\u6210\u529f,url:{}, \u8017\u65f6:{}", (Object)request.url().toString(), (Object)(System.currentTimeMillis() - start));
                String string = response.body().string();
                return string;
            }
            try {
                throw new MException(999, "\u8bf7\u6c42\u5931\u8d25 " + response.body().string());
            }
            catch (Exception e) {
                logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
                throw new MException(999, e.getMessage());
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    private String doRequest(Request request) throws MException {
        String reqStr = request.toString();
        if (reqStr.contains("token=")) {
            reqStr = reqStr.substring(0, reqStr.indexOf("token="));
        }
        logger.info(reqStr);
        Response response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.client.newCall(request).execute();
            logger.info(String.valueOf(request.url().toString()) + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if (response.isSuccessful()) {
                String respStr = response.body().string();
                if (respStr != null && respStr.length() > 1000) {
                    logger.info(String.valueOf(request.url().toString()) + "response\uff1a" + respStr.substring(0, 1000));
                } else {
                    logger.info(String.valueOf(request.url().toString()) + "response\uff1a" + respStr);
                }
                String string = respStr;
                return string;
            }
            try {
                throw new MException(999, "\u8bf7\u6c42\u5931\u8d25 " + response.body().string());
            }
            catch (IOException e) {
                logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
                throw new MException(999, e.getMessage());
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    private String doRequestLong(Request request) throws MException {
        String reqStr = request.toString();
        if (reqStr.contains("token=")) {
            reqStr = reqStr.substring(0, reqStr.indexOf("token="));
        }
        logger.info(reqStr);
        Response response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.clientLong.newCall(request).execute();
            logger.info(String.valueOf(request.url().toString()) + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            try {
                throw new MException(999, "\u8bf7\u6c42\u5931\u8d25 " + response.body().string());
            }
            catch (IOException e) {
                logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
                throw new MException(999, e.getMessage());
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    public String doPostWithUrl(String method, String body, String u) throws MException {
        Request request = this.buildRequestWithUrl(body, u);
        logger.info(request.toString());
        Response response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.client.newCall(request).execute();
            System.err.println(String.valueOf(method) + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            try {
                throw new MException(999, "\u8bf7\u6c42\u5931\u8d25  " + response.body().string());
            }
            catch (IOException e) {
                logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
                throw new MException(999, e.getMessage());
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    public String doDeleteWithUrl(String method, String body, String u) throws MException {
        Request request = this.buildDeleteRequestWithUrl(body, u);
        logger.info(request.toString());
        Response response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.client.newCall(request).execute();
            System.err.println(String.valueOf(method) + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            try {
                throw new MException(999, "\u8bf7\u6c42\u5931\u8d25 " + response.body().string());
            }
            catch (IOException e) {
                logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
                throw new MException(999, e.getMessage());
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    public String doPutWithUrl(String method, String body, String u) throws MException {
        Request request = this.buildPutRequestWithUrl(body, u);
        logger.info(request.toString());
        Response response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.client.newCall(request).execute();
            System.err.println(String.valueOf(method) + "\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            try {
                throw new MException(999, "\u8bf7\u6c42\u5931\u8d25 " + response.body().string());
            }
            catch (IOException e) {
                logger.error("http request error \u5f02\u5e38 " + request.url(), (Throwable)e);
                throw new MException(999, e.getMessage());
            }
        }
        finally {
            if (response != null && response.body() != null) {
                response.body().close();
            }
        }
    }

    private OkHttpClient buildClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS);
        builder.sslSocketFactory(this.createSSLSocketFactory());
        builder.hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        return builder.build();
    }

    private OkHttpClient buildClientLong() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS);
        builder.sslSocketFactory(this.createSSLSocketFactory());
        builder.hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier());
        return builder.build();
    }

    private SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {}
        return ssfFactory;
    }

    private Request buildRequest(String method, String body) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.valueOf(this.url) + "?action=" + method + "&token=" + this.baseApi.getToken());
        builder.addHeader("action", method);
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        builder.post(FormBody.create((MediaType)JSON, (String)body));
        return builder.build();
    }

    private Request buildRequestXt(String actions, String body) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.valueOf(this.url) + actions);
        builder.addHeader("Footprint", this.gson.toJson((Object)this.httpBaseApi.getXtOpUser()));
        builder.post(FormBody.create((MediaType)JSON, (String)body));
        return builder.build();
    }

    private Request buildRequestWithUrl(String body, String u) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.valueOf(u) + "?token=" + this.baseApi.getToken());
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        builder.post(FormBody.create((MediaType)JSON, (String)body));
        return builder.build();
    }

    private Request buildDeleteRequestWithUrl(String body, String u) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.valueOf(u) + "?token=" + this.baseApi.getToken());
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        builder.delete(FormBody.create((MediaType)JSON, (String)body));
        return builder.build();
    }

    private Request buildPutRequestWithUrl(String body, String u) {
        Request.Builder builder = new Request.Builder();
        builder.url(String.valueOf(u) + "?token=" + this.baseApi.getToken());
        if (!StringUtils.isEmpty((String)this.baseApi.getCmstmxToken())) {
            builder.addHeader("Authorization", "Bearer " + this.baseApi.getCmstmxToken());
        }
        builder.put(FormBody.create((MediaType)JSON, (String)body));
        return builder.build();
    }

    protected void checkOpCode(OpCode opCode) throws MException {
        if (opCode == null) {
            throw new MException(1, "\u65e0\u54cd\u5e94\u7801");
        }
        if (!opCode.isOk()) {
            throw new MException(1, opCode.getReason());
        }
    }

    protected void checkStatus(Object obj) throws MException {
        if (obj instanceof OpStatus) {
            OpStatus status = (OpStatus)OpStatus.class.cast(obj);
            int code = status.getStatus();
            if (code == 1 || code == 11) {
                return;
            }
            String reason = this.msg.getMsg(code);
            if (StringUtils.isEmpty((String)reason)) {
                reason = status.getReason();
            } else if (!StringUtils.isEmpty((String)status.getReason())) {
                reason = String.valueOf(reason) + "(" + status.getReason() + ")";
            }
            if (StringUtils.isEmpty((String)reason)) {
                reason = "\u9519\u8bef\u7801\uff1a" + code;
            }
            MException e = new MException(code, reason);
            e.getEvent().setObj((Object)status.getData());
            throw e;
        }
        if (obj instanceof OpStatus) {
            OpStatus status = (OpStatus)OpStatus.class.cast(obj);
            int code = status.getStatus();
            if (code == 1 || code == 11) {
                return;
            }
            String reason = this.msg.getMsg(code);
            if (StringUtils.isEmpty((String)reason)) {
                reason = status.getReason();
            }
            if (StringUtils.isEmpty((String)reason)) {
                reason = "\u9519\u8bef\u7801\uff1a" + code;
            }
            MException e = new MException(code, reason);
            e.getEvent().setObj((Object)status.getData());
            throw e;
        }
        throw new MException(999996, "no server response");
    }

    protected Page getPage(int startRow, int pageSize) {
        Page page = new Page();
        page.setStartRow(startRow);
        page.setPageSize(pageSize);
        return page;
    }

    private class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            logger.info(" " + hostname + " " + session);
            return true;
        }
    }
}

