/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api;

import cms.tmx.core.MEvent;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.WebSocketService;
import cms.tmx.http.api.WsStatus;
import cms.tmx.http.api.marketdata.dto.Message;
import cms.tmx.http.api.trade.dto.Meta;
import cms.tmx.http.api.trade.dto.Operator;
import cms.tmx.http.api.trade.dto.SubscribeReq;
import cms.tmx.http.api.trade.dto.Type;
import cms.tmx.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class HttpPushManager
extends WebSocketService {
    private static final Logger logger = LogManager.getLogger(HttpPushManager.class);
    @Inject
    private HttpBaseApi httpBaseApi;
    private WsStatus status;
    private List<String> list;
    private Set<String> setOtc;
    private List<String> listCfets;
    private List<String> listNeeq;
    private List<String> listHK;
    private Set<String> setHkOtc;
    @Inject
    private MScheduler scheduler;

    @PostConstruct
    private void init() {
        this.scheduler.setInterval(10000);
        this.es.subscribe("token.done", event -> {
            this.connect();
            if (StringUtils.isEmpty((String)this.baseApi.getPostId())) {
                this.es.subscribe("stage.after.login", e -> {
                    this.future = this.exe.submit(() -> {
                        logger.info("\u65b0\u6846\u67b6\u63a8\u9001\u5904\u7406\u7ebf\u7a0b\u542f\u52a8");
                        this.threadPush();
                    });
                });
            } else {
                this.future = this.exe.submit(() -> {
                    logger.info("\u65b0\u6846\u67b6\u63a8\u9001\u5904\u7406\u7ebf\u7a0b\u542f\u52a8");
                    this.threadPush();
                });
            }
            this.es.subscribe("margin.accnt.sub", e -> {
                this.list = (List)e.get((Object)"MARGIN_ACCNT");
                for (String id : this.list) {
                    this.subByAccntId(id);
                }
            });
            this.es.subscribe("otc.accnt.sub", e -> {
                this.setOtc = new HashSet<String>((List)e.get((Object)"OTC_ACCNT"));
                for (String id : this.setOtc) {
                    this.subByAccntId(id);
                }
            });
            this.es.subscribe("cfets.accnt.sub", e -> {
                this.listCfets = (List)e.get((Object)"CFETS_ACCNT");
                logger.error("cfets\u8d26\u53f7\u52a0\u8f7d\u5b8c\u6210, listCfets: " + this.listCfets + ", socket\uff1a" + this.socket);
                for (String id : this.listCfets) {
                    if (this.socket == null || !this.socket.isOpen()) continue;
                    this.subByAccntId(id);
                }
            });
            this.es.subscribe("neeq.accnt.sub", e -> {
                this.listNeeq = (List)e.get((Object)"NEEQ_ACCNT");
                logger.error("neeq\u8d26\u53f7\u52a0\u8f7d\u5b8c\u6210, listNeeq: " + this.listNeeq + ", socket\uff1a" + this.socket);
                for (String id : this.listNeeq) {
                    if (this.socket == null || !this.socket.isOpen()) continue;
                    this.subByAccntId(id);
                }
            });
            this.es.subscribe("stage.after.login", e -> {
                MEvent hkEvent = new MEvent();
                this.es.sendEvent("hk.accnt.get", hkEvent);
                List hkFundIds = (List)hkEvent.getObj(List.class);
                logger.error("HK\u8d26\u53f7\u52a0\u8f7d\u5b8c\u62101, hkFundIds: " + hkFundIds + ", socket\uff1a" + this.socket);
                for (String id : hkFundIds) {
                    if (this.socket == null || !this.socket.isOpen()) continue;
                    this.subByAccntId(id);
                }
            });
            this.es.subscribe("stage.after.login", e -> {
                MEvent sgeEvent = new MEvent();
                this.es.sendEvent("sge.accnt.get", sgeEvent);
                List sgeFundIds = (List)sgeEvent.getObj(List.class);
                logger.error("Sge\u8d26\u53f7\u52a0\u8f7d\u5b8c\u62101, sgeFundIds: " + sgeFundIds + ", socket\uff1a" + this.socket);
                for (String id : sgeFundIds) {
                    if (this.socket == null || !this.socket.isOpen()) continue;
                    this.subByAccntId(id);
                }
            });
        });
        this.ses.scheduleAtFixedRate(() -> {
            if (this.socket != null && this.socket.isOpen()) {
                this.sub("heartbeat", new Meta[0]);
            }
        }, 0L, 20L, TimeUnit.SECONDS);
    }

    private void subInstruction() {
        Meta insMeta = new Meta();
        insMeta.setKey("InsEvent");
        try {
            insMeta.setPostId(this.baseApi.getPostId());
            this.sub("ficc.instruction", Type.POST, insMeta);
        }
        catch (Exception e) {
            logger.error("\u65b0\u6846\u67b6\u6309\u804c\u4f4d\u8ba2\u9605\u51fa\u9519", (Throwable)e);
        }
        try {
            insMeta.setUserId(this.baseApi.getUserId());
            this.sub("ficc.instruction", Type.USER, insMeta);
        }
        catch (Exception e) {
            logger.error("\u65b0\u6846\u67b6\u6309\u7528\u6237\u8ba2\u9605\u51fa\u9519", (Throwable)e);
        }
        Meta lightingInsMeta = new Meta();
        try {
            lightingInsMeta.setUserId(this.baseApi.getUserId());
            this.sub("ficc.turbojet", Type.USER, lightingInsMeta);
        }
        catch (Exception e) {
            logger.error("\u6781\u901f\u6307\u4ee42.0\u6309\u7528\u6237\u8ba2\u9605\u51fa\u9519", (Throwable)e);
        }
    }

    private void subCounterParty() {
        Meta cMeta = new Meta();
        cMeta.setKey("CounterPartyEvent");
        try {
            cMeta.setPartyId("all");
            this.sub("ficc.counterparty", Type.PARTY, cMeta);
        }
        catch (Exception e) {
            logger.error("\u65b0\u6846\u67b6\u516c\u6709\u4ea4\u6613\u5bf9\u624b\u8ba2\u9605\u51fa\u9519", (Throwable)e);
        }
        Meta cMeta2 = new Meta();
        cMeta2.setKey("CounterPartyEvent");
        try {
            cMeta2.setPartyId(this.baseApi.getPartyId());
            this.sub("ficc.counterparty", Type.PARTY, cMeta2);
        }
        catch (Exception e) {
            logger.error("\u65b0\u6846\u67b6\u79c1\u6709\u673a\u6784\u4ea4\u6613\u5bf9\u624b\u8ba2\u9605\u51fa\u9519", (Throwable)e);
        }
    }

    private void subRefDataEvent() {
        Meta insMeta = new Meta();
        insMeta.setKey("SecurityEvent");
        insMeta.setUserId("all");
        try {
            this.sub("ficc.security", Type.USER, insMeta);
        }
        catch (Exception e) {
            logger.error("\u65b0\u6846\u67b6\u6309\u804c\u4f4d\u8ba2\u9605\u51fa\u9519", (Throwable)e);
        }
    }

    private void sub(String topic, Type type, Meta ... metas) {
        Message message = new Message();
        message.setTopic(topic);
        SubscribeReq req = new SubscribeReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setOpType(Operator.OP_SUBSCRIBE);
        req.setType(type);
        Meta[] metaArray = metas;
        int n = metas.length;
        int n2 = 0;
        while (n2 < n) {
            Meta meta = metaArray[n2];
            req.getMeta().add(meta);
            ++n2;
        }
        message.setData(req);
        String json = this.gson.toJson((Object)message);
        logger.error(String.valueOf(topic.isEmpty() ? "\u4e1a\u52a1\u5fc3\u8df3" : "\u4ea4\u6613\u8ba2\u9605\uff1a") + json);
        this.socket.send(json);
    }

    private void sub(String topic, Meta ... metas) {
        this.sub(topic, Type.DEFAULT, metas);
    }

    private void subByUserId() {
        this.subByUserId("ficc.strategy", "StrategyEvent");
        this.subByUserId("ficc.notice", "BondWarning");
        this.subByUserId("ficc.arbitrage.tbfevt", "ArbitrageEvent");
        this.subByUserId("ficc.arbitrage.tbfevt", "DeleteArbitrageEvent");
    }

    private void subByUserId(String topic, String key) {
        Message message = new Message();
        message.setTopic(topic);
        SubscribeReq req = new SubscribeReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setOpType(Operator.OP_SUBSCRIBE);
        req.setType(Type.USER);
        Meta meta = new Meta();
        meta.setUserId(this.httpBaseApi.getHttpOpUser().getUserId());
        meta.setKey(key);
        req.getMeta().add(meta);
        message.setData(req);
        String json = this.gson.toJson((Object)message);
        logger.error(String.valueOf(topic.isEmpty() ? "\u4e1a\u52a1\u5fc3\u8df3" : "\u4ea4\u6613\u8ba2\u9605\uff1a") + json);
        this.socket.send(json);
    }

    private void subByAccntId(String accntId) {
        this.sub("ficc.orderhub", new Meta("OrdEvent", accntId), new Meta("ExecEvent", accntId), new Meta("TransEvent", accntId));
        this.sub("ficc.trade", new Meta("TradeReport", accntId));
        this.sub("ficc.position", new Meta("PosEvent", accntId));
        this.sub("ficc.risk", new Meta("RiskEvent", accntId));
        this.sub("ficc.statement", new Meta("SOFPEvent", accntId));
        this.sub("ficc.statement", new Meta("ContractEvent", accntId));
        this.sub("ficc.complex", new Meta("ComplexEvent", accntId));
        this.sub("ficc.statement", new Meta("CreditAccountEvent", accntId));
        this.sub("ficc.statement", new Meta("CreditContractEvent", accntId));
        this.sub("ficc.position", new Meta("PositionEvent", accntId));
        this.sub("ficc.settlement", new Meta("SettlementReport", accntId));
    }

    @Override
    protected void onConnected() {
        logger.error("trade web socket connected ");
        this.subInstruction();
        this.subRefDataEvent();
        this.subByUserId();
        this.subCounterParty();
        logger.error("web socket\u8fde\u63a5, listCfets: " + this.listCfets + ", socket\uff1a" + this.socket);
        if (this.listCfets != null && !this.listCfets.isEmpty()) {
            for (String id : this.listCfets) {
                this.subByAccntId(id);
            }
        }
        if (this.list != null && !this.list.isEmpty()) {
            for (String id : this.list) {
                this.subByAccntId(id);
            }
        }
        if (this.listNeeq != null && !this.listNeeq.isEmpty()) {
            for (String id : this.listNeeq) {
                this.subByAccntId(id);
            }
        }
    }

    @Override
    protected void onDisConnected(int code, String reason) {
        logger.error("trade web socket disconnected " + code + "  " + reason);
    }

    @Override
    public void onPush(String message) {
        try {
            this.queue.put(message);
        }
        catch (InterruptedException e) {
            logger.error("push manager enqueue failed: queue size " + this.queue.size() + Thread.currentThread(), (Throwable)e);
        }
    }

    private void threadPush() {
        while (true) {
            String ePush = null;
            try {
                ePush = (String)this.queue.take();
                JsonElement je = new JsonParser().parse(ePush);
                JsonElement key = je.getAsJsonObject().get("key");
                JsonElement data = je.getAsJsonObject().get("data");
                MEvent event = new MEvent();
                if (data.isJsonObject()) {
                    event.setObj((Object)data.getAsJsonObject());
                } else if (data.isJsonArray()) {
                    event.setObj((Object)data.getAsJsonArray());
                } else if (data.isJsonPrimitive()) {
                    event.setObj((Object)data.getAsJsonPrimitive());
                }
                event.put((Object)"push_type", (Object)key.getAsString());
                this.es.postEvent("uap.push." + key.getAsString(), event);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("[push manager] dequeue failed: " + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException();
            }
            catch (Throwable e) {
                logger.error("single push failed: " + Thread.currentThread() + ePush, e);
                continue;
            }
            break;
        }
    }

    public WsStatus getStatus() {
        return this.status;
    }

    public void setStatus(WsStatus status) {
        this.status = status;
    }

    @Override
    protected String getUrl() {
        return String.valueOf(this.cs.getValue("bond.forward.url", "")) + "/ws/event?token=" + ("".equals(this.baseApi.getToken()) ? "12345" : this.baseApi.getToken());
    }
}

