/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.api;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.http.api.OpUser;
import cms.tmx.http.api.Page;
import cms.tmx.http.xt.XtOpUser;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HttpBaseApi {
    private static Logger logger = LogManager.getLogger(HttpBaseApi.class);
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private MConfService cs;
    @Inject
    private IBaseApi base;
    private static final String TERMINAL_TYPE = "PC";

    public IBaseApi getBaseApi() {
        return this.base;
    }

    public OpUser getHttpOpUser() {
        OpUser opUser = new OpUser();
        opUser.setPostId(this.base.getPostId());
        opUser.setUserId(this.base.getUserId());
        opUser.setPartyId(this.base.getPartyId());
        String ip = this.eCore.get((Object)"ip") == null ? "NA" : (String)this.eCore.get((Object)"ip");
        ip = CommUtils.getIP().equals(this.eCore.get((Object)"ip")) || this.eCore.get((Object)"ip") == null ? "NA" : (String)this.eCore.get((Object)"ip");
        String mac = CommUtils.getMAC();
        opUser.setIp(ip);
        opUser.setMac(mac);
        opUser.setLocalIp(CommUtils.getIP());
        opUser.setCpu(CommUtils.getCPUSerial());
        opUser.setPcn(CommUtils.getPCName());
        opUser.setPi(CommUtils.getPI());
        opUser.setVol(CommUtils.getVolNew());
        opUser.setOsv(CommUtils.getOSV());
        opUser.setTerminalType(TERMINAL_TYPE);
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)mac)) {
            logger.error("ip\u6216mac\u4e3a\u7a7a\uff1aip = " + ip + " | mac = " + mac);
        }
        opUser.setSn(CommUtils.getSerialNumber());
        opUser.setUuid(this.eCore.getStr("uuid"));
        opUser.setDatetime(DateTimeUtils.getTimeStamp());
        opUser.setPort("NA".equals(ip) ? "NA" : String.valueOf(this.eCore.getInt("port")));
        opUser.setTerminalName("T-master");
        opUser.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
        opUser.getProps().put("port", opUser.getPort());
        opUser.getProps().put("terminalName", opUser.getTerminalName());
        opUser.getProps().put("terminalVersion", opUser.getTerminalVersion());
        return opUser;
    }

    public Page getHttpDefPage() {
        Page page = new Page();
        page.setPageSize(150);
        page.setStartRow(1);
        return page;
    }

    public Page getXtHttpDefPage() {
        Page page = new Page();
        page.setPageSize(150);
        page.setPageNum(1);
        return page;
    }

    public XtOpUser getXtOpUser() {
        XtOpUser opUser = new XtOpUser();
        opUser.setPostId(this.base.getPostId());
        opUser.setUserId(this.base.getUserId());
        opUser.setPartyId(this.base.getPartyId());
        String ip = this.eCore.get((Object)"ip") == null ? "NA" : (String)this.eCore.get((Object)"ip");
        ip = CommUtils.getIP().equals(this.eCore.get((Object)"ip")) || this.eCore.get((Object)"ip") == null ? "NA" : (String)this.eCore.get((Object)"ip");
        String mac = CommUtils.getMAC();
        opUser.setIp(ip);
        opUser.setMac(mac);
        opUser.setLocalIp(CommUtils.getIP());
        opUser.setCpu(CommUtils.getCPUSerial());
        opUser.setPcn(CommUtils.getPCName());
        opUser.setPi(CommUtils.getPI());
        opUser.setVol(CommUtils.getVolNew());
        opUser.setOsv(CommUtils.getOSV());
        opUser.setTerminalType(TERMINAL_TYPE);
        if (StringUtils.isEmpty((String)ip) || StringUtils.isEmpty((String)mac)) {
            logger.error("ip\u6216mac\u4e3a\u7a7a\uff1aip = " + ip + " | mac = " + mac);
        }
        opUser.setSn(CommUtils.getSerialNumber());
        opUser.setUuid(this.eCore.getStr("uuid"));
        opUser.setDatetime(DateTimeUtils.getTimeStamp());
        opUser.setPort("NA".equals(ip) ? "NA" : String.valueOf(this.eCore.getInt("port")));
        opUser.setTerminalName("T-master");
        opUser.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
        return opUser;
    }
}

