/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.accnt;

import cms.tmx.core.MException;
import cms.tmx.http.accnt.dto.GetCashAccntResp;
import cms.tmx.http.accnt.dto.GetSecAccntResp;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import com.google.gson.Gson;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SgeAccountServiceApi
extends HttpService {
    private static final Logger logger = LogManager.getLogger(SgeAccountServiceApi.class);
    private Gson gson = new Gson();

    @Override
    @PostConstruct
    protected void init() {
        super.init();
    }

    public List<CashAccnt> getSgeExtCashAccnts() throws MException {
        String reqUrl = String.valueOf(this.url) + "/mgmt/api/v1/accounts/extFund/SGE?current=1&size=1000";
        String respBody = this.doGet(reqUrl);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return null;
        }
        GetCashAccntResp resp = (GetCashAccntResp)this.gson.fromJson(respBody, GetCashAccntResp.class);
        return resp.getRecords();
    }

    public List<SecAccnt> getSgeExtSecAccnts() throws MException {
        String reqUrl = String.valueOf(this.url) + "/mgmt/api/v1/accounts/extSecAccnt/SGE?current=1&size=1000";
        String respBody = this.doGet(reqUrl);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return null;
        }
        GetSecAccntResp resp = (GetSecAccntResp)this.gson.fromJson(respBody, GetSecAccntResp.class);
        return resp.getRecords();
    }
}

