/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.accnt;

import cms.tmx.core.MException;
import cms.tmx.http.accnt.AccntLoginReq;
import cms.tmx.http.accnt.AccntLogoutReq;
import cms.tmx.http.accnt.dto.GetAccntSessionReq;
import cms.tmx.http.accnt.dto.GetAccntSessionResp;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import com.google.gson.Gson;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarketServiceApi
extends HttpService {
    @Inject
    private HttpBaseApi baseApi;
    private Gson gson = new Gson();

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/market/MarketService";
    }

    public GetAccntSessionResp getAccountLoginStatus(List<String> accountIds) throws MException {
        GetAccntSessionReq req = new GetAccntSessionReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setAccntId(accountIds);
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetAccntSession", json);
        GetAccntSessionResp resp = new GetAccntSessionResp();
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            resp.setOpStatus(status);
            return resp;
        }
        resp = (GetAccntSessionResp)this.gson.fromJson(respBody, GetAccntSessionResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp;
    }

    public OpStatus loginAccnt(AccntLoginReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("AccntLogin", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }

    public OpStatus logoutAccnt(AccntLogoutReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("AccntLogout", json);
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }

    public GetAccntSessionResp getOtcAccountLoginStatus(List<String> accountIds) throws MException {
        GetAccntSessionReq req = new GetAccntSessionReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setAccntId(accountIds);
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPostWithUrl("getOtcAccountLoginStatus", json, String.valueOf(this.baseUrl) + "/router/xotc/accnt_session");
        GetAccntSessionResp resp = new GetAccntSessionResp();
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            resp.setOpStatus(status);
            return resp;
        }
        resp = (GetAccntSessionResp)this.gson.fromJson(respBody, GetAccntSessionResp.class);
        this.checkStatus(resp.getOpStatus());
        return resp;
    }

    public OpStatus otcLoginAccnt(AccntLoginReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPostWithUrl("AccntLogin", json, String.valueOf(this.baseUrl) + "/router/xotc/accnt_login");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }

    public OpStatus otcLogoutAccnt(AccntLogoutReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPostWithUrl("AccntLogout", json, String.valueOf(this.baseUrl) + "/router/xotc/accnt_logout");
        if (respBody == null) {
            OpStatus status = new OpStatus();
            status.setStatus(10);
            return status;
        }
        OpStatus status = (OpStatus)this.gson.fromJson(respBody, OpStatus.class);
        this.checkStatus(status);
        return status;
    }
}

