/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.http.accnt;

import cms.tmx.core.MException;
import cms.tmx.http.accnt.GetExtAccntsReq;
import cms.tmx.http.accnt.GetExtAccntsResp;
import cms.tmx.http.accnt.GetExtCashAccntsReq;
import cms.tmx.http.accnt.GetExtCashAccntsResp;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.Page;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.secaccnt.dto.GetExtSecAccntsReq;
import cms.tmx.http.secaccnt.dto.GetExtSecAccntsResp;
import cms.tmx.http.secaccnt.dto.GetSubSecAccntsReq;
import cms.tmx.http.secaccnt.dto.GetSubSecAccntsResp;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import com.google.gson.Gson;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AccountServiceApi
extends HttpService {
    private static final Logger logger = LogManager.getLogger(AccountServiceApi.class);
    private Gson gson = new Gson();

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/account/AccountService";
    }

    public GetExtAccntsResp getAccountList(GetExtAccntsReq getExtAccntsReq) throws MException {
        String json = this.gson.toJson((Object)getExtAccntsReq);
        String respBody = this.doPost("GetExtAccnts", json);
        if (respBody == null) {
            GetExtAccntsResp resp = new GetExtAccntsResp();
            OpStatus status = new OpStatus();
            status.setStatus(10);
            resp.setStatus(status);
            return resp;
        }
        GetExtAccntsResp resp = (GetExtAccntsResp)this.gson.fromJson(respBody, GetExtAccntsResp.class);
        this.checkStatus(resp.getStatus());
        return resp;
    }

    public List<CashAccnt> getExtCashAccnts(GetExtCashAccntsReq req) throws MException {
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetExtCashAccnts", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetExtCashAccntsResp resp = (GetExtCashAccntsResp)this.gson.fromJson(respBody, GetExtCashAccntsResp.class);
        status = resp.getStatus();
        this.checkStatus(status);
        return resp.getCashAccnt();
    }

    public List<SecAccnt> getExtSecAccnts(GetExtSecAccntsReq req) throws MException {
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        Page page = new Page();
        page.setStartRow(1);
        page.setPageSize(200);
        req.setPage(page);
        String json = this.gson.toJson((Object)req);
        logger.info(json);
        String respBody = this.doPost("GetExtSecAccnts", json);
        logger.info(respBody);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetExtSecAccntsResp resp = (GetExtSecAccntsResp)this.gson.fromJson(respBody, GetExtSecAccntsResp.class);
        status = resp.getStatus();
        this.checkStatus(status);
        return resp.getSecAccnt();
    }

    public List<SecAccnt> GetExtSecAccnts(GetExtSecAccntsReq req) throws MException {
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetExtSecAccnts", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetExtSecAccntsResp resp = (GetExtSecAccntsResp)this.gson.fromJson(respBody, GetExtSecAccntsResp.class);
        status = resp.getStatus();
        this.checkStatus(status);
        return resp.getSecAccnt();
    }

    public List<SecAccnt> getSubSecAccnts(GetSubSecAccntsReq req) throws MException {
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setPage(this.httpBaseApi.getHttpDefPage());
        String json = this.gson.toJson((Object)req);
        String respBody = this.doPost("GetSubSecAccnts", json);
        OpStatus status = null;
        if (respBody == null) {
            status = new OpStatus();
            status.setStatus(10);
        }
        GetSubSecAccntsResp resp = (GetSubSecAccntsResp)this.gson.fromJson(respBody, GetSubSecAccntsResp.class);
        status = resp.getStatus();
        this.checkStatus(status);
        return resp.getSecAccnt();
    }
}

