/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.jxb;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.jxb.IBrowserUpdater;
import cms.tmx.jxb.WebBrowserService;
import cms.tmx.jxb.WebLoginInterface;
import cms.tmx.jxb.WebMsgInterface;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserContext;
import com.teamdev.jxbrowser.chromium.BrowserContextParams;
import com.teamdev.jxbrowser.chromium.BrowserPreferences;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.JSValue;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class WebBrowserServiceImp
implements WebBrowserService {
    private static final Logger logger = LogManager.getLogger(WebBrowserServiceImp.class);
    @Inject
    private ExecutorService exe;
    private static final int QUEUE_SIZE = 1;
    private static final int QUOTE_QUEUE_SIZE = 2;
    private static final String BROWSER_DIR = "jxbrowserCache";
    private static final String XUN_DIR = "xunCache";
    private static final String REPORT_DIR = "reportCache";
    private static final String QUOTE_DIR = "quoteCache";
    private static final String ALGO_DIR = "algoCache";
    private static final String USER_DATA_DIR = "chromeUserData";
    private BrowserContext browserContext;
    private BrowserContext browserContextQuote;
    private BrowserContext browserContextAlgo;
    private BrowserContext browserContextXun;
    private BrowserContext browserContextReport;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="base.path")
    private String basePath;
    @Inject
    private MEventService es;
    private WebLoginInterface webLogin;
    private WebMsgInterface webMsg;
    private BlockingQueue<Browser> browserQueue = new LinkedBlockingQueue<Browser>(1);
    private BlockingQueue<Browser> browserQuoteQueue = new LinkedBlockingQueue<Browser>(2);
    private BlockingQueue<Browser> browserAlgoQueue = new LinkedBlockingQueue<Browser>(1);
    private BlockingQueue<Browser> browserXunQueue = new LinkedBlockingQueue<Browser>(1);
    private BlockingQueue<Browser> browserReportQueue = new LinkedBlockingQueue<Browser>(1);
    private BlockingQueue<Browser> browserCreditQueue = new LinkedBlockingQueue<Browser>(1);
    private List<WeakReference<IBrowserUpdater>> listUpdater = new LinkedList<WeakReference<IBrowserUpdater>>();

    @PostConstruct
    private void init() {
        long begin = System.currentTimeMillis();
        this.checkChromeUserDataDir();
        if (this.cs.getValueAsBool("web.debug", false)) {
            BrowserPreferences.setChromiumSwitches((String[])new String[]{"--remote-debugging-port=9222", "--allow-file-access-from-files"});
        } else {
            BrowserPreferences.setChromiumSwitches((String[])new String[]{"--allow-file-access-from-files"});
        }
        this.es.subscribe("application.start", event -> this.initQueue());
        logger.info("WebBrowserService init takes: " + (System.currentTimeMillis() - begin) + " ms");
        this.es.subscribe("change.style", event -> this.updateBrowserStyle(event));
    }

    private void initQueue() {
        try {
            this.initBrowserContext();
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316jxBrowser\u4e0a\u4e0b\u6587\u5931\u8d25", (Throwable)e);
        }
        this.exe.execute(() -> this.fillQueue());
        this.exe.execute(() -> this.fillQuoteQueue());
        this.exe.execute(() -> this.fillReportQueue());
        this.exe.execute(() -> this.fillCreditQueue());
    }

    private void initBrowserContext() {
        BrowserPreferences.setUserAgent((String)"JxBrowser");
        this.checkJxBrowserDir();
        BrowserContextParams params = new BrowserContextParams(this.getJxBrowserDir(BROWSER_DIR));
        this.browserContext = new BrowserContext(params);
        BrowserContextParams paramsQuote = new BrowserContextParams(this.getJxBrowserDir(QUOTE_DIR));
        this.browserContextQuote = new BrowserContext(paramsQuote);
        BrowserContextParams algo = new BrowserContextParams(this.getJxBrowserDir(ALGO_DIR));
        this.browserContextAlgo = new BrowserContext(algo);
        BrowserContextParams xun = new BrowserContextParams(this.getJxBrowserDir(XUN_DIR));
        this.browserContextXun = new BrowserContext(xun);
        BrowserContextParams report = new BrowserContextParams(this.getJxBrowserDir(REPORT_DIR));
        this.browserContextReport = new BrowserContext(report);
    }

    private synchronized void fillQuoteQueue() {
        while (this.browserQuoteQueue.remainingCapacity() > 0) {
            Browser browser = this.newQuoteBrowser();
            if (browser == null) {
                return;
            }
            if (this.browserQuoteQueue.offer(browser)) continue;
            if (browser != null) {
                this.destroyBrowser(browser);
            }
            return;
        }
    }

    private synchronized void fillQueue() {
        while (this.browserQueue.remainingCapacity() > 0) {
            Browser browser = this.newBrowser();
            if (browser == null) {
                return;
            }
            if (this.browserQueue.offer(browser)) continue;
            if (browser != null) {
                this.destroyBrowser(browser);
            }
            return;
        }
    }

    private synchronized void fillCreditQueue() {
        while (this.browserCreditQueue.remainingCapacity() > 0) {
            Browser browser = this.newCreditBrowser();
            if (browser == null) {
                return;
            }
            if (this.browserCreditQueue.offer(browser)) continue;
            if (browser != null) {
                this.destroyBrowser(browser);
            }
            return;
        }
    }

    private synchronized void fillXunQueue() {
        while (this.browserXunQueue.remainingCapacity() > 0) {
            Browser browser = this.newXunBrowser();
            if (browser == null) {
                return;
            }
            if (this.browserXunQueue.offer(browser)) continue;
            if (browser != null) {
                this.destroyBrowser(browser);
            }
            return;
        }
    }

    private synchronized void fillReportQueue() {
        while (this.browserReportQueue.remainingCapacity() > 0) {
            Browser browser = this.newReportBrowser();
            if (browser == null) {
                return;
            }
            if (this.browserReportQueue.offer(browser)) continue;
            if (browser != null) {
                this.destroyBrowser(browser);
            }
            return;
        }
    }

    private synchronized void fillAlgoQueue() {
        while (this.browserAlgoQueue.remainingCapacity() > 0) {
            Browser browser = this.newAlgoBrowser();
            if (browser == null) {
                return;
            }
            if (this.browserAlgoQueue.offer(browser)) continue;
            if (browser != null) {
                this.destroyBrowser(browser);
            }
            return;
        }
    }

    private synchronized Browser newBrowser() {
        Browser browser = this.initBrowser(this.browserContext);
        if (browser != null) {
            browser.loadURL(String.valueOf(this.basePath) + ("".equals(this.cs.getValue("web.base.url")) ? "/web/cms-web/client.html#/blank" : this.cs.getValue("web.base.url")));
        }
        return browser;
    }

    private synchronized Browser newXunBrowser() {
        Browser browser = this.initBrowser(this.browserContextXun);
        if (browser != null) {
            browser.loadURL(String.valueOf(this.basePath) + "/web/xuncetech-web/client.html#/blank");
        }
        return browser;
    }

    private synchronized Browser newReportBrowser() {
        Browser browser = this.initBrowser(this.browserContextReport);
        if (browser != null) {
            browser.loadURL(String.valueOf(this.basePath) + "/web/cms-report/client.html#/blank");
        }
        return browser;
    }

    private synchronized Browser newQuoteBrowser() {
        Browser browser = this.initBrowser(this.browserContextQuote);
        if (browser != null) {
            browser.loadURL(String.valueOf(this.basePath) + ("".equals(this.cs.getValue("quote.base.url")) ? "/web/quote/index.html" : this.cs.getValue("quote.base.url")) + "#/blank");
        }
        return browser;
    }

    private synchronized Browser newAlgoBrowser() {
        Browser browser = this.initBrowser(this.browserContextAlgo);
        if (browser != null) {
            browser.loadURL(String.valueOf(this.basePath) + ("".equals(this.cs.getValue("algo.base.url")) ? "/web/algo-web/index.html" : this.cs.getValue("algo.base.url")));
        }
        return browser;
    }

    private synchronized Browser newCreditBrowser() {
        Browser browser = this.initBrowser(null);
        if (browser != null) {
            browser.loadURL(String.valueOf(this.basePath) + "/web/credit-web/index.html#/blank");
        }
        return browser;
    }

    private Browser newCreditBrowser(Browser browser) {
        if (browser == null) {
            browser = new Browser();
        }
        MEvent event = new MEvent();
        this.es.sendEvent("getToken", event);
        browser.loadURL("http://10.254.249.52:82/Auth/RedirectUri?token=" + event.getStr("token") + "&uri=http://10.254.249.52:81/Flow/Instance/ProjectQuery.html");
        browser.getCookieStorage().setSessionCookie("http://10.254.249.52", "ASP.NET_SessionId", event.getStr("sessionId"), "10.254.249.52", "/", false, false);
        return browser;
    }

    private Browser initBrowser(BrowserContext browserCtxt) {
        FutureTask<Browser> getBrowser = new FutureTask<Browser>(() -> {
            logger.info("browser init begin");
            long b = System.currentTimeMillis();
            Browser browser = null;
            browser = browserCtxt == null ? new Browser(BrowserType.LIGHTWEIGHT) : new Browser(BrowserType.LIGHTWEIGHT, browserCtxt);
            this.injectWebLogin(browser);
            this.injectWebMsg(browser);
            BrowserPreferences preferences = browser.getPreferences();
            preferences.setTransparentBackground(true);
            browser.setPreferences(preferences);
            logger.info("browser init takes:" + (System.currentTimeMillis() - b));
            return browser;
        });
        this.exe.execute(getBrowser);
        try {
            return getBrowser.get(600L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("jxbrowser \u521d\u59cb\u5316\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    @PreDestroy
    private void destroy() {
        Browser br = (Browser)this.browserQueue.poll();
        while (br != null) {
            Browser browser = br;
            Thread t = new Thread(() -> {
                if (!browser.isDisposed()) {
                    browser.dispose();
                }
            });
            t.setDaemon(true);
            t.start();
            br = (Browser)this.browserQueue.poll();
        }
    }

    @Override
    public void destroyBrowser(Browser browser) {
        this.exe.execute(() -> {
            if (browser != null && !browser.isDisposed()) {
                logger.info("browser dispose =============>");
                browser.dispose();
                logger.info("browser dispose =============> seccess");
            }
        });
    }

    @Override
    public Browser createBrowser() {
        Browser browser = null;
        browser = (Browser)this.browserQueue.poll();
        if (browser == null) {
            browser = this.newBrowser();
        }
        if (browser != null) {
            this.updateBrowser(browser);
        }
        this.exe.execute(() -> this.fillQueue());
        return browser;
    }

    @Override
    public Browser createQuoteBrowser() {
        Browser browser = null;
        browser = (Browser)this.browserQuoteQueue.poll();
        if (browser == null) {
            browser = this.newQuoteBrowser();
        }
        this.exe.execute(() -> this.fillQuoteQueue());
        return browser;
    }

    @Override
    public Browser createAlgoBrowser() {
        Browser browser = null;
        browser = (Browser)this.browserAlgoQueue.poll();
        if (browser == null) {
            browser = this.newAlgoBrowser();
        }
        this.exe.execute(() -> this.fillAlgoQueue());
        return browser;
    }

    @Override
    public Browser createXunBrowser() {
        Browser browser = null;
        browser = (Browser)this.browserXunQueue.poll();
        if (browser == null) {
            browser = this.newXunBrowser();
        }
        if (browser != null) {
            this.updateBrowser(browser);
        }
        this.exe.execute(() -> this.fillXunQueue());
        return browser;
    }

    @Override
    public Browser createReportBrowser() {
        Browser browser = null;
        browser = (Browser)this.browserReportQueue.poll();
        if (browser == null) {
            browser = this.newReportBrowser();
        }
        if (browser != null) {
            this.updateBrowser(browser);
        }
        this.exe.execute(() -> this.fillReportQueue());
        return browser;
    }

    @Override
    public Browser createCreditBrowser() {
        Browser browser = null;
        browser = (Browser)this.browserCreditQueue.poll();
        if (browser == null) {
            browser = this.newCreditBrowser();
        }
        if (browser != null) {
            this.updateBrowser(browser);
        }
        this.exe.execute(() -> this.fillCreditQueue());
        return browser;
    }

    private void updateBrowser(Browser browser) {
        for (WeakReference<IBrowserUpdater> refUpdater : this.listUpdater) {
            IBrowserUpdater updater = (IBrowserUpdater)refUpdater.get();
            if (updater == null) continue;
            updater.update(browser);
        }
    }

    private void checkChromeUserDataDir() {
        try {
            File file = new File(this.getJxBrowserDir(USER_DATA_DIR));
            if (!file.exists()) {
                file.mkdir();
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664jxBrowser\u8de8\u57df\u7528\u6237\u4fe1\u606f\u6587\u4ef6\u5939\u51fa\u9519", (Throwable)e);
        }
    }

    private void checkJxBrowserDir() {
        try {
            File reportFile;
            File xunFile;
            File fileQuote;
            File file = new File(this.getJxBrowserDir(BROWSER_DIR));
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(fileQuote = new File(this.getJxBrowserDir(QUOTE_DIR))).exists()) {
                fileQuote.mkdir();
            }
            if (!(xunFile = new File(this.getJxBrowserDir(XUN_DIR))).exists()) {
                xunFile.mkdir();
            }
            if (!(reportFile = new File(this.getJxBrowserDir(REPORT_DIR))).exists()) {
                reportFile.mkdir();
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664jxBrowser\u7f13\u5b58\u6587\u4ef6\u5939\u51fa\u9519\uff08\u5df2\u6709\u7a0b\u5e8f\u8fd0\u884c\uff09", (Throwable)e);
        }
    }

    private String getJxBrowserDir(String dir) {
        return Paths.get(this.basePath, dir).toString();
    }

    @Override
    public void addBrowserUpdater(IBrowserUpdater updater) {
        this.listUpdater.add(new WeakReference<IBrowserUpdater>(updater));
    }

    public synchronized void update() {
        for (Browser browser : this.browserQueue) {
            this.injectWebLogin(browser);
            this.injectWebMsg(browser);
            this.updateBrowser(browser);
        }
    }

    private void updateBrowserStyle(MEvent event) {
        for (Browser browser : this.browserQueue) {
            browser.executeJavaScript("window.changeThemeStyle('" + event.getObj() + "')");
        }
    }

    private void injectWebLogin(Browser browser) {
        if (this.getWebLogin() != null) {
            JSValue window = browser.executeJavaScriptAndReturnValue("window");
            window.asObject().setProperty("LOGIN", (Object)this.getWebLogin());
        }
    }

    private void injectWebMsg(Browser browser) {
        if (this.getWebMsg() != null) {
            JSValue window = browser.executeJavaScriptAndReturnValue("window");
            window.asObject().setProperty("MSG_SERVICE", (Object)this.getWebMsg());
        }
    }

    public void injectServiceLogin(WebLoginInterface login) {
        this.webLogin = login;
    }

    public void injectServiceMsg(WebMsgInterface msg) {
        this.webMsg = msg;
    }

    @Override
    public WebLoginInterface getWebLogin() {
        return this.webLogin;
    }

    @Override
    public WebMsgInterface getWebMsg() {
        return this.webMsg;
    }
}

