/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.jxb;

import cms.tmx.control.utils.DirChooserUtil;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.jxb.WebBrowserService;
import cn.hutool.core.io.FileUtil;
import com.google.gson.Gson;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.ContextMenuHandler;
import com.teamdev.jxbrowser.chromium.ContextMenuParams;
import com.teamdev.jxbrowser.chromium.DownloadHandler;
import com.teamdev.jxbrowser.chromium.DownloadItem;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.PopupContainer;
import com.teamdev.jxbrowser.chromium.PopupHandler;
import com.teamdev.jxbrowser.chromium.PopupParams;
import com.teamdev.jxbrowser.chromium.events.DownloadEvent;
import com.teamdev.jxbrowser.chromium.events.DownloadListener;
import com.teamdev.jxbrowser.chromium.events.FailLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import com.teamdev.jxbrowser.chromium.events.NetError;
import com.teamdev.jxbrowser.chromium.events.ProvisionalLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextAdapter;
import com.teamdev.jxbrowser.chromium.events.ScriptContextEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextListener;
import com.teamdev.jxbrowser.chromium.events.StartLoadingEvent;
import com.teamdev.jxbrowser.chromium.javafx.BrowserView;
import com.teamdev.jxbrowser.chromium.javafx.DefaultPopupHandler;
import java.awt.Desktop;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;

public abstract class WebBrowserPart {
    protected BrowserType type = BrowserType.CMSWEB;
    private static final Logger logger = LogManager.getLogger(WebBrowserPart.class);
    private final Date start = new Date();
    protected Browser browser;
    protected BrowserView browserView;
    protected String url;
    protected Object injectObj;
    private Gson gson = new Gson();
    @Inject
    @Optional
    private BorderPane pane;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private WebBrowserService mis;
    @Inject
    private ExecutorService exe;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="base.path")
    private String basePath;
    private LoadAdapter loadLis = new LoadAdapter(){

        public void onStartLoadingFrame(StartLoadingEvent event) {
            if (event.isMainFrame()) {
                Date end = new Date();
                logger.info(String.valueOf(WebBrowserPart.this.url) + " Main frame has started loading" + "|" + (end.getTime() - WebBrowserPart.this.start.getTime()));
            }
        }

        public void onProvisionalLoadingFrame(ProvisionalLoadingEvent event) {
            if (event.isMainFrame()) {
                Date end = new Date();
                logger.info(String.valueOf(WebBrowserPart.this.url) + " Provisional load was committed for a frame" + "|" + (end.getTime() - WebBrowserPart.this.start.getTime()));
            }
        }

        public void onFinishLoadingFrame(FinishLoadingEvent event) {
            if (event.isMainFrame()) {
                Date end = new Date();
                logger.info("change hash after loading : window.location.hash='" + WebBrowserPart.this.url + "'");
                WebBrowserPart.this.injectWebInterFace();
                WebBrowserPart.this.changeHash();
                Timer timer = new Timer();
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        WebBrowserPart.this.changeHash();
                    }
                };
                timer.schedule(task, 1000L);
                WebBrowserPart.this.browser.removeLoadListener((LoadListener)WebBrowserPart.this.loadLis);
                WebBrowserPart.this.setCenter();
                WebBrowserPart.this.loadDone();
                logger.info(String.valueOf(WebBrowserPart.this.url) + " Main frame has finished loading" + "|" + (end.getTime() - WebBrowserPart.this.start.getTime()));
            }
        }

        public void onFailLoadingFrame(FailLoadingEvent event) {
            NetError errorCode = event.getErrorCode();
            if (event.isMainFrame()) {
                logger.info(String.valueOf(WebBrowserPart.this.url) + " Main frame has failed loading: " + errorCode);
            }
        }

        public void onDocumentLoadedInFrame(FrameLoadEvent event) {
            Date end = new Date();
            logger.info(String.valueOf(WebBrowserPart.this.url) + "Frame document is loaded." + "|" + (end.getTime() - WebBrowserPart.this.start.getTime()));
        }

        public void onDocumentLoadedInMainFrame(LoadEvent event) {
            Date end = new Date();
            logger.info(String.valueOf(WebBrowserPart.this.url) + " Main frame document is loaded." + "|" + (end.getTime() - WebBrowserPart.this.start.getTime()));
        }
    };

    @PreDestroy
    private void destroy() {
        if (this.pane != null) {
            this.pane.getChildren().clear();
        }
        this.mis.destroyBrowser(this.browser);
        logger.info("-------- WebBrowserPart: destroy called " + this.getClass().getSimpleName());
    }

    public void finalize() {
        logger.info("-------- WebBrowserPart: finalize called " + this.getClass().getSimpleName());
    }

    public BrowserView getBrowserView() {
        return this.browserView;
    }

    public void initialize(String path) {
        this.initialize(path, null);
    }

    public void setBorderPane(BorderPane borderPane) {
        this.pane = borderPane;
    }

    public void initialize() {
    }

    public void initialize(String path, Object injectObj) {
        this.url = path;
        logger.info(this.url);
        if (injectObj != null) {
            this.injectObj = injectObj;
        }
        this.browser = BrowserType.QUOTE.equals((Object)this.type) ? this.mis.createQuoteBrowser() : (BrowserType.ALGOWEB.equals((Object)this.type) ? this.mis.createAlgoBrowser() : (BrowserType.XUN.equals((Object)this.type) ? this.mis.createXunBrowser() : (BrowserType.REPORT.equals((Object)this.type) ? this.mis.createReportBrowser() : (BrowserType.CREDIT.equals((Object)this.type) ? this.mis.createCreditBrowser() : this.mis.createBrowser()))));
        this.initWebBrowser();
    }

    public void initWebBrowser() {
        if (this.browser == null) {
            return;
        }
        logger.info("=================>  web part");
        this.browserView = new BrowserView(this.browser);
        this.browserView.getStyleClass().add((Object)"browser-view");
        this.addJsContextHandler();
        this.addLoadHandler();
        this.addPopupHandler();
        this.addEventHandler();
        this.setDownloadHandler();
        if (this.cs.getValueAsBool("web.debug", false)) {
            this.setDebuggerConf();
        }
        this.setCenter();
        this.exe.execute(() -> {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                logger.error("WebBrowserPart InterruptedException" + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (!this.browser.isLoading()) {
                logger.info("change hash after sleep : window.location.hash='" + this.url + "'");
                this.injectWebInterFace();
                this.changeHash();
            } else {
                logger.info("loading================================\u300b" + this.url);
            }
        });
        System.err.println("================== load done");
    }

    private void injectWebInterFace() {
        JSValue window = this.browser.executeJavaScriptAndReturnValue("window");
        window.asObject().setProperty("LOGIN", (Object)this.mis.getWebLogin());
        window.asObject().setProperty("DIR_CHOOSER", (Object)new DirChooserUtil());
        window.asObject().setProperty("MSG_SERVICE", (Object)this.mis.getWebMsg());
        window.asObject().setProperty("OP_USER", (Object)this.gson.toJson(this.eCore.get((Object)"op_user")));
    }

    private void loadDone() {
        Date end = new Date();
        logger.info(String.format("%s load done, takes [%d] ms", this.getClass().getSimpleName(), end.getTime() - this.start.getTime()));
    }

    public void setCenter() {
        Platform.runLater(() -> {
            if (this.browserView != null && this.pane != null) {
                this.pane.setCenter((Node)this.browserView);
            }
        });
    }

    protected void addJsContextHandler() {
        this.browser.addScriptContextListener((ScriptContextListener)new ScriptContextAdapter(){

            public void onScriptContextCreated(ScriptContextEvent event) {
                WebBrowserPart.this.browser = event.getBrowser();
                JSValue window = WebBrowserPart.this.browser.executeJavaScriptAndReturnValue("window");
                if (WebBrowserPart.this.injectObj != null) {
                    window.asObject().setProperty("JAVA", WebBrowserPart.this.injectObj);
                }
            }

            public void onScriptContextDestroyed(ScriptContextEvent event) {
                logger.info("ScriptContext destroyed!");
            }
        });
    }

    protected void addLoadHandler() {
        this.browser.addLoadListener((LoadListener)this.loadLis);
    }

    public void removeLoadHandler() {
        this.browser.removeLoadListener((LoadListener)this.loadLis);
    }

    protected void addEventHandler() {
        this.browser.setContextMenuHandler((ContextMenuHandler)new MyContextMenuHandler((Pane)this.browserView));
        this.browser.addConsoleListener(event -> logger.debug("--Message From HTML--" + event.getLevel() + ": " + event.getMessage()));
    }

    protected void setDebuggerConf() {
        String remoteDebuggingURL = this.browser.getRemoteDebuggingURL();
        try {
            URI uri = new URI(remoteDebuggingURL);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            logger.error((Object)e, (Throwable)e);
        }
        logger.debug("remoteDebuggingURL: " + remoteDebuggingURL);
    }

    protected void addPopupHandler() {
        this.browser.setPopupHandler(new PopupHandler(){

            public PopupContainer handlePopup(PopupParams params) {
                String url = params.getURL();
                logger.info("\u65b0\u7a97\u53e3 URL\u5730\u5740\uff1a" + url);
                return null;
            }
        });
        this.browser.setPopupHandler((PopupHandler)new DefaultPopupHandler());
    }

    private void setDownloadHandler() {
        this.browser.setDownloadHandler(new DownloadHandler(){

            public boolean allowDownload(DownloadItem download) {
                download.addDownloadListener(new DownloadListener(){

                    public void onDownloadUpdated(DownloadEvent event) {
                        DownloadItem download = event.getDownloadItem();
                        if (download.isCompleted()) {
                            Platform.runLater(() -> {
                                File destinationFile = download.getDestinationFile();
                                try {
                                    try {
                                        ExcelUtils.saveFile(FileUtil.readBytes((File)destinationFile), destinationFile.getName());
                                    }
                                    catch (MException | Exception e) {
                                        logger.info((Object)e, e);
                                        destinationFile.delete();
                                    }
                                }
                                finally {
                                    destinationFile.delete();
                                }
                            });
                        }
                    }
                });
                logger.info("Destination file: " + download.getDestinationFile().getAbsolutePath());
                return true;
            }
        });
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void changeHash() {
        this.browser.executeJavaScript("window.location.hash='" + this.url + "'");
    }

    public BrowserType getType() {
        return this.type;
    }

    public void setType(BrowserType type) {
        this.type = type;
    }

    public static enum BrowserType {
        CMSWEB,
        QUOTE,
        ALGOWEB,
        XUN,
        REPORT,
        CREDIT;

    }

    protected static class MyContextMenuHandler
    implements ContextMenuHandler {
        private final Pane pane;

        private MyContextMenuHandler(Pane paren) {
            this.pane = paren;
        }

        public void showContextMenu(final ContextMenuParams params) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    this.createAndDisplayContextMenu(params);
                }
            });
        }

        private void createAndDisplayContextMenu(ContextMenuParams params) {
            final ContextMenu contextMenu = new ContextMenu();
            ((Node)this.pane.getChildren().get(0)).setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    contextMenu.hide();
                }
            });
            Point location = params.getLocation();
            Point2D screenLocation = this.pane.localToScreen((double)location.x, (double)location.y);
            contextMenu.show((Node)this.pane, screenLocation.getX(), screenLocation.getY());
        }
    }
}

