/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.jxb;

import cms.tmx.control.utils.DirChooserUtil;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.javafx.LoggerInterface;
import cms.tmx.jxb.WebBrowserService;
import com.google.gson.Gson;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.BrowserType;
import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.events.ScriptContextAdapter;
import com.teamdev.jxbrowser.chromium.events.ScriptContextEvent;
import com.teamdev.jxbrowser.chromium.events.ScriptContextListener;
import com.teamdev.jxbrowser.chromium.javafx.BrowserView;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;

public class FastWebBrowserPart
extends LoggerInterface {
    protected String path = "";
    @Inject
    @Optional
    protected BorderPane pane;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private WebBrowserService mis;
    @Inject
    protected MConfService cs;
    protected String url;
    protected Browser browser;
    protected final Date start = new Date();
    private static final Gson gson = new Gson();

    public void initialize(String path) {
        this.url = path;
        this.initWebBrowser();
    }

    public BorderPane getPane() {
        return this.pane;
    }

    public void setPane(BorderPane pane) {
        this.pane = pane;
    }

    protected String getPath(String priPath) {
        return "";
    }

    public void initWebBrowser() {
        Platform.runLater(() -> {
            this.logger.info("=================>  web part");
            this.browser = new Browser(BrowserType.LIGHTWEIGHT);
            BrowserView browserView = new BrowserView(this.browser);
            browserView.getStyleClass().add((Object)"browser-view");
            this.addJsContextHandler();
            this.browser.loadURL(this.path);
            if (this.cs.getValueAsBool("web.debug", false)) {
                this.setDebuggerConf();
            }
            this.pane.setCenter((Node)browserView);
        });
    }

    protected void setDebuggerConf() {
        String remoteDebuggingURL = this.browser.getRemoteDebuggingURL();
        try {
            URI uri = new URI(remoteDebuggingURL);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        this.logger.debug("remoteDebuggingURL: " + remoteDebuggingURL);
    }

    protected void addJsContextHandler() {
        this.browser.addScriptContextListener((ScriptContextListener)new ScriptContextAdapter(){

            public void onScriptContextCreated(ScriptContextEvent event) {
                FastWebBrowserPart.this.browser = event.getBrowser();
                JSValue window = FastWebBrowserPart.this.browser.executeJavaScriptAndReturnValue("window");
                window.asObject().setProperty("LOGIN", (Object)FastWebBrowserPart.this.mis.getWebLogin());
                window.asObject().setProperty("DIR_CHOOSER", (Object)new DirChooserUtil());
                window.asObject().setProperty("MSG_SERVICE", (Object)FastWebBrowserPart.this.mis.getWebMsg());
                window.asObject().setProperty("OP_USER", (Object)gson.toJson(FastWebBrowserPart.this.eCore.get((Object)"op_user")));
            }

            public void onScriptContextDestroyed(ScriptContextEvent event) {
                FastWebBrowserPart.this.logger.info("ScriptContext destroyed!");
            }
        });
    }

    public void setPath(String path) {
        this.path = path;
    }

    @PreDestroy
    private void destroy() {
        if (this.pane != null) {
            this.pane.getChildren().clear();
        }
        this.mis.destroyBrowser(this.browser);
        this.logger.info("-------- WebBrowserPart: destroy called " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }
}

