/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.utils;

import cms.tmx.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;

public class TextFieldUtils {
    private static final int DOUBLE_CLICKED = 2;
    private static final String POINT = ".";
    private static Pattern pattern = Pattern.compile("^[A-Za-z0-9]+([-_.][A-Za-z0-9]+)*@([A-Za-z0-9]+[-.])+[A-Za-z0-9]{2,5}$");

    public static void setLess100(TextField textField) {
        textField.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && textField.getText().length() > 0) {
                textField.setText(String.format("%1$,.2f", Double.parseDouble((String)textField.textProperty().get())));
            }
        });
        textField.textProperty().addListener((ob, old, now) -> {
            if (now == null || now.isEmpty()) {
                return;
            }
            if (!StringUtils.isLessThan100((String)now, (int)2)) {
                textField.setText(old);
            }
        });
    }

    public static void setLess100Million(TextField textField) {
        textField.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue() && textField.getText().length() > 0) {
                textField.setText(String.format("%1$,.2f", Double.parseDouble((String)textField.textProperty().get())));
            }
        });
        textField.textProperty().addListener((ob, old, now) -> {
            if (now == null || now.isEmpty()) {
                return;
            }
            if (!StringUtils.isLessThan10000M((String)now, (int)2)) {
                textField.setText(old);
            }
        });
    }

    public static boolean isEmail(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static BooleanBinding isNotEmpty(TextField textField) {
        return Bindings.createBooleanBinding(() -> !((String)textField.textProperty().get()).trim().isEmpty(), (Observable[])new Observable[]{textField.textProperty()});
    }

    public static BooleanBinding isPwd(TextField textField) {
        return Bindings.createBooleanBinding(() -> StringUtils.isPwd((String)((String)textField.textProperty().get())), (Observable[])new Observable[]{textField.textProperty()});
    }

    public static void selectPriceDecimal(TextField textField) {
        String text = textField.getText();
        int index = text.indexOf(POINT);
        textField.selectRange(index + 1, text.length());
    }

    public static void selectTwoPriceDecimal(TextField textField) {
        String text = textField.getText();
        if (text.contains(POINT)) {
            int index = text.indexOf(POINT);
            if (index + 2 < text.length()) {
                textField.selectRange(text.length() - 2, text.length());
            } else {
                textField.selectRange(text.length() - 3, text.length());
            }
        } else {
            textField.selectRange(text.length() - 2, text.length());
        }
    }

    public static void selectTwoOrAllPriceDecimal(boolean chooseAll, TextField textField) {
        if (chooseAll) {
            textField.selectAll();
        } else {
            String text = textField.getText();
            if (text.contains(POINT)) {
                int index = text.indexOf(POINT);
                if (index + 2 < text.length()) {
                    textField.selectRange(text.length() - 2, text.length());
                } else {
                    textField.selectRange(text.length() - 3, text.length());
                }
            } else {
                textField.selectRange(text.length() - 2, text.length());
            }
        }
    }

    public static void selectTwoOrNoPriceDecimal(int chooseAll, TextField textField) {
        switch (chooseAll) {
            case 1: {
                textField.selectAll();
                break;
            }
            case 2: {
                String text = textField.getText();
                if (text.contains(POINT)) {
                    int index = text.indexOf(POINT);
                    if (index + 2 < text.length()) {
                        textField.selectRange(text.length() - 2, text.length());
                        break;
                    }
                    textField.selectRange(text.length() - 3, text.length());
                    break;
                }
                textField.selectRange(text.length() - 2, text.length());
                break;
            }
            case 3: {
                int index;
                String text1 = textField.getText();
                if (!text1.contains(POINT) || (index = text1.indexOf(POINT)) <= 0) break;
                textField.selectRange(index + 1, text1.length());
                break;
            }
        }
    }

    public static void showMagnitude(Label label, TextField field) {
        field.textProperty().addListener((ob, oldV, newV) -> {
            if (newV != null && !"".equals(newV) && !"".equals(StringUtils.getMagnitude((String)newV))) {
                label.setText(StringUtils.getMagnitude((String)newV));
            } else {
                label.setText("");
            }
        });
    }

    public static void selectDecimal(TextField textField) {
        String text = textField.getText();
        int index = text.indexOf(POINT);
        textField.selectRange(index + 1, text.length());
    }

    public static BooleanBinding isAccntPwd(TextField textField) {
        return Bindings.createBooleanBinding(() -> StringUtils.isAccntPwd((String)((String)textField.textProperty().get())), (Observable[])new Observable[]{textField.textProperty()});
    }
}

