/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class MailExcelUtils {
    public static byte[] createExcel(HSSFWorkbook wb) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] bt = null;
        try {
            try {
                wb.write((OutputStream)os);
                wb.close();
                bt = os.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (wb != null) {
                        wb.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (wb != null) {
                    wb.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bt;
    }

    public static HSSFWorkbook getHSSFWorkbook(String sheetName, String[] titile, Object[][] values, HSSFWorkbook wb) {
        if (wb == null) {
            wb = new HSSFWorkbook();
        }
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        HSSFDataFormat df = wb.createDataFormat();
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setDataFormat(df.getFormat("@"));
        cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        HSSFDataFormat dfNumber = wb.createDataFormat();
        HSSFCellStyle cellStyleNumber = wb.createCellStyle();
        cellStyleNumber.setDataFormat(dfNumber.getFormat("0.00_ "));
        cellStyleNumber.setAlignment(HorizontalAlignment.LEFT);
        int i = 0;
        while (i < values.length) {
            row = sheet.createRow(i);
            int j = 0;
            while (j < values[i].length) {
                if (values[i][j] != null) {
                    HSSFCell c;
                    if (values[i][j] instanceof Number) {
                        c = row.createCell(j);
                        c.setCellType(CellType.STRING);
                        double d = ((Number)values[i][j]).doubleValue();
                        c.setCellStyle((CellStyle)cellStyleNumber);
                        if (d > Double.MAX_VALUE) {
                            c.setCellValue(values[i][j].toString());
                        } else {
                            c.setCellValue(d);
                            c.setCellType(CellType.NUMERIC);
                        }
                    } else {
                        c = row.createCell(j);
                        c.setCellStyle((CellStyle)cellStyle);
                        c.setCellValue(values[i][j].toString());
                    }
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < values[0].length) {
            sheet.setColumnWidth(j, 3840);
            ++j;
        }
        return wb;
    }

    public static <T> HSSFWorkbook writeExcel(TableView<T> table, String name, HSSFWorkbook wb, int sheetIndex) {
        return MailExcelUtils.writeExcel(table, name, 0, table.getColumns().size() - 1, wb, sheetIndex);
    }

    public static <T> HSSFWorkbook writeExcel(TableView<T> table, String name, int from, int to, HSSFWorkbook workbook, int sheetIndex) {
        HSSFDataFormat df = workbook.createDataFormat();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setDataFormat(df.getFormat("@"));
        int n = 0;
        while (n <= table.getItems().size() / 60000) {
            HSSFSheet spreadsheet = workbook.createSheet(String.valueOf(name) + (n + 1));
            HSSFRow row = spreadsheet.createRow(0);
            int invisible = 0;
            int j = from;
            while (j < to + 1) {
                if (!((TableColumn)table.getColumns().get(j)).isVisible()) {
                    ++invisible;
                } else {
                    row.createCell(j - from - invisible).setCellValue(((TableColumn)table.getColumns().get(j)).getText());
                }
                ++j;
            }
            int start = n * 60000;
            int end = Math.min(table.getItems().size(), (n + 1) * 60000);
            List list2 = table.getItems().subList(start, end);
            int i = 1;
            while (i < list2.size() + 1) {
                row = spreadsheet.createRow(i);
                int invisible1 = 0;
                int j2 = from;
                while (j2 < to + 1) {
                    if (!((TableColumn)table.getColumns().get(j2)).isVisible()) {
                        ++invisible1;
                    } else {
                        Object ob = ((TableColumn)table.getColumns().get(j2)).getCellData(start + i - 1);
                        if (!(ob == null || ob.getClass().equals(Button.class) || ob.getClass().equals(ComboBox.class) || ob.getClass().equals(ArrayList.class) || ob.getClass().equals(HBox.class) || ob.getClass().equals(Label.class) || ob instanceof Boolean)) {
                            HSSFCell c;
                            if (ob instanceof Number) {
                                c = row.createCell(j2 - from - invisible1);
                                c.setCellType(CellType.STRING);
                                double d = ((Number)ob).doubleValue();
                                if (d > Double.MAX_VALUE) {
                                    c.setCellValue(ob.toString());
                                } else {
                                    c.setCellValue(d);
                                    c.setCellType(CellType.NUMERIC);
                                }
                            } else {
                                c = row.createCell(j2 - from - invisible1);
                                c.setCellStyle((CellStyle)cellStyle);
                                c.setCellValue(ob.toString());
                            }
                        }
                    }
                    ++j2;
                }
                ++i;
            }
            ++n;
        }
        return workbook;
    }
}

