/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.utils;

import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportExcel {
    private int totalRows = 0;
    private int totalCells = 0;
    private static String errorInfo;
    private static ImportExcel _instance;

    public static ImportExcel getInstance() {
        if (_instance == null) {
            _instance = new ImportExcel();
        }
        return _instance;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getTotalCells() {
        return this.totalCells;
    }

    public String getErrorInfo() {
        return errorInfo;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !ImportExcel.isExcel2003(filePath) && !ImportExcel.isExcel2007(filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file != null && file.exists();
    }

    public static List<List<String>> read(String filePath) throws Exception {
        List<List<String>> dataLst = new ArrayList<List<String>>();
        InputStream is = null;
        try {
            if (!ImportExcel.validateExcel(filePath)) {
                return null;
            }
            try {
                File file = new File(filePath);
                is = new FileInputStream(file);
                dataLst = ImportExcel.read(is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    is = null;
                    e.printStackTrace();
                }
            }
        }
        return dataLst;
    }

    public static List<List<String>> read(InputStream inputStream) throws Exception {
        List<List<String>> dataLst = null;
        try {
            Workbook wb = null;
            wb = WorkbookFactory.create((InputStream)inputStream);
            dataLst = ImportExcel.read(wb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dataLst;
    }

    private static List<List<String>> read(Workbook wb) throws Exception {
        ArrayList<List<String>> dataList = new ArrayList<List<String>>();
        int sheetIndex = wb.getNumberOfSheets();
        int i = 0;
        while (i < sheetIndex) {
            Sheet sheet = wb.getSheetAt(i);
            ImportExcel.getInstance().totalRows = sheet.getLastRowNum() + 1;
            if (ImportExcel.getInstance().totalRows >= 1 && sheet.getRow(0) != null) {
                ImportExcel.getInstance().totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
            }
            int r = 0;
            while (r < ImportExcel.getInstance().totalRows) {
                Row row = sheet.getRow(r);
                ArrayList<String> rowList = new ArrayList<String>();
                if (row == null || row.getFirstCellNum() < 0) {
                    dataList.add(new ArrayList());
                } else {
                    int c = 0;
                    while (c < row.getLastCellNum()) {
                        Cell cell = row.getCell(c);
                        String cellValue = "";
                        if (cell != null) {
                            switch (cell.getCellType()) {
                                case 0: {
                                    cellValue = StringUtils.formatDouble((Double)cell.getNumericCellValue());
                                    if (StringUtils.isEmpty((String)cellValue)) break;
                                    cellValue = cellValue.replaceAll(",", "");
                                    break;
                                }
                                case 1: {
                                    cellValue = cell.getStringCellValue();
                                    break;
                                }
                                case 4: {
                                    cellValue = String.valueOf(cell.getBooleanCellValue());
                                    break;
                                }
                                case 2: {
                                    cellValue = String.valueOf(cell.getCellFormula());
                                    break;
                                }
                                case 3: {
                                    cellValue = "";
                                    break;
                                }
                                case 5: {
                                    cellValue = "\u975e\u6cd5\u5b57\u7b26";
                                    break;
                                }
                                default: {
                                    cellValue = "\u672a\u77e5\u7c7b\u578b";
                                }
                            }
                        }
                        rowList.add(cellValue);
                        ++c;
                    }
                    dataList.add(rowList);
                }
                ++r;
            }
            ++i;
        }
        return dataList;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

