/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.utils;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelUtils {
    private static Map<String, FileChooser.ExtensionFilter> filter = new HashMap<String, FileChooser.ExtensionFilter>();
    public static final String ALL = "ALL";
    public static final String TXT = "TXT";
    public static final String XLS = "XLS";
    public static final String XLSX = "XLSX";
    public static final String DOC = "DOC";
    public static final String DOCX = "DOCX";
    public static final String PPT = "PPT";
    public static final String PDF = "PDF";
    public static final String JPG = "JPG";
    public static final String PNG = "PNG";
    public static final String ZIP = "ZIP";
    public static final String CSV = "CSV";
    public static final String RAR = "RAR";
    private static final Logger logger;

    static {
        filter.put(ALL, new FileChooser.ExtensionFilter(ALL, new String[]{"*.*"}));
        filter.put(TXT, new FileChooser.ExtensionFilter(TXT, new String[]{"*.txt"}));
        filter.put(XLS, new FileChooser.ExtensionFilter(XLS, new String[]{"*.xls"}));
        filter.put(XLSX, new FileChooser.ExtensionFilter(XLSX, new String[]{"*.xlsx"}));
        filter.put(DOC, new FileChooser.ExtensionFilter(DOC, new String[]{"*.doc"}));
        filter.put(DOCX, new FileChooser.ExtensionFilter(DOCX, new String[]{"*.docx"}));
        filter.put(PPT, new FileChooser.ExtensionFilter(PPT, new String[]{"*.ppt"}));
        filter.put(PDF, new FileChooser.ExtensionFilter(PDF, new String[]{"*.pdf"}));
        filter.put(JPG, new FileChooser.ExtensionFilter(JPG, new String[]{"*.jpg"}));
        filter.put(PNG, new FileChooser.ExtensionFilter(PNG, new String[]{"*.png"}));
        filter.put(ZIP, new FileChooser.ExtensionFilter(ZIP, new String[]{"*.zip"}));
        filter.put(CSV, new FileChooser.ExtensionFilter(CSV, new String[]{"*.csv"}));
        filter.put(RAR, new FileChooser.ExtensionFilter(RAR, new String[]{"*.rar"}));
        logger = LogManager.getLogger(ExcelUtils.class);
    }

    public static <T> void writeExcel(TableView<T> table, String name) throws Exception {
        ExcelUtils.writeExcel(table, name, 0, table.getColumns().size() - 1);
    }

    public static <T> void writeExcel(TableView<T> table, List<T> list, Map<String, String> reactMap, File file) throws Exception {
        boolean isArrayList = list instanceof ArrayList;
        if (!isArrayList) {
            list = new ArrayList<T>(list);
        }
        ExcelUtils.writeExcel(table, 0, table.getColumns().size() - 1, list, reactMap, file);
    }

    private static <T> void writeExcel(TableView<T> table, int from, int to, List<T> list, Map<String, String> reactMap, File file) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat df = workbook.createDataFormat();
        cellStyle.setDataFormat(df.getFormat("@"));
        int n = 0;
        while (n <= list.size() / 60000) {
            HSSFSheet spreadsheet = workbook.createSheet("sheet" + n);
            HSSFRow row = spreadsheet.createRow(0);
            int invisible = 0;
            int j = from;
            while (j < to + 1) {
                if (!((TableColumn)table.getColumns().get(j)).isVisible()) {
                    ++invisible;
                } else {
                    row.createCell(j - from - invisible).setCellValue(((TableColumn)table.getColumns().get(j)).getText());
                }
                ++j;
            }
            int start = n * 60000;
            int end = Math.min(list.size(), (n + 1) * 60000);
            List<T> list2 = list.subList(start, end);
            int i = 1;
            while (i < list2.size() + 1) {
                row = spreadsheet.createRow(i);
                ExcelUtils.creatCell(table, from, to, list2, reactMap, cellStyle, row, i);
                ++i;
            }
            ++n;
        }
        ExcelUtils.outPutFile(workbook, file);
    }

    private static <T> void creatCell(TableView<T> table, int from, int to, List<T> list, Map<String, String> reactMap, HSSFCellStyle cellStyle, HSSFRow row, int i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int invisible = 0;
        int j = from;
        while (j < to + 1) {
            block16: {
                if (!((TableColumn)table.getColumns().get(j)).isVisible()) {
                    ++invisible;
                } else {
                    String colId = ((TableColumn)table.getColumns().get(j)).getId();
                    HSSFCell cell = row.createCell(j - from - invisible);
                    cell.setCellStyle((CellStyle)cellStyle);
                    cell.setCellType(CellType.STRING);
                    if (reactMap.get(colId) == null) {
                        cell.setCellValue((double)i);
                    } else if (reactMap.get(colId).isEmpty()) {
                        cell.setCellValue("");
                    } else {
                        Method method = null;
                        try {
                            method = list.get(i - 1).getClass().getMethod("get" + reactMap.get(colId), new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            cell.setCellValue("");
                            break block16;
                        }
                        catch (SecurityException e) {
                            cell.setCellValue("");
                            e.printStackTrace();
                            break block16;
                        }
                        Object content = method.invoke(list.get(i - 1), new Object[0]);
                        if (content == null) {
                            cell.setCellValue("");
                        } else if (content instanceof Number) {
                            Number num = (Number)content;
                            if (num.doubleValue() > Double.MAX_VALUE) {
                                cell.setCellValue(content.toString());
                            } else {
                                BigDecimal decimal = new BigDecimal(String.valueOf(content));
                                cell.setCellValue(decimal.doubleValue());
                                cell.setCellType(CellType.NUMERIC);
                            }
                        } else {
                            cell.setCellValue(content.toString());
                        }
                    }
                }
            }
            ++j;
        }
    }

    public static <T> void writeTwoHeadExcel(TableView<T> table, String name) throws Exception {
        ExcelUtils.writeTwoHeadExcel(table, name, 0, 0);
    }

    public static <T> void writeHisTwoHeadExcel(TableView<T> table, List<T> list, Map<String, String> reactMap, File file) throws Exception {
        ExcelUtils.writeTwoHeadExcel(table, new ArrayList<T>(list), reactMap, file);
    }

    private static <T> void writeTwoHeadExcel(TableView<T> table, List<T> list, Map<String, String> reactMap, File file) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        HSSFDataFormat df = workbook.createDataFormat();
        cellStyle2.setDataFormat(df.getFormat("@"));
        int n = 0;
        while (n <= list.size() / 60000) {
            boolean flag = true;
            HSSFSheet spreadsheet = workbook.createSheet("sheet" + n);
            HSSFRow rowHeadOne = spreadsheet.createRow(0);
            HSSFRow rowHeadTwo = spreadsheet.createRow(1);
            int start = n * 60000;
            int end = Math.min(list.size(), (n + 1) * 60000);
            List<T> listData = list.subList(start, end);
            int i = 0;
            while (i < listData.size()) {
                int columnIndex = 0;
                HSSFRow row = spreadsheet.createRow(i + 2);
                ExcelUtils.creatCell(table, reactMap, cellStyle, cellStyle2, flag, spreadsheet, rowHeadOne, rowHeadTwo, listData, i, columnIndex, row);
                flag = false;
                ++i;
            }
            ++n;
        }
        ExcelUtils.outPutFile(workbook, file);
    }

    private static <T> void creatCell(TableView<T> table, Map<String, String> reactMap, HSSFCellStyle cellStyle, HSSFCellStyle cellStyle2, boolean flag, HSSFSheet spreadsheet, HSSFRow rowHeadOne, HSSFRow rowHeadTwo, List<T> listData, int i, int columnIndex, HSSFRow row) throws IllegalAccessException, InvocationTargetException {
        int r = 0;
        while (r < table.getColumns().size()) {
            block36: {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    ObservableList listColumn = ((TableColumn)table.getColumns().get(r)).getColumns();
                    if (listColumn.size() == 0) {
                        String colId = ((TableColumn)table.getColumns().get(r)).getId();
                        HSSFCell cell = row.createCell(columnIndex);
                        cell.setCellStyle((CellStyle)cellStyle2);
                        cell.setCellType(CellType.STRING);
                        if (flag) {
                            rowHeadOne.createCell(columnIndex).setCellValue(((TableColumn)table.getColumns().get(r)).getText());
                            spreadsheet.addMergedRegion(new CellRangeAddress(0, 1, columnIndex, columnIndex));
                            rowHeadOne.getCell(columnIndex).setCellStyle(cellStyle);
                        }
                        ++columnIndex;
                        if (reactMap.get(colId) == null) {
                            cell.setCellValue((double)(i + 1));
                        } else if (reactMap.get(colId).isEmpty()) {
                            cell.setCellValue("");
                        } else {
                            Method method = null;
                            try {
                                method = listData.get(i).getClass().getMethod("get" + reactMap.get(colId), new Class[0]);
                            }
                            catch (NoSuchMethodException e) {
                                cell.setCellValue("");
                                e.printStackTrace();
                                break block36;
                            }
                            catch (SecurityException e) {
                                cell.setCellValue("");
                                e.printStackTrace();
                                break block36;
                            }
                            Object content = method.invoke(listData.get(i), new Object[0]);
                            if (content == null) {
                                cell.setCellValue("");
                            } else if (content instanceof Number) {
                                Number num = (Number)content;
                                if (num.doubleValue() > Double.MAX_VALUE) {
                                    cell.setCellValue(content.toString());
                                } else {
                                    BigDecimal decimal = new BigDecimal(String.valueOf(content));
                                    cell.setCellValue(decimal.doubleValue());
                                    cell.setCellType(CellType.NUMERIC);
                                }
                            } else {
                                cell.setCellValue(content.toString());
                            }
                        }
                    } else {
                        int x = 0;
                        while (x < listColumn.size()) {
                            block37: {
                                String colId = ((TableColumn)listColumn.get(x)).getId();
                                HSSFCell cell = row.createCell(x + columnIndex);
                                cell.setCellStyle((CellStyle)cellStyle2);
                                cell.setCellType(CellType.STRING);
                                if (flag) {
                                    if (x == 0) {
                                        rowHeadOne.createCell(x + columnIndex).setCellValue(((TableColumn)table.getColumns().get(r)).getText());
                                    } else {
                                        rowHeadOne.createCell(x + columnIndex).setCellValue("");
                                    }
                                    rowHeadTwo.createCell(x + columnIndex).setCellValue(((TableColumn)listColumn.get(x)).getText());
                                    if (x != 0 && x == listColumn.size() - 1) {
                                        spreadsheet.addMergedRegion(new CellRangeAddress(0, 0, columnIndex, x + columnIndex));
                                        rowHeadOne.getCell(columnIndex).setCellStyle(cellStyle);
                                    }
                                }
                                if (reactMap.get(colId) == null) {
                                    cell.setCellValue((double)(i + 1));
                                } else if (reactMap.get(colId).isEmpty()) {
                                    cell.setCellValue("");
                                } else {
                                    Method method = null;
                                    try {
                                        method = listData.get(i).getClass().getMethod("get" + reactMap.get(colId), new Class[0]);
                                    }
                                    catch (NoSuchMethodException e) {
                                        cell.setCellValue("");
                                        e.printStackTrace();
                                        break block37;
                                    }
                                    catch (SecurityException e) {
                                        cell.setCellValue("");
                                        e.printStackTrace();
                                        break block37;
                                    }
                                    Object content = method.invoke(listData.get(i), new Object[0]);
                                    if (content == null) {
                                        cell.setCellValue("");
                                    } else if (content instanceof Number) {
                                        Number num = (Number)content;
                                        if (num.doubleValue() > Double.MAX_VALUE) {
                                            cell.setCellValue(content.toString());
                                        } else {
                                            BigDecimal decimal = new BigDecimal(String.valueOf(content));
                                            cell.setCellValue(decimal.doubleValue());
                                            cell.setCellType(CellType.NUMERIC);
                                        }
                                    } else {
                                        cell.setCellValue(content.toString());
                                    }
                                }
                            }
                            ++x;
                        }
                        columnIndex += listColumn.size();
                    }
                }
            }
            ++r;
        }
    }

    public static <T> void writeExcel(TableView<T> table, String name, int from, int to) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat df = workbook.createDataFormat();
        cellStyle.setDataFormat(df.getFormat("@"));
        int n = 0;
        while (n <= table.getItems().size() / 60000) {
            HSSFSheet spreadsheet = workbook.createSheet("sheet" + n);
            HSSFRow row = spreadsheet.createRow(0);
            int invisible = 0;
            int j = from;
            while (j < to + 1) {
                if (!((TableColumn)table.getColumns().get(j)).isVisible()) {
                    ++invisible;
                } else {
                    row.createCell(j - from - invisible).setCellValue(((TableColumn)table.getColumns().get(j)).getText());
                }
                ++j;
            }
            int start = n * 60000;
            int end = Math.min(table.getItems().size(), (n + 1) * 60000);
            List list2 = table.getItems().subList(start, end);
            int i = 1;
            while (i < list2.size() + 1) {
                row = spreadsheet.createRow(i);
                int invisible1 = 0;
                int j2 = from;
                while (j2 < to + 1) {
                    if (!((TableColumn)table.getColumns().get(j2)).isVisible()) {
                        ++invisible1;
                    } else {
                        Object ob = ((TableColumn)table.getColumns().get(j2)).getCellData(start + i - 1);
                        if (!(ob == null || ob.getClass().equals(Button.class) || ob.getClass().equals(ComboBox.class) || ob.getClass().equals(ArrayList.class) || ob.getClass().equals(HBox.class) || ob.getClass().equals(Label.class) || ob instanceof Boolean)) {
                            HSSFCell c;
                            if (ob instanceof Number) {
                                c = row.createCell(j2 - from - invisible1);
                                c.setCellType(CellType.STRING);
                                double d = ((Number)ob).doubleValue();
                                if (d > Double.MAX_VALUE) {
                                    c.setCellValue(ob.toString());
                                } else {
                                    BigDecimal bd = new BigDecimal(Double.toString(d));
                                    c.setCellValue(bd.doubleValue());
                                    c.setCellType(CellType.NUMERIC);
                                }
                            } else {
                                c = row.createCell(j2 - from - invisible1);
                                c.setCellStyle((CellStyle)cellStyle);
                                c.setCellValue(ob.toString());
                            }
                        }
                    }
                    ++j2;
                }
                ++i;
            }
            ++n;
        }
        ExcelUtils.saveFilePlatForm(workbook, name);
    }

    private static <T> void writeTwoHeadExcel(TableView<T> table, String name, int beginCol, int beginRow) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFCellStyle cellStyle2 = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        boolean flag = true;
        HSSFRow rowHeadOne = spreadsheet.createRow(0);
        HSSFRow rowHeadTwo = spreadsheet.createRow(1);
        HSSFRow row = null;
        int i = beginRow;
        while (i < table.getItems().size()) {
            int totalNum = 0;
            row = spreadsheet.createRow(i + 2);
            int r = beginCol;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    ObservableList list = ((TableColumn)table.getColumns().get(r)).getColumns();
                    int x = beginCol;
                    while (x < list.size()) {
                        Object ob = ((TableColumn)list.get(x)).getCellData(i);
                        if (ob.getClass().equals(Button.class)) {
                            row.createCell(x + totalNum).setCellValue(((Button)ob).getText());
                        } else if (ob.getClass().equals(ComboBox.class)) {
                            row.createCell(x + totalNum).setCellValue(((ComboBox)ob).getValue().toString());
                        } else if (ob instanceof Number) {
                            HSSFDataFormat df = workbook.createDataFormat();
                            cellStyle2.setDataFormat(df.getFormat("@"));
                            HSSFCell c = row.createCell(x + totalNum);
                            double d = ((Number)ob).doubleValue();
                            if (d > Double.MAX_VALUE) {
                                c.setCellValue(ob.toString());
                            } else {
                                BigDecimal bd = new BigDecimal(Double.toString(d));
                                c.setCellValue(bd.doubleValue());
                                c.setCellType(CellType.NUMERIC);
                            }
                        } else {
                            row.createCell(x + totalNum).setCellValue(ob.toString());
                        }
                        if (flag) {
                            if (x == beginCol) {
                                rowHeadOne.createCell(x + totalNum).setCellValue(((TableColumn)table.getColumns().get(r)).getText());
                            } else {
                                rowHeadOne.createCell(x + totalNum).setCellValue("");
                            }
                            rowHeadTwo.createCell(x + totalNum).setCellValue(((TableColumn)list.get(x)).getText());
                            if (x == list.size() - 1) {
                                spreadsheet.addMergedRegion(new CellRangeAddress(0, 0, totalNum, x + totalNum));
                                rowHeadOne.getCell(totalNum).setCellStyle(cellStyle);
                            }
                        }
                        ++x;
                    }
                    totalNum += list.size();
                }
                ++r;
            }
            flag = false;
            ++i;
        }
        ExcelUtils.saveFile(workbook, name);
    }

    public static <T> void writeOneOrTwoHeadExcel(TableView<T> table, String name) throws Exception {
        ExcelUtils.writeOneOrTwoHeadExcel(table, name, 0, 0);
    }

    private static <T> void writeOneOrTwoHeadExcel(TableView<T> table, String name, int beginCol, int beginRow) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle styleCenter = workbook.createCellStyle();
        styleCenter.setAlignment(HorizontalAlignment.CENTER);
        HSSFDataFormat df = workbook.createDataFormat();
        HSSFCellStyle styleString = workbook.createCellStyle();
        styleString.setDataFormat(df.getFormat("@"));
        HSSFRow rowHeadOne = spreadsheet.createRow(0);
        HSSFRow rowHeadTwo = spreadsheet.createRow(1);
        HSSFRow row = null;
        boolean flag = true;
        int i = beginRow;
        while (i < table.getItems().size()) {
            int totalNum = 0;
            row = spreadsheet.createRow(i + 2);
            int r = beginCol;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    ObservableList list = ((TableColumn)table.getColumns().get(r)).getColumns();
                    TableColumn columnOne = (TableColumn)table.getColumns().get(r);
                    if (list == null || list.isEmpty()) {
                        if (flag) {
                            rowHeadOne.createCell(totalNum).setCellValue(columnOne.getText());
                            spreadsheet.addMergedRegion(new CellRangeAddress(0, 1, totalNum, totalNum));
                        }
                        ExcelUtils.setItemCellValue(workbook, row, totalNum, columnOne.getCellData(i), styleString);
                        ++totalNum;
                    } else {
                        if (flag) {
                            rowHeadOne.createCell(totalNum).setCellValue(columnOne.getText());
                            int lastCol = totalNum + list.size() - 1;
                            spreadsheet.addMergedRegion(new CellRangeAddress(0, 0, totalNum, lastCol));
                            rowHeadOne.getCell(totalNum).setCellStyle(styleCenter);
                        }
                        int x = beginCol;
                        while (x < list.size()) {
                            TableColumn columnTwo = (TableColumn)list.get(x);
                            if (flag) {
                                rowHeadTwo.createCell(x + totalNum).setCellValue(columnTwo.getText());
                            }
                            ExcelUtils.setItemCellValue(workbook, row, x + totalNum, columnTwo.getCellData(i), styleString);
                            ++x;
                        }
                        totalNum += list.size();
                    }
                }
                ++r;
            }
            flag = false;
            ++i;
        }
        ExcelUtils.saveFile(workbook, name);
    }

    private static void setItemCellValue(HSSFWorkbook workbook, HSSFRow row, int cellIndex, Object cellData, HSSFCellStyle styleString) {
        HSSFCell cell = row.createCell(cellIndex);
        cell.setCellStyle((CellStyle)styleString);
        if (cellData == null) {
            cell.setCellValue("");
        } else if (cellData instanceof List) {
            cell.setCellValue("");
        } else if (cellData instanceof Button) {
            cell.setCellValue(((Button)cellData).getText());
        } else if (cellData instanceof ComboBox) {
            cell.setCellValue(((ComboBox)cellData).getValue().toString());
        } else if (cellData instanceof Number) {
            double d = ((Number)cellData).doubleValue();
            if (d > Double.MAX_VALUE) {
                cell.setCellValue(cellData.toString());
            } else {
                BigDecimal bd = new BigDecimal(Double.toString(d));
                cell.setCellValue(bd.doubleValue());
                cell.setCellType(CellType.NUMERIC);
            }
        } else {
            cell.setCellValue(cellData.toString());
        }
    }

    public static <T> void basketWriteTwoHeadExcel(TableView<T> table, String name, int beginCol, int beginRow, TableColumn<T, Number> colAbWeight, TableColumn<T, Number> colPct) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet spreadsheet = workbook.createSheet();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        boolean flag = true;
        HSSFRow rowHeadOne = spreadsheet.createRow(0);
        HSSFRow rowHeadTwo = spreadsheet.createRow(1);
        HSSFRow row = null;
        int i = beginRow;
        while (i < table.getItems().size()) {
            int totalNum = 0;
            row = spreadsheet.createRow(i + 2);
            int r = beginCol;
            while (r < table.getColumns().size()) {
                if (((TableColumn)table.getColumns().get(r)).isVisible()) {
                    ObservableList list = ((TableColumn)table.getColumns().get(r)).getColumns();
                    int x = beginCol;
                    while (x < list.size()) {
                        Object ob = ((TableColumn)list.get(x)).getCellData(i);
                        if (ob.getClass().equals(Button.class)) {
                            row.createCell(x + totalNum).setCellValue(((Button)ob).getText());
                        } else if (ob.getClass().equals(ComboBox.class)) {
                            row.createCell(x + totalNum).setCellValue(((ComboBox)ob).getValue().toString());
                        } else if (ob instanceof Number) {
                            HSSFCell c = row.createCell(x + totalNum);
                            c.setCellType(CellType.NUMERIC);
                            double d = ((Number)ob).doubleValue();
                            BigDecimal bd = new BigDecimal(Double.toString(d));
                            if (colAbWeight.getId().equals(((TableColumn)list.get(x)).getId())) {
                                c.setCellValue(String.valueOf(bd.toString()) + "%");
                            } else if (colPct.getId().equals(((TableColumn)list.get(x)).getId())) {
                                String percent = StringUtils.toPriceStr((double)Double.parseDouble(bd.toString()), (int)2);
                                c.setCellValue(String.valueOf(percent) + "%");
                            } else {
                                c.setCellValue(bd.toString());
                            }
                        } else {
                            row.createCell(x + totalNum).setCellValue(ob.toString());
                        }
                        if (flag) {
                            if (x == beginCol) {
                                rowHeadOne.createCell(x + totalNum).setCellValue(((TableColumn)table.getColumns().get(r)).getText());
                            } else {
                                rowHeadOne.createCell(x + totalNum).setCellValue("");
                            }
                            rowHeadTwo.createCell(x + totalNum).setCellValue(((TableColumn)list.get(x)).getText());
                            if (x == list.size() - 1) {
                                spreadsheet.addMergedRegion(new CellRangeAddress(0, 0, totalNum, x + totalNum));
                                rowHeadOne.getCell(totalNum).setCellStyle(cellStyle);
                            }
                        }
                        ++x;
                    }
                    totalNum += list.size();
                }
                ++r;
            }
            flag = false;
            ++i;
        }
        ExcelUtils.saveFile(workbook, name);
    }

    private static void saveFile(HSSFWorkbook workbook, String name) throws Exception {
        int lastIndexOf;
        FileChooser chooser = new FileChooser();
        File cacheFile = new File("cache.txt");
        if (cacheFile.exists()) {
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileInputStream inputStream = new FileInputStream(cacheFile);){
                byte[] b = new byte[(int)cacheFile.length()];
                ((InputStream)inputStream).read(b);
                File directory = new File(new String(b));
                if (directory.exists()) {
                    chooser.setInitialDirectory(directory);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if ((lastIndexOf = name.lastIndexOf(".")) == -1) {
            name = String.valueOf(name) + ".xls";
        }
        lastIndexOf = name.lastIndexOf(".");
        String format = name.substring(lastIndexOf + 1, name.length());
        ExcelUtils.extensionFilters(chooser, format);
        chooser.setInitialFileName(name);
        File file = chooser.showSaveDialog(null);
        FileOutputStream out = null;
        try {
            if (file != null) {
                out = new FileOutputStream(file);
                workbook.write((OutputStream)out);
                workbook.close();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        if (file != null) {
            Throwable e = null;
            Object var9_17 = null;
            try (FileOutputStream o = new FileOutputStream(cacheFile);){
                byte[] b = file.getParent().getBytes();
                ((OutputStream)o).write(b);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
    }

    public static File saveFile(String name) {
        Throwable throwable;
        FileChooser chooser = new FileChooser();
        int lastIndexOf = name.lastIndexOf(".");
        String format = name.substring(lastIndexOf + 1, name.length());
        ExcelUtils.extensionFilters(chooser, format);
        chooser.selectedExtensionFilterProperty().set((Object)filter.get(XLS));
        File cacheFile = new File("cache.txt");
        if (cacheFile.exists()) {
            try {
                Throwable throwable2 = null;
                throwable = null;
                try (FileInputStream inputStream = new FileInputStream(cacheFile);){
                    byte[] b = new byte[(int)cacheFile.length()];
                    ((InputStream)inputStream).read(b);
                    File directory = new File(new String(b));
                    if (directory.exists()) {
                        chooser.setInitialDirectory(directory);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        chooser.setInitialFileName(name);
        File file = chooser.showSaveDialog(null);
        if (file != null) {
            try {
                throwable = null;
                Object var7_12 = null;
                try (FileOutputStream o = new FileOutputStream(cacheFile);){
                    byte[] b = file.getParent().getBytes();
                    ((OutputStream)o).write(b);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return file;
    }

    private static void outPutFile(HSSFWorkbook workbook, File file) throws Exception {
        FileOutputStream out = null;
        try {
            if (file != null) {
                out = new FileOutputStream(file);
                workbook.write((OutputStream)out);
                workbook.close();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
    }

    private static void extensionFilters(FileChooser chooser, String fileformat) {
        for (String key : filter.keySet()) {
            chooser.getExtensionFilters().add((Object)filter.get(key));
        }
        FileChooser.ExtensionFilter value = filter.get(fileformat.toUpperCase());
        if (value == null) {
            value = filter.get(ALL);
        }
        chooser.selectedExtensionFilterProperty().set((Object)value);
    }

    public static void saveFile(InputStream stream, String name) throws Exception, MException {
        FileChooser chooser = new FileChooser();
        chooser.setInitialFileName(name);
        File cacheFile = new File("cache.txt");
        if (cacheFile.exists()) {
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileInputStream inputStream = new FileInputStream(cacheFile);){
                byte[] b = new byte[(int)cacheFile.length()];
                ((InputStream)inputStream).read(b);
                File directory = new File(new String(b));
                if (directory.exists()) {
                    chooser.setInitialDirectory(directory);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        int lastIndexOf = name.lastIndexOf(".");
        String format = name.substring(lastIndexOf + 1, name.length());
        ExcelUtils.extensionFilters(chooser, format);
        File file = chooser.showSaveDialog(null);
        if (file == null) {
            throw new MException(1, "\u53d6\u6d88\u4e0b\u8f7d");
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        int len = -1;
        try {
            byte[] bytes = new byte[1024];
            while ((len = stream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, len);
            }
            outputStream.flush();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
        if (file != null) {
            Throwable e = null;
            Object var10_19 = null;
            try (FileOutputStream o = new FileOutputStream(cacheFile);){
                byte[] b = file.getParent().getBytes();
                ((OutputStream)o).write(b);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
    }

    public static File saveFile(byte[] bytes, String name) throws Exception, MException {
        File file;
        FileChooser chooser = new FileChooser();
        chooser.setInitialFileName(name);
        int lastIndexOf = name.lastIndexOf(".");
        String format = name.substring(lastIndexOf + 1, name.length());
        ExcelUtils.extensionFilters(chooser, format);
        File cacheFile = new File("cache.txt");
        if (cacheFile.exists()) {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileInputStream inputStream = new FileInputStream(cacheFile);){
                byte[] b = new byte[(int)cacheFile.length()];
                ((InputStream)inputStream).read(b);
                File directory = new File(new String(b));
                if (directory.exists()) {
                    chooser.setInitialDirectory(directory);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if ((file = chooser.showSaveDialog(null)) == null) {
            throw new MException(1, "\u53d6\u6d88\u4e0b\u8f7d");
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ((OutputStream)outputStream).write(bytes);
            outputStream.flush();
        }
        if (file != null) {
            Throwable e = null;
            Object var9_15 = null;
            try (FileOutputStream o = new FileOutputStream(cacheFile);){
                byte[] b = file.getParent().getBytes();
                ((OutputStream)o).write(b);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        return file;
    }

    public static <T> void writeExcel(TableView<T> table, List<?> list, String name) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat df = workbook.createDataFormat();
        cellStyle.setDataFormat(df.getFormat("@"));
        int n = 0;
        while (n <= list.size() / 60000) {
            HSSFSheet spreadsheet = workbook.createSheet("sheet" + n);
            HSSFRow row = spreadsheet.createRow(0);
            int j = 0;
            while (j < table.getColumns().size()) {
                row.createCell(j).setCellValue(((TableColumn)table.getColumns().get(j)).getText());
                ++j;
            }
            int start = n * 60000;
            int end = Math.min(list.size(), (n + 1) * 60000);
            List<?> list2 = list.subList(start, end);
            int i = 1;
            while (i <= list2.size()) {
                row = spreadsheet.createRow(i);
                int j2 = 0;
                while (j2 < table.getColumns().size()) {
                    block14: {
                        Object ob = null;
                        Class<?> clazz = list2.get(i - 1).getClass();
                        try {
                            if (StringUtils.isEmpty((String)((TableColumn)table.getColumns().get(j2)).getId())) break block14;
                            Method method = clazz.getMethod("get" + ExcelUtils.capitalize(((TableColumn)table.getColumns().get(j2)).getId()), new Class[0]);
                            ob = method.invoke(list2.get(i - 1), new Object[0]);
                        }
                        catch (NoSuchMethodException | SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        if (!(ob == null || ob.getClass().equals(Button.class) || ob.getClass().equals(ComboBox.class) || ob.getClass().equals(HBox.class))) {
                            HSSFCell c;
                            if (ob instanceof Number) {
                                c = row.createCell(j2);
                                c.setCellType(CellType.STRING);
                                double d = ((Number)ob).doubleValue();
                                if (d > Double.MAX_VALUE) {
                                    c.setCellValue(ob.toString());
                                } else {
                                    BigDecimal bd = new BigDecimal(Double.toString(d));
                                    c.setCellValue(bd.doubleValue());
                                    c.setCellType(CellType.NUMERIC);
                                }
                            } else {
                                c = row.createCell(j2);
                                c.setCellStyle((CellStyle)cellStyle);
                                c.setCellValue(ob.toString());
                            }
                        }
                    }
                    ++j2;
                }
                ++i;
            }
            ++n;
        }
        ExcelUtils.saveFilePlatForm(workbook, name);
    }

    private static void saveFilePlatForm(HSSFWorkbook workbook, String name) throws Exception {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("JavaFX Application Thread")) {
            ExcelUtils.saveFile(workbook, name);
            return;
        }
        FutureTask<MEvent> saveTask = new FutureTask<MEvent>(() -> {
            try {
                ExcelUtils.saveFile(workbook, name);
                return new MEvent(1, "\u5bfc\u51fa\u6210\u529f");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new MEvent(-1, "\u5bfc\u51fa\u5931\u8d25," + e.getMessage());
            }
        });
        Platform.runLater(saveTask);
        MEvent res = saveTask.get();
        if (res.getCode() != 1) {
            throw new Exception(res.getDesc());
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }
}

