/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class DatePickerUtils {
    public static void setDateLimit(DatePicker start, DatePicker end, boolean canSameDate) {
        DatePickerUtils.setDateLimit(start, end, canSameDate, false, false);
    }

    public static void setDateLimit(final DatePicker start, final DatePicker end, final boolean canSameDate, final boolean isHistory, final boolean containToday) {
        Callback<DatePicker, DateCell> dayCellFactoryEnd = new Callback<DatePicker, DateCell>(){

            public DateCell call(DatePicker datePicker) {
                return new DateCell(){

                    public void updateItem(LocalDate item, boolean empty) {
                        boolean history;
                        super.updateItem(item, empty);
                        if (start.getValue() == null) {
                            return;
                        }
                        LocalDate today = LocalDate.now().minusDays(containToday ? 0 : 1);
                        LocalDate startBefore = ((LocalDate)start.getValue()).plusDays(canSameDate ? 0 : 1);
                        boolean bl = history = isHistory ? item.isAfter(today) : false;
                        if (history || item.isBefore(startBefore)) {
                            this.setDisable(true);
                        }
                    }
                };
            }
        };
        Callback<DatePicker, DateCell> dayCellFactoryStart = new Callback<DatePicker, DateCell>(){

            public DateCell call(DatePicker datePicker) {
                return new DateCell(){

                    public void updateItem(LocalDate item, boolean empty) {
                        boolean history;
                        super.updateItem(item, empty);
                        if (end.getValue() == null) {
                            return;
                        }
                        LocalDate today = LocalDate.now().plusDays(containToday ? 0 : 1);
                        LocalDate endAfter = ((LocalDate)end.getValue()).minusDays(canSameDate ? 0 : 1);
                        boolean bl = history = isHistory ? item.isAfter(today) : false;
                        if (history || item.isAfter(endAfter)) {
                            this.setDisable(true);
                        }
                    }
                };
            }
        };
        start.setDayCellFactory((Callback)dayCellFactoryStart);
        end.setDayCellFactory((Callback)dayCellFactoryEnd);
        start.setEditable(false);
        end.setEditable(false);
        start.getEditor().setDisable(true);
        end.getEditor().setDisable(true);
    }

    public static void setFormat(DatePicker dp, String format) {
        StringConverter<LocalDate> converter = new StringConverter<LocalDate>(format){
            DateTimeFormatter dateFormatter;
            {
                this.dateFormatter = DateTimeFormatter.ofPattern(string);
            }

            public String toString(LocalDate date) {
                if (date == null) {
                    return "";
                }
                return this.dateFormatter.format(date);
            }

            public LocalDate fromString(String string) {
                if (string == null || string.isEmpty()) {
                    return null;
                }
                return LocalDate.parse(string, this.dateFormatter);
            }
        };
        dp.setConverter((StringConverter)converter);
    }

    public static void setDaysLaterLimit(DatePicker dp, final int days) {
        Callback<DatePicker, DateCell> dayCellFactory = new Callback<DatePicker, DateCell>(){

            public DateCell call(final DatePicker datePicker) {
                return new DateCell(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem(item, empty);
                        if (datePicker.getValue() == null) {
                            return;
                        }
                        LocalDate today = LocalDate.now();
                        LocalDate endDay = today.plusDays(days);
                        boolean history = item.isBefore(today);
                        if (history || item.isAfter(endDay)) {
                            this.setDisable(true);
                        }
                    }
                };
            }
        };
        dp.setDayCellFactory((Callback)dayCellFactory);
    }

    public static void setDaysLaterTrading(DatePicker dp, final String beginDay) {
        Callback<DatePicker, DateCell> dayCellFactory = new Callback<DatePicker, DateCell>(){

            public DateCell call(final DatePicker datePicker) {
                return new DateCell(){

                    public void updateItem(LocalDate item, boolean empty) {
                        super.updateItem(item, empty);
                        if (datePicker.getValue() == null) {
                            return;
                        }
                        LocalDate today = LocalDate.parse(beginDay);
                        boolean history = item.isBefore(today);
                        if (history) {
                            this.setDisable(true);
                        }
                    }
                };
            }
        };
        dp.setDayCellFactory((Callback)dayCellFactory);
    }
}

