/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.utils;

import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ConsumerModel {
    private static final Logger logger = LogManager.getLogger(ConsumerModel.class);
    private boolean running = false;
    @Inject
    private ExecutorService exe;

    public void consume(Runnable command, int recoveryTime) {
        if (!this.running) {
            this.start();
            this.exe.execute(command);
            this.resume(recoveryTime);
        }
    }

    private void resume(int second) {
        if (second < 0) {
            return;
        }
        this.exe.execute(() -> {
            try {
                Thread.sleep(second * 1000);
                this.end();
            }
            catch (InterruptedException e) {
                logger.error("ConsumerModel InterruptedException" + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    private void start() {
        this.running = true;
    }

    private void end() {
        this.running = false;
    }
}

