/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.table;

import javafx.scene.control.TableCell;

public class ZeroDoubleTableCell<S>
extends TableCell<S, Number> {
    private String sDFPrice = "%1$,.3f";

    public ZeroDoubleTableCell() {
    }

    public ZeroDoubleTableCell(int scale) {
        this.sDFPrice = "%1$,." + scale + "f";
    }

    public void updateItem(Number item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            if (item != null) {
                if (item.doubleValue() == 0.0) {
                    this.setText(null);
                } else {
                    this.setText(String.format(this.sDFPrice, item));
                }
            }
        } else {
            this.setText(null);
        }
    }
}

