/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.control.table;

import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;

public abstract class TooltipTableCell<S, T>
extends TableCell<S, T> {
    private boolean sync = true;

    public TooltipTableCell() {
    }

    public TooltipTableCell(boolean sync) {
        this.sync = sync;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        String txt = null;
        Tooltip tooltip = null;
        if (!empty) {
            String info = this.tooltip();
            if (!"".equals(item) && info != null && !info.isEmpty()) {
                tooltip = new Tooltip();
                tooltip.setText(info);
                tooltip.setMaxWidth(400.0);
                tooltip.setWrapText(true);
                txt = this.sync ? info : String.valueOf(item);
            }
        }
        this.setText(txt);
        this.setTooltip(tooltip);
    }

    public abstract String tooltip();

    public S getValue() {
        return (S)this.getTableRow().getItem();
    }
}

